/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi;

import javax.resource.ResourceException;

/**
 * An optioanl mixin interface for connection managers that support the lazy connection
 * enlistment optimization.
 */
public interface LazyEnlistableConnectionManager
{
   /**
    * Invoked by a resource adapter to lazily enlist a connection handle with the managed connection
    *
    * @param mc the managed connection
    * @throws ResourceException for an generic error
    * @throws ApplicationServerInternalException for problems in the application server
    * @throws ResourceAllocationException for problems allocating resources
    * @throws ResourceAdapterInternalException for errors from the resource adapter 
    */
   void lazyEnlist(ManagedConnection mc) throws ResourceException;
}