/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.resource.spi;

import java.beans.PropertyDescriptor;

import javax.resource.ResourceException;

import org.jboss.util.id.SerialVersion;

/**
 * Represents invalid configuration properties
 */
public class InvalidPropertyException extends ResourceException
{
   /** @since 4.0.2 */ 
   static final long serialVersionUID;
   static
   {
      if (SerialVersion.version == SerialVersion.LEGACY)
         serialVersionUID = -2395559483586818078L;
      else
         serialVersionUID = -485903720300735741L;
   }

   /** The invalidProperties */
   private PropertyDescriptor[] invalidProperties;
   
   /**
	 * Create an invalid property exception.
	 */
   public InvalidPropertyException()
   {
      super();
   }

   /**
	 * Create an invalid property exception with a reason.
	 * 
	 * @param reason the reason
	 */
   public InvalidPropertyException(String reason)
   {
      super(reason);
   }

   /**
	 * Create an invalid property exception with a reason and an errorCode.
	 * 
	 * @param reason the reason
	 * @param errorCode the error code
	 */
   public InvalidPropertyException(String reason, String errorCode)
   {
      super(reason, errorCode);
   }

   /**
	 * Create an invalid property exception with a reason and an error.
	 * 
	 * @param reason the reason
	 * @param throwable the error
	 */
   public InvalidPropertyException(String reason, Throwable throwable)
   {
      super(reason, throwable);
   }

   /**
	 * Create an invalid property exception with an error.
	 * 
	 * @param throwable the error
	 */
   public InvalidPropertyException(Throwable throwable)
   {
      super(throwable);
   }

   /**
    * Get the invalid property descriptors
    *
    * @return an array of invalid property descriptors
    */
   public PropertyDescriptor[] getInvalidPropertyDescriptors()
   {
      return invalidProperties;
   }

   /**
    * Set the invalid property descriptors
    *
    * @param an array of invalid property descriptors
    */
   public void setInvalidPropertyDescriptors(PropertyDescriptor[] invalidProperties)
   {
      this.invalidProperties = invalidProperties;
   }
}