/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tm.iiop.client;

import org.omg.CORBA.LocalObject;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ORBInitializer;

/**
 * This is an <code>org.omg.PortableInterceptor.ORBInitializer</code> that
 * initializes the <code>TransactionCurrent</code>.
 *
 * @author  <a href="mailto:reverbel@ime.usp.br">Francisco Reverbel</a>
 * @version $Revision:1$
 */
public class TransactionCurrentInitializer
      extends LocalObject
      implements ORBInitializer
{

   public TransactionCurrentInitializer()
   {
      // do nothing
   }

   // org.omg.PortableInterceptor.ORBInitializer operations ---------

   public void pre_init(ORBInitInfo info)
   {
      try
      {
         info.register_initial_reference("TransactionCurrent",
                                         TransactionCurrent.getInstance());
      }
      catch (InvalidName e)
      {
         throw new RuntimeException("Could not register initial " +
                                    "reference for TransactionCurrent: " + e);
      }
   }

   public void post_init(ORBInitInfo info)
   {
      try
      {
         org.omg.CORBA.Object obj = 
            info.resolve_initial_references("NameService");
         NamingContextExt rootContext = NamingContextExtHelper.narrow(obj);
         TransactionCurrent.init(rootContext);
      } 
      catch (Exception e) 
      {
         throw new RuntimeException("Unexpected " + e);
      }
   }

}
