/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
 
package org.jboss.iiop.jacorb;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;

import org.jboss.iiop.CorbaORBService;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityDomain;
import org.jboss.security.ssl.DomainSocketFactory;
import org.jboss.system.Registry;

/**
 * This implementation of the JacORB-specific interface 
 * <code>org.jacorb.orb.factory.SocketFactory</code> uses the JSSE
 * KeyManagerFactory and TrustManagerFactory objects encapsulated by 
 * a JBossSX SecurityDomain. It looks up the 
 * <code>org.jboss.security.SecurityDomain</code> instance bound to the 
 * name <code>CorbaORBService.SSL_DOMAIN</code> in the JBoss registry.
 *
 * @author <a href="mailto:reverbel@ime.usp.br">Francisco Reverbel</a>
 * @version $Revision:1$
 */
public class SSLSocketFactory 
   implements org.jacorb.orb.factory.SocketFactory,
              org.apache.avalon.framework.configuration.Configurable
{    
   // Static --------------------------------------------------------

   private static Logger log = Logger.getLogger(SSLSocketFactory.class);

   // Attributes ----------------------------------------------------

   private DomainSocketFactory domainFactory = null;
   private String[] cipher_suites = null;
   
   // Constructor ---------------------------------------------------

   public SSLSocketFactory(org.jacorb.orb.ORB orb) 
      throws IOException
   {
      log.info("Creating");

      SecurityDomain securityDomain = 
         (SecurityDomain)Registry.lookup(CorbaORBService.SSL_DOMAIN);

      try
      {
         domainFactory = new DomainSocketFactory(securityDomain);
      }
      catch (IOException e)
      {
         log.warn("Could not create DomainSocketFactory: " + e);
         if (log.isDebugEnabled())
            log.debug("Exception creating DomainSockedFactory: ", e);
         throw e;
      }
   }
   
   // JacORB SSLSocketFactory implementation ------------------------
   // (interface org.jacorb.orb.factory.SSLSocketFactory)

   public Socket createSocket(String host, int port)
      throws IOException, UnknownHostException
   {       
      return domainFactory.createSocket(host, port);
   }
   
   public boolean isSSL (java.net.Socket s)
   { 
      return (s instanceof SSLSocket); 
   }
   
   // Avalon Configurable implementation ----------------------------
   
   public void configure(
         org.apache.avalon.framework.configuration.Configuration configuration)
      throws org.apache.avalon.framework.configuration.ConfigurationException
   {
      // no-op
   }

}
