/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.iiop.csiv2;

import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ORBInitInfo;

import org.omg.IOP.Codec;
import org.omg.IOP.Encoding;
import org.omg.IOP.ENCODING_CDR_ENCAPS;

import org.jacorb.ssl.SSL_POLICY_TYPE;
import org.jacorb.security.ssl.SSLPolicyFactory;

/**
 * Implements an <code>org.omg.PortableInterceptor.ORBinitializer</code> that
 * installs a <code>CSIv2IORInterceptor</code> and a 
 * <code>CSIv2PolicyFactory</code>.
 *
 * @author  <a href="mailto:reverbel@ime.usp.br">Francisco Reverbel</a>
 * @version $Revision:1$
 */
public class CSIv2Initializer 
      extends LocalObject
      implements ORBInitializer
{
   /** @since 4.0.1 */
   static final long serialVersionUID = -8495218171624437198L;
   public CSIv2Initializer() 
   {
      // do nothing
   }

   // org.omg.PortableInterceptor.ORBInitializer operations -------------------

   public void pre_init(ORBInitInfo info) 
   {
      // do nothing
   }
   
   public void post_init(ORBInitInfo info) 
   {
      try {
         // Use CDR encapsulation with GIOP 1.0 encoding
         Encoding encoding = new Encoding(ENCODING_CDR_ENCAPS.value, 
                                          (byte)1, /* GIOP version */
                                          (byte)0  /* GIOP revision*/);
         Codec codec = info.codec_factory().create_codec(encoding);

         // Add IOR interceptor for CSIv2
         info.add_ior_interceptor(new CSIv2IORInterceptor(codec));

         // Register CSIv2-related policy factories
         info.register_policy_factory(CSIv2Policy.TYPE,
                                      new CSIv2PolicyFactory(codec));
         info.register_policy_factory(SSL_POLICY_TYPE.value,
                                      new SSLPolicyFactory());
      }
      catch (Exception e) {
         throw new RuntimeException("Unexpected " + e);
      }
   }
}
