/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.resource.metadata;

import java.io.Serializable;
import java.util.Locale;

/**
 * Security Permission meta data
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class SecurityPermissionMetaData extends DescriptionMetaDataContainer
{
   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------

   /** The security permission spec */
   private String securityPermissionSpec;
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------

   /**
    * Get the security permission spec
    * 
    * @return the security permission spec
    */
   public String getSecurityPermissionSpec()
   {
      return securityPermissionSpec;
   }

   /**
    * Set the security permission spec
    * 
    * @param securityPermissionSpec the spec
    */
   public void setSecurityPermissionSpec(String securityPermissionSpec)
   {
      this.securityPermissionSpec = securityPermissionSpec;
   }
   
   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      StringBuffer buffer = new StringBuffer();
      buffer.append("SecurityPermissionMetaData").append('@');
      buffer.append(Integer.toHexString(System.identityHashCode(this)));
      buffer.append("[spec=").append(securityPermissionSpec);
      buffer.append(" descriptions=").append(getDescriptions());
      buffer.append(']');
      return buffer.toString();
   }
   
   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}
