/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.resource.metadata;

import java.io.Serializable;
import java.util.Locale;

/**
 * Description group meta data
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class DescriptionGroupMetaData implements Serializable
{
   static final long serialVersionUID = 1324619949051028127L;
   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------

   /** The language */
   private String lang;
   
   /** The description */
   private String description;
   
   /** The display name */
   private String displayName;
   
   /** The small icon */
   private String smallIcon;
   
   /** The large icon */
   private String largeIcon;
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------

   /**
    * Create a new description group meta data using the default langugage
    */
   public DescriptionGroupMetaData()
   {
      this(null);
   }

   /**
    * Create a new description group meta data
    * 
    * @parm lang the language
    */
   public DescriptionGroupMetaData(String lang)
   {
      if (lang == null)
         this.lang = Locale.getDefault().getLanguage();
      else
         this.lang = lang;
   }
   
   // Public --------------------------------------------------------

   /**
    * Get the language
    * 
    * @return the language
    */
   public String getLanguage()
   {
      return lang;
   }

   /**
    * Get the description
    * 
    * @return the description
    */
   public String getDescription()
   {
      return description;
   }

   /**
    * Set the description
    * 
    * @param description the description
    */
   public void setDescription(String description)
   {
      this.description = description;
   }

   /**
    * Get the display name
    * 
    * @return the display name
    */
   public String getDisplayName()
   {
      return displayName;
   }

   /**
    * Set the display name
    * 
    * @param displayName the display name
    */
   public void setDisplayName(String displayName)
   {
      this.displayName = displayName;
   }

   /**
    * Get the small icon
    * 
    * @return the small icon
    */
   public String getSmallIcon()
   {
      return smallIcon;
   }

   /**
    * Set the small icon
    * 
    * @param icon the icon
    */
   public void setSmallIcon(String icon)
   {
      this.smallIcon = icon;
   }

   /**
    * Get the large icon
    * 
    * @return the large icon
    */
   public String getLargeIcon()
   {
      return largeIcon;
   }

   /**
    * Set the large icon
    * 
    * @param icon the icon
    */
   public void setLargeIcon(String icon)
   {
      this.largeIcon = icon;
   }
   
   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      StringBuffer buffer = new StringBuffer();
      buffer.append("DescriptionGroupMetaData").append('@');
      buffer.append(Integer.toHexString(System.identityHashCode(this)));
      buffer.append("[language=").append(lang);
      if (description != null)
         buffer.append(" description=").append(description);
      if (displayName != null)
         buffer.append(" displayName=").append(displayName);
      if (smallIcon != null)
         buffer.append(" smallIcon=").append(smallIcon);
      if (largeIcon != null)
         buffer.append(" largeIcon=").append(largeIcon);
      buffer.append(']');
      return buffer.toString();
   }
   
   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}
