/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.resource.metadata;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;

/**
 * Connection Definition meta data
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class ConnectionDefinitionMetaData extends ConfigPropertyMetaDataContainer
{
   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------

   /** The connector metadata */
   private ConnectorMetaData cmd;
   
   /** The managed connection factory class */
   private String managedConnectionFactoryClass;

   /** The connection factory interface class */
   private String connectionFactoryInterfaceClass;

   /** The connection factory implementation class */
   private String connectionFactoryImplementationClass;

   /** The connection interface class */
   private String connectionInterfaceClass;

   /** The connection implementation class */
   private String connectionImplementationClass;
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   
   public ConnectionDefinitionMetaData(ConnectorMetaData cmd)
   {
      this.cmd = cmd;
   }
   
   // Public --------------------------------------------------------

   /**
    * Get the connector
    * 
    * @return the connector
    */
   public ConnectorMetaData getConnector()
   {
      return cmd;
   }
   
   /**
    * Get the managed connection factory class
    * 
    * @return the managed connection factory class
    */
   public String getManagedConnectionFactoryClass()
   {
      return managedConnectionFactoryClass;
   }

   /**
    * Set the managed connection factory class
    * 
    * @param managedConnectionFactoryClass the class name
    */
   public void setManagedConnectionFactoryClass(String managedConnectionFactoryClass)
   {
      this.managedConnectionFactoryClass = managedConnectionFactoryClass;
   }

   /**
    * Get the connection factory interface class
    * 
    * @return the connection factory interface class
    */
   public String getConnectionFactoryInterfaceClass()
   {
      return connectionFactoryInterfaceClass;
   }

   /**
    * Set the connection factory interface class
    * 
    * @param connectionFactoryInterfaceClass the class name
    */
   public void setConnectionFactoryInterfaceClass(String connectionFactoryInterfaceClass)
   {
      this.connectionFactoryInterfaceClass = connectionFactoryInterfaceClass;
   }

   /**
    * Get the connection factory implementation class
    * 
    * @return the connection factory implementation class
    */
   public String getConnectionFactoryImplementationClass()
   {
      return connectionFactoryImplementationClass;
   }

   /**
    * Set the connection factory implementation class
    * 
    * @param connectionFactoryImplementationClass the class name
    */
   public void setConnectionFactoryImplementationClass(String connectionFactoryImplementationClass)
   {
      this.connectionFactoryImplementationClass = connectionFactoryImplementationClass;
   }

   /**
    * Get the connection interface class
    * 
    * @return the connection interface class
    */
   public String getConnectionInterfaceClass()
   {
      return connectionInterfaceClass;
   }

   /**
    * Set the connection interface class
    * 
    * @param connectionInterfaceClass the class name
    */
   public void setConnectionInterfaceClass(String connectionInterfaceClass)
   {
      this.connectionInterfaceClass = connectionInterfaceClass;
   }

   /**
    * Get the connection implementation class
    * 
    * @return the connection implementation class
    */
   public String getConnectionImplementationClass()
   {
      return connectionImplementationClass;
   }

   /**
    * Set the connection implementation class
    * 
    * @param connectionImplementationClass the class name
    */
   public void setConnectionImplementationClass(String connectionImplementationClass)
   {
      this.connectionImplementationClass = connectionImplementationClass;
   }
   
   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      StringBuffer buffer = new StringBuffer();
      buffer.append("ConnectionDefinitionMetaData").append('@');
      buffer.append(Integer.toHexString(System.identityHashCode(this)));
      buffer.append("[managedConnectionFactoryClass=").append(managedConnectionFactoryClass);
      buffer.append(" connectionFactoryInterfaceClass=").append(connectionFactoryInterfaceClass);
      buffer.append(" connectionFactoryImplementationClass=").append(connectionFactoryImplementationClass);
      buffer.append(" connectionInterfaceClass=").append(connectionInterfaceClass);
      buffer.append(" connectionImplementationClass=").append(connectionImplementationClass);
      buffer.append(" properties=").append(getProperties());
      buffer.append(']');
      return buffer.toString();
   }
   
   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}
