/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.resource.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

/**
 * An abstract class for meta data that have config properties
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class ConfigPropertyMetaDataContainer implements Serializable
{
   static final long serialVersionUID = 2891949219806920844L;
   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------
   
   /** The properties by name */
   private HashSet properties = new HashSet();
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------
   
   /**
    * Add a property
    * 
    * @param cpmd the property
    */
   public void addProperty(ConfigPropertyMetaData cpmd)
   {
      properties.add(cpmd);
   }
   
   /**
    * Get the properties
    * 
    * @return the properties
    */
   public Collection getProperties()
   {
      return properties;
   }
   
   /**
    * Get the property for a name
    * 
    * @param name the name
    * @return the property or null if there is no property with that name
    */
   public ConfigPropertyMetaData getProperty(String name)
   {
      for (Iterator i = properties.iterator(); i.hasNext();)
      {
         ConfigPropertyMetaData cpmd = (ConfigPropertyMetaData) i.next();
         if (cpmd.getName().equals(name))
            return cpmd;
      }
      return null;
   }
   
   // Object overrides ----------------------------------------------
   
   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}
