/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.resource.metadata;

import java.io.Serializable;
import java.util.Locale;

/**
 * Config property meta data
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class ConfigPropertyMetaData extends DescriptionMetaDataContainer
{
   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------

   /** The name */
   private String name;
   
   /** The type */
   private String type = "java.lang.String";
   
   /** The value */
   private String value = "";
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------

   /**
    * Get the name
    * 
    * @return the name
    */
   public String getName()
   {
      return name;
   }

   /**
    * Set the name
    * 
    * @param name the name
    */
   public void setName(String name)
   {
      this.name = name;
   }

   /**
    * Get the type
    * 
    * @return the type
    */
   public String getType()
   {
      return type;
   }

   /**
    * Set the type
    * 
    * @param type the type
    */
   public void setType(String type)
   {
      this.type = type;
   }

   /**
    * Get the value
    * 
    * @return the value
    */
   public String getValue()
   {
      return value;
   }

   /**
    * Set the value
    * 
    * @param value the value
    */
   public void setValue(String value)
   {
      this.value = value;
   }
   
   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      StringBuffer buffer = new StringBuffer();
      buffer.append("ConfigPropertyMetaData").append('@');
      buffer.append(Integer.toHexString(System.identityHashCode(this)));
      buffer.append("[name=").append(name);
      if (type != null)
         buffer.append(" type=").append(type);
      if (value != null)
         buffer.append(" value=").append(value);
      buffer.append(" descriptions=").append(getDescriptions());
      buffer.append(']');
      return buffer.toString();
   }
   
   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}
