/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.resource.metadata;

import java.io.Serializable;
import java.util.Locale;

/**
 * Authentication mechanism meta data
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class AuthenticationMechanismMetaData extends DescriptionMetaDataContainer
{
   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------

   /** The authentication mechanism type */
   private String authenticationMechanismType;

   /** The credential interface class */
   private String credentialInterfaceClass;
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------

   /**
    * Get the authentication mechanism type
    * 
    * @return the authentication mechanism type
    */
   public String getAuthenticationMechansimType()
   {
      return authenticationMechanismType;
   }

   /**
    * Set the authentication mechanism type
    * 
    * @param authenticationMechansimType the type
    */
   public void setAuthenticationMechansimType(String authenticationMechanismType)
   {
      this.authenticationMechanismType = authenticationMechanismType;
   }

   /**
    * Get the credential interface class
    * 
    * @return the credential interface class
    */
   public String getCredentialInterfaceClass()
   {
      return credentialInterfaceClass;
   }

   /**
    * Set the credential interface class
    * 
    * @param credentialInterfaceClass the class
    */
   public void setCredentialInterfaceClass(String credentialInterfaceClass)
   {
      this.credentialInterfaceClass = credentialInterfaceClass;
   }
   
   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      StringBuffer buffer = new StringBuffer();
      buffer.append("AuthenticationMechanismMetaData").append('@');
      buffer.append(Integer.toHexString(System.identityHashCode(this)));
      buffer.append("[authenticationMechanismType=").append(authenticationMechanismType);
      buffer.append(" credentialInterfaceClass=").append(credentialInterfaceClass);
      buffer.append(" descriptions=").append(getDescriptions());
      buffer.append(']');
      return buffer.toString();
   }
   
   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}
