/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.resource.deployment;

import javax.management.ObjectName;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;

import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SimpleSubDeployerSupport;
import org.jboss.xml.binding.ObjectModelFactory;

/**
 * A resource adapter deployer
 *
 * @jmx:mbean name="jboss.jca:service=RARDeployer"
 *            extends "org.jboss.deployment.SubDeployerMBean"
 *
 * @author  <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class RARDeployer extends SimpleSubDeployerSupport
   implements RARDeployerMBean
{
   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------
   
   /** The work manager name */
   protected ObjectName workManagerName;
   
   /** The work manager */
   protected WorkManager workManager;

   /** The xa terminator */
   protected XATerminator xaTerminator;

   /** The xa terminator name */
   protected ObjectName xaTerminatorName;
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------
   
   // SimpleSubDeployerSupport implementation -----------------------

   public String getExtension()
   {
      return "rar";
   }

   public String getMetaDataURL()
   {
      return "META-INF/ra.xml";
   }

   public String getObjectName(DeploymentInfo di) throws DeploymentException
   {
      String name = di.shortName;
      di = di.parent;
      while (di != null)
      {
         name = di.shortName + "#" + name;
         di = di.parent;
      }
      return "jboss.jca:service=RARDeployment,name='" + name + "'";
   }

   public String getDeploymentClass()
   {
      return RARDeployment.class.getName();
   }

   public ObjectModelFactory getObjectModelFactory()
   {
      return new ResourceAdapterObjectModelFactory();
   }

   // RARDeployerMBean implementation -------------------------------

   /**
    * Get the work manager name
    *
    * @jmx:managed-attribute
    * @return the work manager name
    */
   public ObjectName getWorkManagerName()
   {
      return workManagerName;
   }

   /**
    * Set the thread pool name
    *
    * @jmx:managed-attribute
    * @param workManagerName the work manager name
    */
   public void setWorkManagerName(ObjectName workManagerName)
   {
      this.workManagerName = workManagerName;
   }

   /**
    * Get the XATerminator
    *
    * @jmx:managed-attribute
    * @return the xa terminator
    */
   public ObjectName getXATerminatorName()
   {
      return xaTerminatorName;
   }

   /**
    * Set the xa terminator
    *
    * @jmx:managed-attribute
    * @param xaTerminatorName name the xa terminator name
    */
   public void setXATerminatorName(ObjectName xaTerminatorName)
   {
      this.xaTerminatorName = xaTerminatorName;
   }

   // ServiceMBeanSupport overrides ---------------------------------
   
   protected void startService() throws Exception
   {
      workManager = (WorkManager) server.getAttribute(workManagerName, "Instance");
      xaTerminator = (XATerminator) server.getAttribute(xaTerminatorName, "XATerminator");
      super.startService();
   }
   
   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}
