/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.resource.adapter.jdbc.remote;

import org.jboss.invocation.Invocation;
import org.jboss.proxy.Interceptor;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 * @version $Revision:1$
 */
public class StatementInterceptor extends Interceptor
{
   /**
    * Handle methods locally on the client
    *
    * @param mi
    * @return
    * @throws Throwable
    */
   public Object invoke(Invocation mi) throws Throwable
   {
      Method m = mi.getMethod();
      String methodName = m.getName();

      if (methodName.equals("setAsciiStream") ||
            methodName.equals("setBinaryStream"))
      {
         Object[] args = mi.getArguments();
         InputStream ins = (InputStream) args[1];
         args[1] = new SerializableInputStream(ins);
      }
      else if (methodName.equals("setCharacterStream"))
      {
         Object[] args = mi.getArguments();
         Reader rdr = (Reader) args[1];
         args[1] = new SerializableReader(rdr);
      }

      return getNext().invoke(mi);
   }

}