/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.resource.adapter.jdbc.remote;

import java.rmi.server.UID;
import java.util.Hashtable;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import javax.naming.spi.ObjectFactory;
import javax.naming.Name;
import javax.naming.Context;
import javax.naming.Reference;
import javax.naming.BinaryRefAddr;
import javax.naming.StringRefAddr;
import org.jboss.naming.NonSerializableFactory;

/** A JNDI ObjectFactory for handling either the local or remote access to
 * a JCA javax.sql.DataSource binding.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class DataSourceFactory implements ObjectFactory
{
   /** The class VM ID */
   public static final UID vmID = new UID();

   public Object getObjectInstance(Object obj, Name name, Context ctx,
      Hashtable env) throws Exception
   {
      Object instance = null;
      if (obj instanceof Reference)
      {
         Reference ref = (Reference) obj;
         // Check the local id
         BinaryRefAddr localID = (BinaryRefAddr) ref.get("VMID");
         byte[] idBytes = (byte[]) localID.getContent();
         ByteArrayInputStream bais = new ByteArrayInputStream(idBytes);
         ObjectInputStream ois = new ObjectInputStream(bais);
         UID id = (UID) ois.readObject();
         if( id.equals(vmID) == true )
         {
            // Use the local datasource
            StringRefAddr jndiAddr = (StringRefAddr) ref.get("JndiName");
            String jndiName = (String) jndiAddr.getContent();
            instance = NonSerializableFactory.lookup(jndiName);
         }
         else
         {
            // Use the embedded proxy
            BinaryRefAddr proxyAddr = (BinaryRefAddr) ref.get("ProxyData");
            byte[] proxyBytes = (byte[]) proxyAddr.getContent();
            ByteArrayInputStream bais2 = new ByteArrayInputStream(proxyBytes);
            ObjectInputStream ois2 = new ObjectInputStream(bais2);
            instance = ois2.readObject();
         }
      }
      return instance;
   }

}
