/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.resource.adapter.jdbc;

import org.jboss.util.LRUCachePolicy;
import org.jboss.logging.Logger;

import java.sql.SQLException;

/**
 *  LRU cache for PreparedStatements. When ps ages out, close it if
 * its not in use.
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 */
public class PreparedStatementCache extends LRUCachePolicy
{

   private final Logger log = Logger.getLogger(getClass());

   public PreparedStatementCache(int max)
   {
      super(2, max);
      create();
   }

   protected void ageOut(LRUCachePolicy.LRUCacheEntry entry)
   {
      try
      {
         CachedPreparedStatement ws = (CachedPreparedStatement) entry.m_object;
         ws.agedOut();
      }
      catch (SQLException e)
      {
         log.debug("Failed closing cached statement", e);
      }
      finally
      {
         super.ageOut(entry);
      }
   }
}
