/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.cache.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.cache.TreeCache;
import org.jboss.cache.transaction.DummyTransactionManager;

import javax.transaction.Transaction;
import javax.transaction.SystemException;
import javax.transaction.NotSupportedException;

/**
 * Tests restart (stop-destroy-create-start) of TreeCache
 * @author Bela Ban
 * @version $Id:RestartTest.java,v 1.0, 2005-06-24 19:15:08Z, Robert Worsnop$
 */
public class RestartTest extends TestCase {


   public void testLocalRestartNoTransactions() throws Exception {
      TreeCache cache=createCache(TreeCache.LOCAL);
      cache.createService();
      cache.startService();

      cache.put("/a/b/c", null);
      assertTrue(cache.getNumberOfNodes() > 0);
      assertEquals(0, cache.getNumberOfLocksHeld());

      System.out.println("cache locks before restart:\n" + cache.printLockInfo());
      restartCache(cache);
      System.out.println("cache locks after restart:\n" + cache.printLockInfo());

      assertTrue(cache.getNumberOfNodes() > 0);
      assertEquals(0, cache.getNumberOfLocksHeld());
   }


   public void testLocalRestartWithTransactions() throws Exception {
      TreeCache cache=createCache(TreeCache.LOCAL);
      cache.createService();
      cache.startService();

      Transaction tx=beginTransaction();

      cache.put("/a/b/c", null);
      System.out.println("cache locks before restart:\n" + cache.printLockInfo());
      assertTrue(cache.getNumberOfNodes() > 0);
      assertEquals(3, cache.getNumberOfLocksHeld());

      restartCache(cache);
      System.out.println("cache locks after restart:\n" + cache.printLockInfo());

      assertEquals(3, cache.getNumberOfLocksHeld());
      assertTrue(cache.getNumberOfNodes() > 0);

      tx.rollback();
      assertEquals(0, cache.getNumberOfLocksHeld());
   }


   TreeCache createCache(int cache_mode) throws Exception {
      TreeCache retval=new TreeCache();
      retval.setCacheMode(cache_mode);
      retval.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
      return retval;
   }


   Transaction beginTransaction() throws SystemException, NotSupportedException {
      DummyTransactionManager mgr=DummyTransactionManager.getInstance();
      mgr.begin();
      Transaction tx=mgr.getTransaction();
      return tx;
   }


   void startCache(TreeCache c) throws Exception {
      c.createService();
      c.startService();
   }

   void stopCache(TreeCache c) {
      c.stopService();
      c.destroyService();
   }

   void restartCache(TreeCache c) throws Exception {
      stopCache(c);
      startCache(c);
   }


   public static Test suite() {
      return new TestSuite(RestartTest.class);
   }

   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }

}
