/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.cache.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.DelegatingCacheLoader;
import org.jboss.cache.loader.LocalDelegatingCacheLoader;

/**
 * Created by IntelliJ IDEA.
 * User: bela
 * Date: Jun 9, 2004
 * Time: 9:05:19 AM
 */
public class LocalDelegatingCacheLoaderTest extends CacheLoaderTestsBase {
   TreeCache delegating_cache;
   DelegatingCacheLoader cache_loader;


   protected void configureCache() throws Exception {
      delegating_cache=new TreeCache();
      delegating_cache.setCacheMode(TreeCache.LOCAL);
      delegating_cache.createService();
      delegating_cache.startService();
      cache_loader=new LocalDelegatingCacheLoader(delegating_cache);
      cache.setCacheLoader(cache_loader);
   }

   protected void tearDown() throws Exception {
      super.tearDown();
      delegating_cache.stopService();
      delegating_cache.destroyService();
   }


   public static Test suite() {
      return new TestSuite(LocalDelegatingCacheLoaderTest.class);
   }


   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }

}
