/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.cache.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.*;
import org.jboss.cache.loader.LocalDelegatingCacheLoader;

import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: bela
 * Date: Jun 9, 2004
 * Time: 9:05:19 AM
 */
public class InterceptorConfigurationTest extends TestCase {
   TreeCache cache=null;

   protected void setUp() throws Exception {
      super.setUp();
      cache=new TreeCache();
      cache.setCacheMode(TreeCache.LOCAL);
   }

   protected void tearDown() throws Exception {
      super.tearDown();
      if(cache != null) {
         cache.stopService();
         cache.destroyService();
      }
   }


   public void testBareConfig() throws Exception {
      cache.createService();
      cache.startService();
      System.out.println("interceptors are:\n" + cache.getInterceptorChain());
      List list=cache.getInterceptors();
      assertNotNull(list);
      assertEquals(3, list.size());
      assertEquals(list.get(0).getClass(), UnlockInterceptor.class);
      // assertEquals(list.get(1).getClass(), CreateIfNotExistsInterceptor.class);
      assertEquals(list.get(1).getClass(), LockInterceptor.class);
      assertEquals(list.get(2).getClass(), CallInterceptor.class);
   }


   public void testTxConfig() throws Exception {
      cache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
      cache.createService();
      cache.startService();
      System.out.println("interceptors are:\n" + cache.getInterceptorChain());
      List list=cache.getInterceptors();
      assertNotNull(list);
      assertEquals(3, list.size());
      assertEquals(list.get(0).getClass(), UnlockInterceptor.class);
      // assertEquals(list.get(1).getClass(), CreateIfNotExistsInterceptor.class);
      assertEquals(list.get(1).getClass(), LockInterceptor.class);
      assertEquals(list.get(2).getClass(), CallInterceptor.class);
   }

   public void testSharedCacheLoaderConfig() throws Exception {
      cache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
      cache.setCacheLoader(new LocalDelegatingCacheLoader(null));
      cache.setCacheLoaderShared(true);
      cache.setCacheMode(TreeCache.REPL_ASYNC);
      cache.setFetchStateOnStartup(false);
      cache.createService();
      cache.startService();
      System.out.println("interceptors are:\n" + cache.getInterceptorChain());
      List list=cache.getInterceptors();
      assertNotNull(list);

      assertEquals(6, list.size());

      assertEquals(list.get(0).getClass(), CacheStoreInterceptor.class);
      assertEquals(list.get(1).getClass(), ReplicationInterceptor.class);
      assertEquals(list.get(2).getClass(), UnlockInterceptor.class);
      assertEquals(list.get(3).getClass(), CacheLoaderInterceptor.class);
      // assertEquals(list.get(4).getClass(), CreateIfNotExistsInterceptor.class);
      assertEquals(list.get(4).getClass(), LockInterceptor.class);
      assertEquals(list.get(5).getClass(), CallInterceptor.class);
   }

   public void testUnsharedCacheLoaderConfig() throws Exception {
      cache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
      cache.setCacheLoader(new LocalDelegatingCacheLoader(null));
      cache.setCacheLoaderShared(false);
      cache.setCacheMode(TreeCache.REPL_ASYNC);
      cache.setFetchStateOnStartup(false);
      cache.createService();
      cache.startService();
      System.out.println("interceptors are:\n" + cache.getInterceptorChain());
      List list=cache.getInterceptors();
      assertNotNull(list);

      assertEquals(6, list.size());

      assertEquals(list.get(0).getClass(), ReplicationInterceptor.class);
      assertEquals(list.get(1).getClass(), UnlockInterceptor.class);
      assertEquals(list.get(2).getClass(), CacheLoaderInterceptor.class);
      assertEquals(list.get(3).getClass(), CacheStoreInterceptor.class);
      // assertEquals(list.get(4).getClass(), CreateIfNotExistsInterceptor.class);
      assertEquals(list.get(4).getClass(), LockInterceptor.class);
      assertEquals(list.get(5).getClass(), CallInterceptor.class);
   }

   public void testTxAndRepl() throws Exception {
      cache.setCacheMode("repl_sync");
      cache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
      cache.createService();
      cache.startService();
      System.out.println("interceptors are:\n" + cache.getInterceptorChain());
      List list=cache.getInterceptors();
      assertNotNull(list);

      assertEquals(4, list.size());

      assertEquals(list.get(0).getClass(), ReplicationInterceptor.class);
      assertEquals(list.get(1).getClass(), UnlockInterceptor.class);
      // assertEquals(list.get(2).getClass(), CreateIfNotExistsInterceptor.class);
      assertEquals(list.get(2).getClass(), LockInterceptor.class);
      assertEquals(list.get(3).getClass(), CallInterceptor.class);
   }

   public static Test suite() {
      return new TestSuite(InterceptorConfigurationTest.class);
   }

   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }

}
