/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.cache.tests;

import junit.framework.Test;
import junit.framework.TestSuite;

import java.io.File;
import java.io.FileFilter;
import java.util.Properties;

/**
 * Runs the same tests as {@link FileCacheLoaderTest}, but with Berkeley DB instead of a file-based CacheLoader
 * @author Bela Ban
 * @Version $Id:BdbjeCacheLoaderTest.java,v 1.0, 2005-06-24 18:47:26Z, Robert Worsnop$
 */
public class BdbjeCacheLoaderTest extends CacheLoaderTestsBase {


   protected void configureCache() throws Exception {
      File dir = new File(".");

      class MyFilter implements FileFilter {
         public boolean accept(File file) {
            return file.getName().endsWith(".jdb");
         }
      }

      File[] files=dir.listFiles(new MyFilter());
      if (files != null) {
         for (int i = 0; i < files.length; i += 1) {
            File file = files[i];
            if (file.isFile()) {
               if (!file.delete()) {
                  System.err.println("Unable to delete: " + file);
               }
            }
         }
      }

      cache.setCacheLoaderClass("org.jboss.cache.loader.bdbje.BdbjeCacheLoader");
      Properties props=new Properties();
      props.setProperty("location", ".#temp");
      cache.setCacheLoaderConfig(props);
   }


   public static Test suite() {
      return new TestSuite(BdbjeCacheLoaderTest.class);
   }



}
