/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.loader;

import java.util.Map;
import java.util.Properties;
import java.util.Set;

import org.jboss.cache.TreeCache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;

/**
 * DelegatingCacheLoader implementation which delegates to a local (in the same VM) TreeCache. Sample code:
 * <pre>
 * TreeCache firstLevel=new TreeCache();
 * TreeCache secondLevel=new TreeCache();
 * DelegatingCacheLoader l=new DelegatingCacheLoader(secondLevel);
 * l.setCache(firstLevel);
 * firstLevel.setCacheLoader(l);
 * secondLevel.start();
 * firstLevel.start();
 * </pre>
 * @author Bela Ban
 * @author Daniel Gredler
 * @version $Id:LocalDelegatingCacheLoader.java,v 1.0, 2005-06-24 19:10:55Z, Robert Worsnop$
 */
public class LocalDelegatingCacheLoader extends DelegatingCacheLoader {

   TreeCache delegate=null;

   public LocalDelegatingCacheLoader(TreeCache delegate) {
      this.delegate=delegate;
   }

   public void setConfig(Properties props) {
      throw new UnsupportedOperationException();
   }

   public void setCache(TreeCache cache) {
      // Empty.
   }

   protected Set delegateGetChildrenNames(Fqn fqn) throws Exception {
      return delegate.getChildrenNames(fqn);
   }

   protected Object delegateGet(Fqn name, Object key) throws Exception {
      return delegate.get(name, key);
   }

   protected Node delegateGet(Fqn name) throws Exception {
      return delegate.get(name);
   }

   protected boolean delegateExists(Fqn name) throws Exception {
      return delegate.exists(name);
   }

   protected Object delegatePut(Fqn name, Object key, Object value) throws Exception {
      return delegate.put(name, key, value);
   }

   protected void delegatePut(Fqn name, Map attributes) throws Exception {
      delegate.put(name, attributes);
   }

   protected Object delegateRemove(Fqn name, Object key) throws Exception {
      return delegate.remove(name, key);
   }

   protected void delegateRemove(Fqn name) throws Exception {
      delegate.remove(name);
   }

   protected void delegateRemoveData(Fqn name) throws Exception {
      delegate.removeData(name);
   }

   protected byte[] delegateLoadEntireState() throws Exception {
      return delegate.getStateBytes();
   }

   protected void delegateStoreEntireState(byte[] state) throws Exception {
      delegate.setStateBytes(state);
   }

}
