/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;

/**
 * Value object used in queue.
 *
 * @author Ben Wang 2-2004
 */
public class NodeEntry
{
   private long modifiedTimeStamp_;
   private NodeEntry previous_;
   private NodeEntry next_;
   private Fqn fqn_;

   public NodeEntry(Fqn fqn)
   {
      setFqn(fqn);
   }

   public NodeEntry(String fqn)
   {
      setFqn(Fqn.fromString(fqn));
   }

    /**
     * Get modified time stamp. This stamp is created during the node is
     * processed so it has some fuzy tolerance in there.
     * @return
     */
   long getModifiedTimeStamp()
   {
      return modifiedTimeStamp_;
   }

   void setModifiedTimeStamp(long modifiedTimeStamp)
   {
      this.modifiedTimeStamp_ = modifiedTimeStamp;
   }

   NodeEntry getPrevious()
   {
      return previous_;
   }

   void setPrevious(NodeEntry previous)
   {
      this.previous_ = previous;
   }

   NodeEntry getNext()
   {
      return next_;
   }

   void setNext(NodeEntry next)
   {
      this.next_ = next;
   }

   Fqn getFqn()
   {
      return fqn_;
   }

   void setFqn(Fqn fqn)
   {
      this.fqn_ = fqn;
   }

}
