/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.cache.eviction;

import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;

import java.util.Set;

/**
 *  Base class implementation of EvictionPolicy.
 * @author Ben Wang  2-2004
 */
public class BaseEvictionPolicy implements EvictionPolicy
{
   protected RegionManager regionManager_ = null;
   protected TreeCache cache_;

   public BaseEvictionPolicy() {
//      regionManager_ = new RegionManager(this);
   }

   /** EvictionPolicy interface implementation */

   public Region[] getRegions()
   {
      return regionManager_.getRegions();
   }

   public void evict(Fqn fqn) throws Exception
   {
      cache_.evict(fqn);
   }

   /**
    * 
    * @param fqn
    * @return Set of children name as Objects
    */
   public Set getChildrenNames(Fqn fqn) {
      try {
         return cache_.getChildrenNames(fqn);
      } catch (CacheException e) {
         e.printStackTrace();
      }
      return null;
   }

   public boolean hasChild(Fqn fqn) {
      return cache_.hasChild(fqn);
   }

   public Object getCacheData(Fqn fqn, Object key)
   {
      try {
         return cache_.get(fqn, key);
      } catch (CacheException e) {
         e.printStackTrace();
      }
      return null;
   }

   public int getWakeupIntervalSeconds()
   {
      return 0; // default value here.
   }

   public void configure(TreeCache cache)
   {
   }

}
