/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.transport.socket.LRUPool;
import org.jboss.remoting.transport.socket.ServerThread;
import org.jboss.remoting.transport.socket.SocketServerInvokerMBean;
import org.jboss.util.propertyeditor.PropertyEditors;

public class SocketServerInvoker
extends ServerInvoker
implements Runnable,
SocketServerInvokerMBean {
    private InetAddress addr;
    private int port;
    static int clientCount = 0;
    private static int BACKLOG_DEFAULT = 200;
    private static int MAX_POOL_SIZE_DEFAULT = 300;
    protected ServerSocket serverSocket = null;
    protected boolean running = false;
    protected int backlog = BACKLOG_DEFAULT;
    protected Thread[] acceptThreads;
    protected int numAcceptThreads = 1;
    protected int maxPoolSize = MAX_POOL_SIZE_DEFAULT;
    protected LRUPool clientpool;
    protected LinkedList threadpool;
    protected int timeout = 60000;
    protected boolean trace = false;
    protected int clientConnectPort = 0;
    protected String clientConnectAddress = null;
    protected String serverBindAddress = null;
    protected int serverBindPort = 0;

    public SocketServerInvoker(InvokerLocator locator) {
        super(locator);
        try {
            this.setup();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public SocketServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
        try {
            this.setup();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    protected void setup() throws Exception {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.getConfiguration());
        PropertyEditors.mapJavaBeanProperties((Object)this, (Properties)props, (boolean)false);
        this.addr = InetAddress.getByName(this.locator.getHost());
        this.port = this.locator.getPort();
        if (this.port <= 0) {
            this.port = PortUtil.findFreePort();
            this.locator = new InvokerLocator(this.locator.getProtocol(), this.locator.getHost(), this.port, this.locator.getPath(), this.locator.getParameters());
        }
        this.serverBindAddress = props.getProperty("serverBindAddress") != null ? props.getProperty("serverBindAddress") : (props.getProperty("clientConnectAddress") != null ? InetAddress.getLocalHost().getHostAddress() : this.addr.getHostAddress());
        this.serverBindPort = props.getProperty("serverBindPort") != null ? Integer.parseInt(props.getProperty("serverBindPort")) : (props.getProperty("clientConnectPort") != null ? PortUtil.findFreePort() : this.port);
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public synchronized void start() throws IOException {
        this.trace = this.log.isTraceEnabled();
        if (!this.running) {
            this.running = true;
            InetAddress bindAddress = this.serverBindAddress == null || this.serverBindAddress.length() == 0 ? null : InetAddress.getByName(this.serverBindAddress);
            String string = this.clientConnectAddress = this.clientConnectAddress == null || this.clientConnectAddress.length() == 0 ? InetAddress.getLocalHost().getHostName() : this.clientConnectAddress;
            if (this.maxPoolSize <= 0) {
                this.maxPoolSize = MAX_POOL_SIZE_DEFAULT;
            }
            this.clientpool = new LRUPool(2, this.maxPoolSize);
            this.clientpool.create();
            this.threadpool = new LinkedList();
            try {
                this.serverSocket = new ServerSocket(this.serverBindPort, this.backlog, bindAddress);
            }
            catch (IOException e) {
                this.log.error((Object)("Error starting ServerSocket.  Bind port: " + this.serverBindPort + ", bind address: " + bindAddress));
                throw e;
            }
            this.serverBindPort = this.serverSocket.getLocalPort();
            this.clientConnectPort = this.clientConnectPort == 0 ? this.serverSocket.getLocalPort() : this.clientConnectPort;
            this.acceptThreads = new Thread[this.numAcceptThreads];
            for (int i = 0; i < this.numAcceptThreads; ++i) {
                String name = "SocketServerInvoker#" + i + "-" + this.serverBindPort;
                this.acceptThreads[i] = new Thread((Runnable)this, name);
                this.acceptThreads[i].start();
            }
        }
        super.start();
    }

    public synchronized void stop() {
        if (this.running) {
            int i;
            this.running = false;
            this.maxPoolSize = 0;
            for (i = 0; i < this.acceptThreads.length; ++i) {
                try {
                    this.acceptThreads[i].interrupt();
                    continue;
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            this.clientpool.flush();
            for (i = 0; i < this.threadpool.size(); ++i) {
                ServerThread thread = (ServerThread)this.threadpool.removeFirst();
                thread.shutdown();
            }
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.stop();
    }

    public String getMBeanObjectName() {
        return "jboss.remoting:service=invoker,transport=socket";
    }

    public int getSocketTimeout() {
        return this.timeout;
    }

    public void setSocketTimeout(int time) {
        this.timeout = time;
    }

    public int getCurrentThreadPoolSize() {
        return this.threadpool.size();
    }

    public int getCurrentClientPoolSize() {
        return this.clientpool.size();
    }

    public String getClientConnectAddress() {
        return this.clientConnectAddress;
    }

    public void setClientConnectAddress(String clientConnectAddress) {
        this.clientConnectAddress = clientConnectAddress;
    }

    public int getNumAcceptThreads() {
        return this.numAcceptThreads;
    }

    public void setNumAcceptThreads(int size) {
        this.numAcceptThreads = size;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getServerBindAddress() {
        return this.serverBindAddress;
    }

    public void setServerBindAddress(String serverBindAddress) {
        this.serverBindAddress = serverBindAddress;
    }

    public int getServerBindPort() {
        return this.serverBindPort;
    }

    public void setServerBindPort(int serverBindPort) {
        this.serverBindPort = serverBindPort;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog < 0 ? BACKLOG_DEFAULT : backlog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running) {
            try {
                Object object;
                Socket socket = this.serverSocket.accept();
                if (this.trace) {
                    this.log.trace((Object)("Accepted: " + socket));
                }
                ServerThread thread = null;
                boolean newThread = false;
                while (thread == null) {
                    object = this.threadpool;
                    synchronized (object) {
                        if (this.threadpool.size() > 0) {
                            thread = (ServerThread)this.threadpool.removeFirst();
                        }
                    }
                    if (thread != null) continue;
                    object = this.clientpool;
                    synchronized (object) {
                        if (this.clientpool.size() < this.maxPoolSize) {
                            thread = new ServerThread(socket, this, this.clientpool, this.threadpool, this.timeout);
                            newThread = true;
                        }
                        if (thread == null) {
                            this.clientpool.evict();
                            if (this.trace) {
                                this.log.trace((Object)"Waiting for a thread...");
                            }
                            ((Object)((Object)this.clientpool)).wait();
                            if (this.trace) {
                                this.log.trace((Object)"Notified of available thread");
                            }
                        }
                    }
                }
                object = this.clientpool;
                synchronized (object) {
                    this.clientpool.insert(thread, thread);
                }
                if (newThread) {
                    if (this.trace) {
                        this.log.trace((Object)("Created a new thread, t=" + thread));
                    }
                    thread.start();
                    continue;
                }
                if (this.trace) {
                    this.log.trace((Object)("Reusing thread t=" + thread));
                }
                thread.wakeup(socket, this.timeout);
            }
            catch (Throwable ex) {
                if (!this.running) continue;
                this.log.error((Object)"Failed to accept socket connection", ex);
            }
        }
    }

    public boolean isTransportBiDirectional() {
        return true;
    }

    protected String getDefaultDataType() {
        return "serializable";
    }
}

