/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.HandleCallbackException;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerCallbackHandler;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.NullCallbackStore;
import org.jboss.remoting.SerializableStore;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.invocation.InternalInvocation;

public class ServerInvokerCallbackHandler
implements InvokerCallbackHandler {
    private InvocationRequest invocation;
    private Client callBackClient;
    private ArrayList callbacks = new ArrayList();
    private String sessionId;
    private InvokerLocator serverLocator;
    private SerializableStore callbackStore = null;
    public static final String CALLBACK_STORE_KEY = "callbackStore";
    public static final String CALLBACK_MEM_CEILING = "callbackMemCeiling";
    private double memPercentCeiling = 20.0;
    private static final Logger log = Logger.getLogger((Class)ServerInvokerCallbackHandler.class);

    public ServerInvokerCallbackHandler(InvocationRequest invocation, InvokerLocator serverLocator, ServerInvoker owner) throws Exception {
        if (invocation == null) {
            throw new Exception("Can not construct ServerInvokerCallbackHandler with null InvocationRequest.");
        }
        this.invocation = invocation;
        this.serverLocator = serverLocator;
        this.init(invocation, owner);
    }

    private void init(InvocationRequest invocation, ServerInvoker owner) throws Exception {
        this.sessionId = invocation.getSessionId();
        if (invocation.getLocator() != null) {
            this.callBackClient = new Client(invocation.getLocator(), invocation.getSubsystem());
            this.callBackClient.connect();
        } else {
            this.createCallbackStore(owner, this.sessionId);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Session id for callback handler is " + this.sessionId));
        }
    }

    public void setMemPercentCeiling(Double ceiling) {
        if (ceiling != null) {
            this.memPercentCeiling = ceiling;
        }
    }

    public Double getMemPercentCeiling() {
        return new Double(this.memPercentCeiling);
    }

    private void createCallbackStore(ServerInvoker owner, String sessionId) throws Exception {
        block11: {
            String storeName;
            Map config = owner.getConfiguration();
            if (config != null && (storeName = (String)config.get(CALLBACK_STORE_KEY)) != null) {
                try {
                    MBeanServer server = owner.getMBeanServer();
                    ObjectName storeObjectName = new ObjectName(storeName);
                    if (server != null) {
                        this.callbackStore = (SerializableStore)MBeanServerInvocationHandler.newProxyInstance(server, storeObjectName, SerializableStore.class, false);
                    }
                }
                catch (Exception ex) {
                    log.debug((Object)("Could not create callback store from the configration value given (" + storeName + ") as an MBean."));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Error is: " + ex.getMessage()), (Throwable)ex);
                    }
                    this.callbackStore = null;
                }
                if (this.callbackStore == null) {
                    try {
                        Class<?> storeClass = Class.forName(storeName);
                        this.callbackStore = (SerializableStore)storeClass.newInstance();
                    }
                    catch (Exception e) {
                        log.debug((Object)("Could not create callback store from the configuration value given (" + storeName + ") as a fully qualified class name."));
                        if (!log.isTraceEnabled()) break block11;
                        log.trace((Object)("Error is: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        if (this.callbackStore == null) {
            this.callbackStore = new NullCallbackStore();
        } else {
            HashMap<String, String> storeConfig = new HashMap<String, String>();
            storeConfig.putAll(owner.getConfiguration());
            String newFilePath = null;
            String filePath = (String)storeConfig.get("StoreFilePath");
            if (filePath == null) {
                newFilePath = System.getProperty("jboss.server.data.dir", "data");
            }
            newFilePath = newFilePath + System.getProperty("file.separator") + "remoting" + System.getProperty("file.separator") + sessionId;
            storeConfig.put("StoreFilePath", newFilePath);
            this.callbackStore.setConfig(storeConfig);
        }
        this.callbackStore.create();
        this.callbackStore.start();
        this.configureMemCeiling(owner.getConfiguration());
    }

    private void configureMemCeiling(Map configuration) {
        String ceiling;
        if (configuration != null && (ceiling = (String)configuration.get(CALLBACK_MEM_CEILING)) != null) {
            try {
                double newCeiling = Double.parseDouble(ceiling);
                this.setMemPercentCeiling(new Double(newCeiling));
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Found new store memory ceiling seting (" + ceiling + "), but can not convert to type double."), (Throwable)e);
            }
        }
    }

    public Client getCallbackClient() {
        return this.callBackClient;
    }

    public static String getId(InvocationRequest invocation) {
        String sessionId = invocation.getSessionId();
        return sessionId;
    }

    public String getId() {
        return ServerInvokerCallbackHandler.getId(this.invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCallbacks() {
        List callbackList = null;
        ArrayList arrayList = this.callbacks;
        synchronized (arrayList) {
            callbackList = (List)this.callbacks.clone();
            this.callbacks.clear();
        }
        List persistedCallbacks = null;
        try {
            persistedCallbacks = this.getPersistedCallbacks();
        }
        catch (IOException e) {
            log.error((Object)"Can not get persisted callbacks.", (Throwable)e);
            throw new RuntimeException("Error getting callbacks", e);
        }
        callbackList.addAll(persistedCallbacks);
        return callbackList;
    }

    private List getPersistedCallbacks() throws IOException {
        ArrayList<Object> callbacks = new ArrayList<Object>();
        int size = this.callbackStore.size();
        for (int x = 0; x < size; ++x) {
            callbacks.add(this.callbackStore.getNext());
            if (!this.isMemLow()) continue;
            new Thread(){

                public void run() {
                    System.gc();
                }
            }.start();
            break;
        }
        return callbacks;
    }

    public boolean isPullCallbackHandler() {
        return this.callBackClient == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCallback(InvocationRequest callback) throws HandleCallbackException {
        block18: {
            try {
                if (this.callBackClient == null) {
                    if (this.shouldPersist()) {
                        try {
                            this.persistCallback(callback);
                            callback = null;
                            new Thread(){

                                public void run() {
                                    System.gc();
                                }
                            }.start();
                            break block18;
                        }
                        catch (IOException e) {
                            log.error((Object)"Unable to persist callback.", (Throwable)e);
                            throw new HandleCallbackException("Unable to persist callback and will not be able to deliver.", e);
                        }
                    }
                    ArrayList e = this.callbacks;
                    synchronized (e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"pull callback.  adding to callback list");
                        }
                        this.callbacks.add(callback);
                        break block18;
                    }
                }
                try {
                    if (!this.callBackClient.isConnected()) {
                        this.callBackClient.connect();
                    }
                    if (this.callBackClient.isConnected()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"push callback.  Calling client now.");
                        }
                        if (callback != null) {
                            HashMap<String, InvokerLocator> returnPayload = callback.getReturnPayload();
                            if (returnPayload == null) {
                                returnPayload = new HashMap<String, InvokerLocator>();
                            }
                            returnPayload.put("server_locator", this.serverLocator);
                            callback.setReturnPayload(returnPayload);
                        }
                    } else {
                        log.error((Object)"Can not handle callback since can not connect to client invoker.");
                        throw new HandleCallbackException("Can not handle callback since can not connect to client invoker.");
                    }
                    InternalInvocation internalInvocation = new InternalInvocation("handleCallback", new Object[]{callback});
                    this.callBackClient.setSessionId(this.sessionId);
                    this.callBackClient.invoke(internalInvocation, callback.getRequestPayload());
                }
                catch (Throwable ex) {
                    log.debug((Object)"Error dispatching callback to handler.", ex);
                    throw new HandleCallbackException("Error dispatching callback to handler.", ex);
                }
            }
            catch (Throwable thr) {
                log.error((Object)"Error handling callback.", thr);
                throw new HandleCallbackException("Error handling callback.", thr);
            }
        }
    }

    private void persistCallback(InvocationRequest callback) throws IOException {
        this.callbackStore.add(callback);
    }

    private boolean shouldPersist() {
        return this.isMemLow();
    }

    private boolean isMemLow() {
        Runtime runtime = Runtime.getRuntime();
        long max = runtime.maxMemory();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        float percentage = 100L * free / total;
        return max == total && this.memPercentCeiling >= (double)percentage;
    }

    public String toString() {
        return this.getClass().getName() + " - id: " + this.getId();
    }

    public void destroy() {
        if (this.callBackClient != null) {
            this.callBackClient.disconnect();
            this.callBackClient = null;
        }
        if (this.callbackStore != null) {
            this.callbackStore.purgeFiles();
        }
    }
}

