/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerCallbackHandler;
import org.jboss.remoting.ServerInterceptor;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transport.Connector;

public class ServerInterceptorChain
implements MBeanRegistration,
ServerInvocationHandler {
    private MBeanServer server;
    private Connector connector;
    private ObjectName connectorName;
    private String subsystem;
    private List interceptorNames;
    private List interceptors;

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector newConnector) {
        this.connector = newConnector;
    }

    public ObjectName getConnectorName() {
        return this.connectorName;
    }

    public void setConnectorName(ObjectName newConnectorName) {
        this.connectorName = newConnectorName;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String newSubsystem) {
        this.subsystem = newSubsystem;
    }

    public List getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List newInterceptors) {
        this.interceptors = newInterceptors;
    }

    public List getInterceptorNames() {
        return this.interceptorNames;
    }

    public void setInterceptorNames(List newInterceptorNames) {
        this.interceptorNames = newInterceptorNames;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName objectName) throws Exception {
        this.server = server;
        return objectName;
    }

    public void postRegister(Boolean success) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void start() throws Exception {
        ArrayList<ServerInterceptor> interceptors = new ArrayList<ServerInterceptor>();
        Iterator i = this.interceptorNames.iterator();
        while (i.hasNext()) {
            ObjectName iname = (ObjectName)i.next();
            ServerInterceptor si = (ServerInterceptor)this.server.getAttribute(iname, "Instance");
            interceptors.add(si);
        }
        this.interceptors = interceptors;
        if (this.connector != null) {
            this.connector.addInvocationHandler(this.subsystem, this);
        } else {
            this.server.invoke(this.connectorName, "addInvocationHandler", new Object[]{this.subsystem, this}, new String[]{String.class.getName(), ServerInvocationHandler.class.getName()});
        }
    }

    public void stop() throws Exception {
        if (this.connector != null) {
            this.connector.removeInvocationHandler(this.subsystem);
        } else {
            this.server.invoke(this.connectorName, "removeInvocationHandler", new Object[]{this.subsystem}, new String[]{String.class.getName()});
        }
        this.interceptors.clear();
    }

    public void addListener(InvokerCallbackHandler invokerCallbackHandler) {
    }

    public void removeListener(InvokerCallbackHandler invokerCallbackHandler) {
    }

    public void setMBeanServer(MBeanServer MBeanServer2) {
    }

    public Object invoke(InvocationRequest invocation) throws Throwable {
        InterceptorIterator iterator = new InterceptorIterator(this.interceptors.iterator(), invocation);
        return iterator.invokeNext();
    }

    public void setInvoker(ServerInvoker serverInvoker) {
    }

    public static class InterceptorIterator {
        private final Iterator iterator;
        private final InvocationRequest invocation;

        public InterceptorIterator(Iterator iterator, InvocationRequest invocation) {
            this.iterator = iterator;
            this.invocation = invocation;
        }

        public Object invokeNext() throws Throwable {
            return ((ServerInterceptor)this.iterator.next()).invoke(this, this.invocation);
        }
    }
}

