/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.EntityUniqueKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.tuple.ElementWrapper;
import org.hibernate.type.AbstractType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;

public abstract class EntityType
extends AbstractType
implements AssociationType {
    private final String associatedEntityName;
    protected final String uniqueKeyPropertyName;
    protected final boolean isEmbeddedInXML;
    private final boolean eager;
    static /* synthetic */ Class class$java$util$Map;

    public final boolean isEntityType() {
        return true;
    }

    public String getPropertyName() {
        return null;
    }

    public final String getAssociatedEntityName() {
        return this.associatedEntityName;
    }

    public final boolean isSame(Object x, Object y, EntityMode entityMode) {
        return x == y;
    }

    public int compare(Object x, Object y, EntityMode entityMode) {
        return 0;
    }

    protected EntityType(String entityName, String uniqueKeyPropertyName, boolean eager, boolean isEmbeddedInXML) {
        this.associatedEntityName = entityName;
        this.uniqueKeyPropertyName = uniqueKeyPropertyName;
        this.isEmbeddedInXML = isEmbeddedInXML;
        this.eager = eager;
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public final Class getReturnedClass() {
        try {
            return ReflectHelper.classForName(this.associatedEntityName);
        }
        catch (ClassNotFoundException cnfe) {
            return class$java$util$Map == null ? (class$java$util$Map = EntityType.class$("java.util.Map")) : class$java$util$Map;
        }
    }

    protected final Object getIdentifier(Object value, SessionImplementor session) throws HibernateException {
        if (this.isNotEmbedded(session)) {
            return value;
        }
        if (this.isReferenceToPrimaryKey()) {
            return ForeignKeys.getEntityIdentifierIfNotUnsaved(this.associatedEntityName, value, session);
        }
        if (value == null) {
            return null;
        }
        return session.getFactory().getEntityPersister(this.getAssociatedEntityName()).getPropertyValue(value, this.uniqueKeyPropertyName, session.getEntityMode());
    }

    protected boolean isNotEmbedded(SessionImplementor session) {
        return !this.isEmbeddedInXML && session.getEntityMode() == EntityMode.DOM4J;
    }

    private static Serializable getIdentifier(Object object, EntityPersister persister, EntityMode entityMode) throws HibernateException {
        if (object instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)object;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            return li.getIdentifier();
        }
        return persister.getIdentifier(object, entityMode);
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (value == null) {
            return "null";
        }
        EntityPersister persister = factory.getEntityPersister(this.associatedEntityName);
        StringBuffer result = new StringBuffer().append(this.associatedEntityName);
        if (persister.hasIdentifierProperty()) {
            Serializable id;
            EntityMode entityMode = persister.guessEntityMode(value);
            if (entityMode == null) {
                if (this.isEmbeddedInXML) {
                    throw new ClassCastException(value.getClass().getName());
                }
                id = (Serializable)value;
            } else {
                id = EntityType.getIdentifier(value, persister, entityMode);
            }
            result.append('#').append(persister.getIdentifierType().toLoggableString(id, factory));
        }
        return result.toString();
    }

    public String getName() {
        return this.associatedEntityName;
    }

    public Object deepCopy(Object value, EntityMode entityMode, SessionFactoryImplementor factory) {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public abstract boolean isOneToOne();

    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        if (original == null) {
            return null;
        }
        if (original == target) {
            return target;
        }
        Object cached = copyCache.get(original);
        if (cached != null) {
            return cached;
        }
        Object id = this.getIdentifier(original, session);
        if (id == null) {
            throw new AssertionFailure("cannot copy a reference to an object with a null id");
        }
        id = this.getIdentifierOrUniqueKeyType(session.getFactory()).replace(id, null, session, owner, copyCache);
        return this.resolve(id, session, owner);
    }

    public boolean isAssociationType() {
        return true;
    }

    public final Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolve(this.hydrate(rs, names, session, owner), session, owner);
    }

    public boolean isDirty(Object old, Object current, SessionImplementor session) throws HibernateException {
        if (this.isSame(old, current, session.getEntityMode())) {
            return false;
        }
        Object oldid = this.getIdentifier(old, session);
        Object newid = this.getIdentifier(current, session);
        return !this.getIdentifierType(session).isSame(oldid, newid, session.getEntityMode());
    }

    public Joinable getAssociatedJoinable(SessionFactoryImplementor factory) throws MappingException {
        return (Joinable)((Object)factory.getEntityPersister(this.associatedEntityName));
    }

    Type getIdentifierType(Mapping factory) {
        return factory.getIdentifierType(this.getAssociatedEntityName());
    }

    Type getIdentifierType(SessionImplementor session) throws MappingException {
        return this.getIdentifierType(session.getFactory());
    }

    public final Type getIdentifierOrUniqueKeyType(Mapping factory) throws MappingException {
        if (this.isReferenceToPrimaryKey()) {
            return this.getIdentifierType(factory);
        }
        return factory.getPropertyType(this.getAssociatedEntityName(), this.uniqueKeyPropertyName);
    }

    public final String getIdentifierOrUniqueKeyPropertyName(Mapping factory) throws MappingException {
        if (this.isReferenceToPrimaryKey()) {
            return factory.getIdentifierPropertyName(this.getAssociatedEntityName());
        }
        return this.uniqueKeyPropertyName;
    }

    protected abstract boolean isNullable();

    protected final Object resolveIdentifier(Serializable id, SessionImplementor session) throws HibernateException {
        return session.internalLoad(this.getAssociatedEntityName(), id, this.eager, this.isNullable());
    }

    protected boolean isNull(Object owner, SessionImplementor session) {
        return false;
    }

    public Object resolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (this.isNotEmbedded(session)) {
            return value;
        }
        if (value == null) {
            return null;
        }
        if (this.isNull(owner, session)) {
            return null;
        }
        if (this.isReferenceToPrimaryKey()) {
            return this.resolveIdentifier((Serializable)value, session);
        }
        return this.loadByUniqueKey(this.getAssociatedEntityName(), this.uniqueKeyPropertyName, value, session);
    }

    public String getAssociatedEntityName(SessionFactoryImplementor factory) {
        return this.getAssociatedEntityName();
    }

    public boolean isReferenceToPrimaryKey() {
        return this.uniqueKeyPropertyName == null;
    }

    public String getRHSUniqueKeyPropertyName() {
        return this.uniqueKeyPropertyName;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getAssociatedEntityName() + ')';
    }

    public Object loadByUniqueKey(String entityName, String uniqueKeyPropertyName, Object key, SessionImplementor session) throws HibernateException {
        SessionFactoryImplementor factory = session.getFactory();
        UniqueKeyLoadable persister = (UniqueKeyLoadable)factory.getEntityPersister(entityName);
        EntityUniqueKey euk = new EntityUniqueKey(entityName, uniqueKeyPropertyName, key, this.getIdentifierOrUniqueKeyType(factory), session.getEntityMode());
        PersistenceContext persistenceContext = session.getPersistenceContext();
        Object result = persistenceContext.getEntity(euk);
        if (result == null) {
            result = persister.loadByUniqueKey(uniqueKeyPropertyName, key, session);
        }
        return result == null ? null : persistenceContext.proxyFor(result);
    }

    public String getLHSPropertyName() {
        return null;
    }

    public String getOnCondition(String alias, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        if (this.isReferenceToPrimaryKey()) {
            return "";
        }
        return this.getAssociatedJoinable(factory).filterFragment(alias, enabledFilters);
    }

    public int getHashCode(Object x, EntityMode entityMode, SessionFactoryImplementor factory) {
        EntityPersister persister = factory.getEntityPersister(this.associatedEntityName);
        if (!persister.hasIdentifierPropertyOrEmbeddedCompositeIdentifier()) {
            return super.getHashCode(x, entityMode);
        }
        if (x instanceof HibernateProxy) {
            return ((HibernateProxy)x).getHibernateLazyInitializer().getIdentifier().hashCode();
        }
        Serializable id = persister.getIdentifier(x, entityMode);
        return persister.getIdentifierType().getHashCode(id, entityMode, factory);
    }

    public boolean isEqual(Object x, Object y, EntityMode entityMode, SessionFactoryImplementor factory) {
        EntityPersister persister = factory.getEntityPersister(this.associatedEntityName);
        if (!persister.hasIdentifierPropertyOrEmbeddedCompositeIdentifier()) {
            return super.isEqual(x, y, entityMode);
        }
        Serializable xid = x instanceof HibernateProxy ? ((HibernateProxy)x).getHibernateLazyInitializer().getIdentifier() : persister.getIdentifier(x, entityMode);
        Serializable yid = y instanceof HibernateProxy ? ((HibernateProxy)y).getHibernateLazyInitializer().getIdentifier() : persister.getIdentifier(y, entityMode);
        return persister.getIdentifierType().isEqual(xid, yid, entityMode, factory);
    }

    public boolean isXMLElement() {
        return this.isEmbeddedInXML;
    }

    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        if (!this.isEmbeddedInXML) {
            return this.getIdentifierType(factory).fromXMLNode(xml, factory);
        }
        return xml;
    }

    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (!this.isEmbeddedInXML) {
            this.getIdentifierType(factory).setToXMLNode(node, value, factory);
        } else {
            Element elt = (Element)value;
            EntityType.replaceNode(node, new ElementWrapper(elt));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

