/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.util.JDBCExceptionReporter;
import org.hibernate.util.ReflectHelper;

public class SchemaExport {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$tool$hbm2ddl$SchemaExport == null ? (class$org$hibernate$tool$hbm2ddl$SchemaExport = SchemaExport.class$("org.hibernate.tool.hbm2ddl.SchemaExport")) : class$org$hibernate$tool$hbm2ddl$SchemaExport));
    private ConnectionHelper connectionHelper;
    private String[] dropSQL;
    private String[] createSQL;
    private String outputFile = null;
    private Dialect dialect;
    private String delimiter;
    private List exceptions;
    static /* synthetic */ Class class$org$hibernate$tool$hbm2ddl$SchemaExport;

    public SchemaExport(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaExport(Configuration cfg, Properties connectionProperties) throws HibernateException {
        this.dialect = Dialect.getDialect(connectionProperties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)connectionProperties);
        this.connectionHelper = new ProviderConnectionHelper(props);
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
        this.exceptions = new ArrayList();
    }

    public SchemaExport(Configuration cfg, Connection connection) {
        this.connectionHelper = new SuppliedConnectionHelper(connection);
        this.dialect = Dialect.getDialect(cfg.getProperties());
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
        this.exceptions = new ArrayList();
    }

    public SchemaExport setOutputFile(String filename) {
        this.outputFile = filename;
        return this;
    }

    public SchemaExport setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public void create(boolean script, boolean export) {
        this.execute(script, export, false, true);
    }

    public void drop(boolean script, boolean export) {
        this.execute(script, export, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void execute(boolean script, boolean export, boolean justDrop, boolean format) {
        block38: {
            String formatted;
            log.info((Object)"Running hbm2ddl schema export");
            Connection connection = null;
            OutputStreamWriter fileOutput = null;
            Statement statement = null;
            this.exceptions.clear();
            if (this.outputFile != null) {
                log.info((Object)("writing generated schema to file: " + this.outputFile));
                fileOutput = new FileWriter(this.outputFile);
            }
            if (export) {
                log.info((Object)"exporting generated schema to database");
                connection = this.connectionHelper.getConnection();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                    connection.setAutoCommit(true);
                }
                statement = connection.createStatement();
            }
            for (int i = 0; i < this.dropSQL.length; ++i) {
                try {
                    formatted = this.dropSQL[i];
                    if (this.delimiter != null) {
                        formatted = formatted + this.delimiter;
                    }
                    if (script) {
                        System.out.println(formatted);
                    }
                    log.debug((Object)formatted);
                    if (this.outputFile != null) {
                        fileOutput.write(formatted + "\n");
                    }
                    if (!export) continue;
                    statement.executeUpdate(this.dropSQL[i]);
                    continue;
                }
                catch (SQLException e) {
                    this.exceptions.add(e);
                    log.debug((Object)("Unsuccessful: " + this.dropSQL[i]));
                    log.debug((Object)e.getMessage());
                }
            }
            if (!justDrop) {
                for (int j = 0; j < this.createSQL.length; ++j) {
                    try {
                        String string = formatted = format ? SchemaExport.format(this.createSQL[j]) : this.createSQL[j];
                        if (this.delimiter != null) {
                            formatted = formatted + this.delimiter;
                        }
                        if (script) {
                            System.out.println(formatted);
                        }
                        log.debug((Object)formatted);
                        if (this.outputFile != null) {
                            fileOutput.write(formatted + "\n");
                        }
                        if (!export) continue;
                        statement.executeUpdate(this.createSQL[j]);
                        continue;
                    }
                    catch (SQLException e) {
                        this.exceptions.add(e);
                        log.error((Object)("Unsuccessful: " + this.createSQL[j]));
                        log.error((Object)e.getMessage());
                    }
                }
            }
            log.info((Object)"schema export complete");
            Object var11_13 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    this.connectionHelper.release();
                }
            }
            catch (Exception e2) {
                this.exceptions.add(e2);
                log.error((Object)"Could not close connection", (Throwable)e2);
            }
            try {
                if (fileOutput != null) {
                    fileOutput.close();
                }
                break block38;
            }
            catch (IOException ioe) {
                this.exceptions.add(ioe);
                log.error((Object)("Error closing output file: " + this.outputFile), (Throwable)ioe);
            }
            break block38;
            {
                catch (Exception e) {
                    this.exceptions.add(e);
                    log.error((Object)"schema export unsuccessful", (Throwable)e);
                    Object var11_14 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            this.connectionHelper.release();
                        }
                    }
                    catch (Exception e2) {
                        this.exceptions.add(e2);
                        log.error((Object)"Could not close connection", (Throwable)e2);
                    }
                    try {
                        if (fileOutput != null) {
                            fileOutput.close();
                        }
                        break block38;
                    }
                    catch (IOException ioe) {
                        this.exceptions.add(ioe);
                        log.error((Object)("Error closing output file: " + this.outputFile), (Throwable)ioe);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        this.connectionHelper.release();
                    }
                }
                catch (Exception e2) {
                    this.exceptions.add(e2);
                    log.error((Object)"Could not close connection", (Throwable)e2);
                }
                try {
                    if (fileOutput != null) {
                        fileOutput.close();
                    }
                }
                catch (IOException ioe) {
                    this.exceptions.add(ioe);
                    log.error((Object)("Error closing output file: " + this.outputFile), (Throwable)ioe);
                }
                throw throwable;
            }
        }
    }

    private static String format(String sql) {
        String formatted;
        if (sql.indexOf("\"") > 0 || sql.indexOf("'") > 0) {
            return sql;
        }
        if (sql.toLowerCase().startsWith("create table")) {
            StringBuffer result = new StringBuffer(60);
            StringTokenizer tokens = new StringTokenizer(sql, "(,)", true);
            int depth = 0;
            while (tokens.hasMoreTokens()) {
                String tok = tokens.nextToken();
                if (")".equals(tok) && --depth == 0) {
                    result.append("\n");
                }
                result.append(tok);
                if (",".equals(tok) && depth == 1) {
                    result.append("\n  ");
                }
                if (!"(".equals(tok) || ++depth != 1) continue;
                result.append("\n   ");
            }
            formatted = result.toString();
        } else {
            formatted = sql;
        }
        return formatted;
    }

    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            boolean script = true;
            boolean drop = false;
            boolean export = true;
            String outFile = null;
            String propFile = null;
            boolean formatSQL = false;
            String delim = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("--")) {
                    if (args[i].equals("--quiet")) {
                        script = false;
                        continue;
                    }
                    if (args[i].equals("--drop")) {
                        drop = true;
                        continue;
                    }
                    if (args[i].equals("--text")) {
                        export = false;
                        continue;
                    }
                    if (args[i].startsWith("--output=")) {
                        outFile = args[i].substring(9);
                        continue;
                    }
                    if (args[i].startsWith("--properties=")) {
                        propFile = args[i].substring(13);
                        continue;
                    }
                    if (args[i].equals("--format")) {
                        formatSQL = true;
                        continue;
                    }
                    if (args[i].startsWith("--delimiter=")) {
                        delim = args[i].substring(12);
                        continue;
                    }
                    if (args[i].startsWith("--config=")) {
                        cfg.configure(args[i].substring(9));
                        continue;
                    }
                    if (!args[i].startsWith("--naming=")) continue;
                    cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(args[i].substring(9)).newInstance());
                    continue;
                }
                String filename = args[i];
                if (filename.endsWith(".jar")) {
                    cfg.addJar(new File(filename));
                    continue;
                }
                cfg.addFile(filename);
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.load(new FileInputStream(propFile));
                new SchemaExport(cfg, props).setOutputFile(outFile).setDelimiter(delim).execute(script, export, drop, formatSQL);
            } else {
                new SchemaExport(cfg).setOutputFile(outFile).setDelimiter(delim).execute(script, export, drop, formatSQL);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error creating schema ", (Throwable)e);
            e.printStackTrace();
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ProviderConnectionHelper
    implements ConnectionHelper {
        private Properties cfgProperties;
        private ConnectionProvider connectionProvider;
        private Connection connection;

        public ProviderConnectionHelper(Properties cfgProperties) {
            this.cfgProperties = cfgProperties;
        }

        public Connection getConnection() throws SQLException {
            if (this.connection == null) {
                this.connectionProvider = ConnectionProviderFactory.newConnectionProvider(this.cfgProperties);
                this.connection = this.connectionProvider.getConnection();
                if (!this.connection.getAutoCommit()) {
                    this.connection.commit();
                    this.connection.setAutoCommit(true);
                }
            }
            return this.connection;
        }

        public void release() throws SQLException {
            if (this.connection != null) {
                JDBCExceptionReporter.logAndClearWarnings(this.connection);
                this.connectionProvider.closeConnection(this.connection);
                this.connectionProvider.close();
            }
            this.connection = null;
        }
    }

    private class SuppliedConnectionHelper
    implements ConnectionHelper {
        private Connection connection;

        public SuppliedConnectionHelper(Connection connection) {
            this.connection = connection;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void release() {
            JDBCExceptionReporter.logAndClearWarnings(this.connection);
            this.connection = null;
        }
    }

    private static interface ConnectionHelper {
        public Connection getConnection() throws SQLException;

        public void release() throws SQLException;
    }
}

