/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import org.hibernate.EntityMode;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;

public final class CollectionKey
implements Serializable {
    private final String role;
    private final Serializable key;
    private final Type keyType;
    private final SessionFactoryImplementor factory;
    private final int hashCode;
    private EntityMode entityMode;

    public CollectionKey(CollectionPersister persister, Serializable key, EntityMode em) {
        this.entityMode = em;
        this.role = persister.getRole();
        this.key = key;
        this.keyType = persister.getKeyType();
        this.factory = persister.getFactory();
        this.hashCode = this.getHashCode();
    }

    public boolean equals(Object other) {
        CollectionKey that = (CollectionKey)other;
        return that.role.equals(this.role) && this.keyType.isEqual(that.key, this.key, this.entityMode, this.factory);
    }

    public int getHashCode() {
        int result = 17;
        result = 37 * result + this.role.hashCode();
        result = 37 * result + this.keyType.getHashCode(this.key, this.entityMode, this.factory);
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getRole() {
        return this.role;
    }

    public Serializable getKey() {
        return this.key;
    }

    public String toString() {
        return "CollectionKey" + MessageHelper.collectionInfoString(this.factory.getCollectionPersister(this.role), this.key, this.factory);
    }
}

