/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.Dialect;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DecodeCaseFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.OracleJoinFragment;
import org.hibernate.util.StringHelper;

public class SAPDBDialect
extends Dialect {
    public SAPDBDialect() {
        this.registerColumnType(-7, "boolean");
        this.registerColumnType(-5, "fixed(19,0)");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "fixed(3,0)");
        this.registerColumnType(4, "int");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "long byte");
        this.registerColumnType(2, "fixed($p,$s)");
        this.registerColumnType(2005, "long varchar");
        this.registerColumnType(2004, "long byte");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    public boolean dropConstraints() {
        return false;
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey) {
        return new StringBuffer(30).append(" foreign key ").append(constraintName).append(" (").append(StringHelper.join(", ", foreignKey)).append(") references ").append(referencedTable).toString();
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " primary key ";
    }

    public String getNullColumnString() {
        return " null";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getQuerySequencesString() {
        return "select sequence_name from domain.sequences";
    }

    public JoinFragment createOuterJoinFragment() {
        return new OracleJoinFragment();
    }

    public boolean supportsSequences() {
        return true;
    }

    public CaseFragment createCaseFragment() {
        return new DecodeCaseFragment();
    }
}

