/*
 * Decompiled with CFR 0.152.
 */
package test.implementation.notification;

import java.util.ArrayList;
import java.util.Iterator;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import junit.framework.TestCase;
import org.jboss.mx.notification.AsynchNotificationBroadcasterSupport;
import test.implementation.notification.support.Listener;

public class AsynchNotificationBroadcasterSupportTestCase
extends TestCase {
    private ArrayList sent = new ArrayList();
    private long sequence = 0L;
    private static final String DEFAULT_TYPE = "DefaultType";
    private static final String ANOTHER_TYPE = "AnotherType";
    private static final ArrayList EMPTY = new ArrayList();

    public AsynchNotificationBroadcasterSupportTestCase(String s) {
        super(s);
    }

    public void testAsynchDelivery() throws Exception {
        AsynchNotificationBroadcasterSupport broadcaster = new AsynchNotificationBroadcasterSupport();
        Listener listener = new Listener();
        broadcaster.addNotificationListener((NotificationListener)listener, null, null);
        this.clear();
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
        listener.doNotify(true);
        listener.doWait(false);
        this.compare(this.sent, this.received(listener, null));
    }

    public void testAsynchDeliveryTwice() throws Exception {
        AsynchNotificationBroadcasterSupport broadcaster = new AsynchNotificationBroadcasterSupport();
        Listener listener1 = new Listener();
        broadcaster.addNotificationListener((NotificationListener)listener1, null, null);
        Listener listener2 = new Listener();
        broadcaster.addNotificationListener((NotificationListener)listener2, null, null);
        this.clear();
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener1, null));
        this.compare(EMPTY, this.received(listener2, null));
        listener1.doNotify(true);
        listener1.doWait(false);
        this.compare(this.sent, this.received(listener1, null));
        this.compare(EMPTY, this.received(listener2, null));
        listener2.doNotify(true);
        listener2.doWait(false);
        this.compare(this.sent, this.received(listener2, null));
    }

    private void createNotification(AsynchNotificationBroadcasterSupport broadcaster) {
        this.createNotification(broadcaster, DEFAULT_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNotification(AsynchNotificationBroadcasterSupport broadcaster, String type) {
        AsynchNotificationBroadcasterSupportTestCase asynchNotificationBroadcasterSupportTestCase = this;
        synchronized (asynchNotificationBroadcasterSupportTestCase) {
            ++this.sequence;
        }
        Notification notification = new Notification(type, broadcaster, this.sequence);
        this.sent.add(notification);
        broadcaster.sendNotification(notification);
    }

    private void clear() {
        this.sent.clear();
    }

    private ArrayList apply(ArrayList sent, NotificationFilterSupport filter) {
        ArrayList<Notification> result = new ArrayList<Notification>();
        Iterator iterator = sent.iterator();
        while (iterator.hasNext()) {
            Notification notification = (Notification)iterator.next();
            if (!filter.isNotificationEnabled(notification)) continue;
            result.add(notification);
        }
        return result;
    }

    private ArrayList received(Listener listener, Object object) {
        ArrayList result = (ArrayList)listener.notifications.get(object);
        if (result == null) {
            result = EMPTY;
        }
        return result;
    }

    private void compare(ArrayList passedSent, ArrayList passedReceived) throws Exception {
        ArrayList sent = new ArrayList(passedSent);
        ArrayList received = new ArrayList(passedReceived);
        Iterator iterator = sent.iterator();
        while (iterator.hasNext()) {
            Notification notification = (Notification)iterator.next();
            boolean found = received.remove(notification);
            AsynchNotificationBroadcasterSupportTestCase.assertTrue((String)("Expected notification " + notification), (boolean)found);
        }
        AsynchNotificationBroadcasterSupportTestCase.assertTrue((String)("Didn't expect notification(s) " + received), (boolean)received.isEmpty());
    }
}

