/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.timer;

import java.util.ArrayList;
import java.util.Date;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.timer.TimerNotification;
import junit.framework.TestCase;

public class TimerTest
extends TestCase
implements NotificationListener {
    public static final long PERIOD = 100L;
    public static final long WAIT = 10000L;
    public static final long REPEATS = 2L;
    ObjectName timerName;
    MBeanServer server;
    ArrayList receivedNotifications = new ArrayList();

    public TimerTest(String s) {
        super(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleNotification() throws Exception {
        try {
            this.startTimerService();
            Integer id = this.addNotification("test", "hello", "data", this.calcTime(100L), 0L, 1L);
            this.expectNotifications(1);
        }
        finally {
            this.stopTimerService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRepeatedNotification() throws Exception {
        try {
            this.startTimerService();
            Integer id = this.addNotification("test", "hello", "data", this.calcTime(100L), 100L, 2L);
            this.expectNotifications(1);
            this.expectNotifications(2);
        }
        finally {
            this.stopTimerService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInfiniteNotification() throws Exception {
        try {
            this.startTimerService();
            Integer id = this.addNotification("test", "hello", "data", this.calcTime(100L), 100L, 0L);
            this.expectNotifications(1);
            this.expectNotifications(2);
            if (this.getNotificationType(id) == null) {
                TimerTest.fail((String)"Infinite notification not registered");
            }
        }
        finally {
            this.stopTimerService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoNotificationProducers() throws Exception {
        try {
            this.startTimerService();
            long lTimeOne = 5000L;
            long lTimeTwo = 12000L;
            long lWait = 2L * lTimeTwo;
            long lStart = this.calcTime(lTimeOne);
            Integer lIdOne = this.addNotification("test-2", "hello", "data", lStart + lTimeOne, lTimeOne, 0L);
            Integer lIdTwo = this.addNotification("test-2", "hello", "data", lStart + lTimeTwo, lTimeTwo, 0L);
            this.expectNotifications(1, lWait);
            this.expectNotifications(2, lWait);
            TimerNotification lNotificationOne = (TimerNotification)this.receivedNotifications.get(0);
            TimerNotification lNotificationTwo = (TimerNotification)this.receivedNotifications.get(1);
            this.checkNotificationID(lNotificationOne, lIdOne);
            this.checkNotificationID(lNotificationTwo, lIdOne);
            this.checkTimeDifference(lNotificationOne, lNotificationTwo, lTimeOne);
            this.expectNotifications(3, lWait);
            lNotificationOne = lNotificationTwo;
            lNotificationTwo = (TimerNotification)this.receivedNotifications.get(2);
            this.checkNotificationID(lNotificationTwo, lIdTwo);
            this.checkTimeDifference(lNotificationOne, lNotificationTwo, lTimeTwo - 2L * lTimeOne);
            this.expectNotifications(4, lWait);
            lNotificationOne = lNotificationTwo;
            lNotificationTwo = (TimerNotification)this.receivedNotifications.get(3);
            this.checkNotificationID(lNotificationTwo, lIdOne);
            this.checkTimeDifference(lNotificationOne, lNotificationTwo, 3L * lTimeOne - lTimeTwo);
            this.expectNotifications(5, lWait);
            lNotificationOne = lNotificationTwo;
            lNotificationTwo = (TimerNotification)this.receivedNotifications.get(4);
            this.checkNotificationID(lNotificationTwo, lIdOne);
            this.checkTimeDifference(lNotificationOne, lNotificationTwo, lTimeOne);
            this.expectNotifications(6, lWait);
            lNotificationOne = lNotificationTwo;
            lNotificationTwo = (TimerNotification)this.receivedNotifications.get(5);
            this.checkNotificationID(lNotificationTwo, lIdTwo);
            this.checkTimeDifference(lNotificationOne, lNotificationTwo, 2L * lTimeTwo - 4L * lTimeOne);
        }
        finally {
            this.stopTimerService();
        }
    }

    private void startTimerService() throws Exception {
        this.server = MBeanServerFactory.createMBeanServer("Timer");
        this.timerName = new ObjectName("Timer:type=TimerService");
        this.server.createMBean("javax.management.timer.Timer", this.timerName, new Object[0], new String[0]);
        this.server.invoke(this.timerName, "start", new Object[0], new String[0]);
        this.receivedNotifications.clear();
        this.server.addNotificationListener(this.timerName, this, null, null);
    }

    private void stopTimerService() {
        try {
            this.server.invoke(this.timerName, "removeAllNotifications", new Object[0], new String[0]);
            this.server.invoke(this.timerName, "stop", new Object[0], new String[0]);
            this.server.unregisterMBean(this.timerName);
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object handback) {
        ArrayList arrayList = this.receivedNotifications;
        synchronized (arrayList) {
            this.receivedNotifications.add(notification);
            this.receivedNotifications.notifyAll();
        }
    }

    public void expectNotifications(int expected) throws Exception {
        this.expectNotifications(expected, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expectNotifications(int expected, long wait) throws Exception {
        ArrayList arrayList = this.receivedNotifications;
        synchronized (arrayList) {
            if (this.receivedNotifications.size() > expected) {
                TimerTest.fail((String)"too many notifications");
            }
            if (this.receivedNotifications.size() < expected) {
                this.receivedNotifications.wait(wait);
            }
            TimerTest.assertEquals((int)expected, (int)this.receivedNotifications.size());
        }
    }

    public void checkNotificationID(TimerNotification pNotification, Integer pNotificationID) {
        if (pNotification == null) {
            TimerTest.fail((String)"Notification is null");
        }
        if (!pNotification.getNotificationID().equals(pNotificationID)) {
            TimerTest.fail((String)("Wrong Notification ID received: " + pNotification.getNotificationID() + ", expected: " + pNotificationID));
        }
    }

    public void checkTimeDifference(TimerNotification pNotificationOne, TimerNotification pNotificationTwo, long pTimeDiffernce) {
        long lDiff = pNotificationTwo.getTimeStamp() - pNotificationOne.getTimeStamp();
        if (lDiff < pTimeDiffernce - pTimeDiffernce / 10L || lDiff > pTimeDiffernce + pTimeDiffernce / 10L) {
            TimerTest.fail((String)("Time between first two notification is too small or too big: " + pTimeDiffernce));
        }
    }

    private Integer addNotification(String type, String message, String data, long time, long period, long occurs) throws Exception {
        return (Integer)this.server.invoke(this.timerName, "addNotification", new Object[]{type, message, data, new Date(time), new Long(period), new Long(occurs)}, new String[]{"java.lang.String", "java.lang.String", "java.lang.Object", "java.util.Date", "long", "long"});
    }

    private String getNotificationType(Integer id) throws Exception {
        Thread.yield();
        return (String)this.server.invoke(this.timerName, "getNotificationType", new Object[]{id}, new String[]{"java.lang.Integer"});
    }

    private long calcTime(long offset) {
        return System.currentTimeMillis() + offset;
    }
}

