/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.standard;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import junit.framework.TestCase;
import test.compliance.standard.support.MBeanRunnable;
import test.compliance.standard.support.MyRunnable;
import test.compliance.standard.support.MyStandardMBean;
import test.compliance.standard.support.NoConstructorsStandardMBean;
import test.compliance.standard.support.Trivial;

public class StandardMBeanTEST
extends TestCase {
    static /* synthetic */ Class class$java$lang$Runnable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$test$compliance$standard$support$TrivialMBean;
    static /* synthetic */ Class class$test$compliance$standard$support$ArbitraryInterface;

    public StandardMBeanTEST(String s) {
        super(s);
    }

    public void testOverrideManagementInterface() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName("test:test=test");
        server.registerMBean(new MBeanRunnable(), name);
        server.invoke(name, "run", new Object[0], new String[0]);
    }

    public void testSpecifyManagementInterface() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName("test:test=test");
        server.registerMBean(new StandardMBean(new MyRunnable(), class$java$lang$Runnable == null ? (class$java$lang$Runnable = StandardMBeanTEST.class$("java.lang.Runnable")) : class$java$lang$Runnable), name);
        server.invoke(name, "run", new Object[0], new String[0]);
    }

    public void testDontSpecifyManagementInterface() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName("test:test=test");
        server.registerMBean(new StandardMBean(new Trivial(), null), name);
        server.invoke(name, "doOperation", new Object[]{"arg"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = StandardMBeanTEST.class$("java.lang.String")) : class$java$lang$String).getName()});
    }

    public void testGetImplementationImplied() throws Exception {
        MBeanRunnable std = new MBeanRunnable();
        StandardMBeanTEST.assertTrue((String)"MBeanRunnable is its own implementation", (std == std.getImplementation() ? 1 : 0) != 0);
        StandardMBeanTEST.assertTrue((String)"MBeanRunnable is its own implementation class", (std.getClass() == std.getImplementationClass() ? 1 : 0) != 0);
    }

    public void testGetImplementationSpecified() throws Exception {
        MyRunnable obj = new MyRunnable();
        StandardMBean std = new StandardMBean(obj, class$java$lang$Runnable == null ? (class$java$lang$Runnable = StandardMBeanTEST.class$("java.lang.Runnable")) : class$java$lang$Runnable);
        StandardMBeanTEST.assertTrue((String)"MyRunnable is the implementation", (obj == std.getImplementation() ? 1 : 0) != 0);
        StandardMBeanTEST.assertTrue((String)"MyRunnable is the implementation class", (obj.getClass() == std.getImplementationClass() ? 1 : 0) != 0);
    }

    public void testMBeanInterfaceImplied() throws Exception {
        MBeanRunnable std = new MBeanRunnable();
        StandardMBeanTEST.assertTrue((String)"MBeanRunnable has Runnable as a management interface", ((class$java$lang$Runnable == null ? (class$java$lang$Runnable = StandardMBeanTEST.class$("java.lang.Runnable")) : class$java$lang$Runnable) == std.getMBeanInterface() ? 1 : 0) != 0);
    }

    public void testMBeanInterfaceSpecified() throws Exception {
        MyRunnable obj = new MyRunnable();
        StandardMBean std = new StandardMBean(obj, class$java$lang$Runnable == null ? (class$java$lang$Runnable = StandardMBeanTEST.class$("java.lang.Runnable")) : class$java$lang$Runnable);
        StandardMBeanTEST.assertTrue((String)"MyRunnable has Runnable as a management interface", ((class$java$lang$Runnable == null ? (class$java$lang$Runnable = StandardMBeanTEST.class$("java.lang.Runnable")) : class$java$lang$Runnable) == std.getMBeanInterface() ? 1 : 0) != 0);
    }

    public void testMBeanInterfaceOldStyle() throws Exception {
        Trivial obj = new Trivial();
        StandardMBean std = new StandardMBean(obj, null);
        StandardMBeanTEST.assertTrue((String)"Trivial has TrivialMBean as a management interface", ((class$test$compliance$standard$support$TrivialMBean == null ? (class$test$compliance$standard$support$TrivialMBean = StandardMBeanTEST.class$("test.compliance.standard.support.TrivialMBean")) : class$test$compliance$standard$support$TrivialMBean) == std.getMBeanInterface() ? 1 : 0) != 0);
    }

    public void testMetaData() throws Exception {
        MBeanParameterInfo[] params;
        MyStandardMBean std = new MyStandardMBean();
        MBeanInfo info = std.getMBeanInfo();
        StandardMBeanTEST.assertEquals((String)"MBEAN_CLASSNAME", (String)info.getClassName());
        StandardMBeanTEST.assertEquals((String)"MBEAN_DESCRIPTION", (String)info.getDescription());
        MBeanAttributeInfo[] attributes = info.getAttributes();
        StandardMBeanTEST.assertEquals((int)attributes.length, (int)1);
        StandardMBeanTEST.assertEquals((String)"MBEAN_ATTRIBUTE_DESCRIPTIONAnAttribute", (String)attributes[0].getDescription());
        MBeanConstructorInfo[] constructors = info.getConstructors();
        StandardMBeanTEST.assertEquals((int)constructors.length, (int)2);
        for (int i = 0; i < 2; ++i) {
            if (constructors[i].getSignature().length == 0) {
                StandardMBeanTEST.assertEquals((String)"MBEAN_CONSTRUCTOR_DESCRIPTION0", (String)constructors[i].getDescription());
                continue;
            }
            StandardMBeanTEST.assertEquals((String)"MBEAN_CONSTRUCTOR_DESCRIPTION2", (String)constructors[i].getDescription());
            params = constructors[i].getSignature();
            StandardMBeanTEST.assertEquals((int)params.length, (int)2);
            StandardMBeanTEST.assertEquals((String)"MBEAN_PARAMETER0", (String)params[0].getName());
            StandardMBeanTEST.assertEquals((String)"MBEAN_PARAMETER1", (String)params[1].getName());
            StandardMBeanTEST.assertEquals((String)"MBEAN_PARAMETER_DESCRIPTION0", (String)params[0].getDescription());
            StandardMBeanTEST.assertEquals((String)"MBEAN_PARAMETER_DESCRIPTION1", (String)params[1].getDescription());
        }
        MBeanOperationInfo[] operations = info.getOperations();
        StandardMBeanTEST.assertEquals((int)operations.length, (int)1);
        StandardMBeanTEST.assertEquals((String)"MBEAN_OPERATION_DESCRIPTIONanOperation", (String)operations[0].getDescription());
        params = operations[0].getSignature();
        StandardMBeanTEST.assertEquals((int)params.length, (int)2);
        StandardMBeanTEST.assertEquals((String)"MBEAN_PARAMETERanOperation0", (String)params[0].getName());
        StandardMBeanTEST.assertEquals((String)"MBEAN_PARAMETERanOperation1", (String)params[1].getName());
        StandardMBeanTEST.assertEquals((String)"MBEAN_PARAMETER_DESCRIPTIONanOperation0", (String)params[0].getDescription());
        StandardMBeanTEST.assertEquals((String)"MBEAN_PARAMETER_DESCRIPTIONanOperation1", (String)params[1].getDescription());
        StandardMBeanTEST.assertEquals((int)1, (int)operations[0].getImpact());
    }

    public void testNoConstructorsMetaData() throws Exception {
        NoConstructorsStandardMBean std = new NoConstructorsStandardMBean();
        MBeanInfo info = std.getMBeanInfo();
        MBeanConstructorInfo[] constructors = info.getConstructors();
        StandardMBeanTEST.assertEquals((int)constructors.length, (int)0);
    }

    public void testCaching() throws Exception {
        MyStandardMBean std = new MyStandardMBean();
        MBeanInfo info = std.getMBeanInfo();
        StandardMBeanTEST.assertTrue((String)"MBeanInfo should be cached", (info == std.getMBeanInfo() ? 1 : 0) != 0);
    }

    public void testErrors() throws Exception {
        ObjectName name;
        MBeanServer server;
        boolean caught = false;
        try {
            new StandardMBean(null, class$java$lang$Runnable == null ? (class$java$lang$Runnable = StandardMBeanTEST.class$("java.lang.Runnable")) : class$java$lang$Runnable);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        StandardMBeanTEST.assertTrue((String)"Expected IllegalArgumentException for null implementation", (boolean)caught);
        caught = false;
        try {
            new StandardMBean(new MyRunnable(), class$test$compliance$standard$support$ArbitraryInterface == null ? (class$test$compliance$standard$support$ArbitraryInterface = StandardMBeanTEST.class$("test.compliance.standard.support.ArbitraryInterface")) : class$test$compliance$standard$support$ArbitraryInterface);
        }
        catch (NotCompliantMBeanException e) {
            caught = true;
        }
        StandardMBeanTEST.assertTrue((String)"Expected NotCompliantMBeanException for the wrong management interface", (boolean)caught);
        caught = false;
        try {
            new StandardMBean(new MyRunnable(), null);
        }
        catch (NotCompliantMBeanException e) {
            caught = true;
        }
        StandardMBeanTEST.assertTrue((String)"Expected NotCompliantMBeanException for null management interface", (boolean)caught);
        caught = false;
        try {
            server = MBeanServerFactory.newMBeanServer();
            name = new ObjectName("test:test=test");
            server.registerMBean(new MBeanRunnable(true), name);
        }
        catch (NotCompliantMBeanException e) {
            caught = true;
        }
        StandardMBeanTEST.assertTrue((String)"Expected NotCompliantMBeanException for wrong management interface", (boolean)caught);
        caught = false;
        try {
            server = MBeanServerFactory.newMBeanServer();
            name = new ObjectName("test:test=test");
            server.registerMBean(new MBeanRunnable(0), name);
        }
        catch (NotCompliantMBeanException e) {
            caught = true;
        }
        StandardMBeanTEST.assertTrue((String)"Expected NotCompliantMBeanException for null management interface", (boolean)caught);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

