/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.server;

import java.util.Arrays;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.MLet;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import test.compliance.server.support.BabarError;
import test.compliance.server.support.Base;
import test.compliance.server.support.Broadcaster;
import test.compliance.server.support.Derived;
import test.compliance.server.support.Dynamic;
import test.compliance.server.support.ExceptionOnTheRun;
import test.compliance.server.support.LockedTest;
import test.compliance.server.support.LockedTest2;
import test.compliance.server.support.LockedTest3;
import test.compliance.server.support.MBeanListener;
import test.compliance.server.support.MyScreamingException;
import test.compliance.server.support.Test;
import test.compliance.server.support.Test2;
import test.compliance.server.support.Test3;
import test.compliance.server.support.Test4;
import test.compliance.server.support.Unrelated;

public class MBeanServerTEST
extends TestCase {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$test$compliance$server$support$BaseMBean;
    static /* synthetic */ Class class$test$compliance$server$support$Base;
    static /* synthetic */ Class class$test$compliance$server$support$Derived;
    static /* synthetic */ Class class$test$compliance$server$support$UnrelatedMBean;
    static /* synthetic */ Class class$test$compliance$server$support$Unrelated;

    public MBeanServerTEST(String s) {
        super(s);
    }

    public void testInvokeWithPrimitiveBooleanReturn() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName(":test=test");
        server.registerMBean(new Test(), name);
        Boolean bool = (Boolean)server.invoke(name, "opWithPrimBooleanReturn", null, null);
        MBeanServerTEST.assertTrue((bool == true ? 1 : 0) != 0);
    }

    public void testInvokeWithPrimitiveLongArrayReturn() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName(":test=test");
        server.registerMBean(new Test(), name);
        long[] array = (long[])server.invoke(name, "opWithPrimLongArrayReturn", null, null);
        MBeanServerTEST.assertTrue((array[0] == 1L ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((array[1] == 2L ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((array[2] == 3L ? 1 : 0) != 0);
    }

    public void testInvokeWithLongArrayReturn() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName(":test=test");
        server.registerMBean(new Test(), name);
        Long[] array = (Long[])server.invoke(name, "opWithLongArrayReturn", null, null);
        MBeanServerTEST.assertTrue((array[0] == 1L ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((array[1] == 2L ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((array[2] == 3L ? 1 : 0) != 0);
    }

    public void testInvokeWithPrimitiveLongReturn() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName(":test=test");
        server.registerMBean(new Test(), name);
        Long l = (Long)server.invoke(name, "opWithPrimLongReturn", null, null);
        MBeanServerTEST.assertTrue((l == 1234567890123L ? 1 : 0) != 0);
    }

    public void testInvokeWithPrimitiveDoubleReturn() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName(":test=test");
        server.registerMBean(new Test(), name);
        Double d = (Double)server.invoke(name, "opWithPrimDoubleReturn", null, null);
        MBeanServerTEST.assertTrue((d == 0.1234567890123 ? 1 : 0) != 0);
    }

    public void testInvokeWithLongSignature() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName(":test=test");
        server.registerMBean(new Test(), name);
        server.invoke(name, "opWithLongSignature", new Object[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(18), new Integer(19), new Integer(20)}, new String[]{"int", "int", "int", "int", "int", "int", "int", "int", "int", "int", "int", "int", "int", "int", "int", "int", "int", "int", "int", "int"});
    }

    public void testInvokeWithMixedSignature() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName(":test=test");
        server.registerMBean(new Test(), name);
        server.invoke(name, "opWithMixedSignature", new Object[]{new Integer(1), new Double(2.2), new Long(333L), new Boolean(true), new Byte(2), new Short(6), new long[]{7L, 8L}, new Long[]{new Long(1L), new Long(2L)}, new Short(9), new Byte(10), new Long(11L), new Double(1.2), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(18), new Integer(19), new Integer(20)}, new String[]{"int", "double", "long", "boolean", "byte", "short", "[J", "[Ljava.lang.Long;", "java.lang.Short", "java.lang.Byte", "java.lang.Long", "java.lang.Double", "int", "int", "int", "int", "int", "int", "int", "int"});
    }

    public void testInvokeWithNonExistantMBean() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            server.invoke(new ObjectName(":mbean=doesnotexist"), "noMethod", null, null);
            MBeanServerTEST.fail((String)"InstanceNotFoundException was not thrown from an invoke operation on a non-existant MBean.");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    public void testInvokeWithBusinessException() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            ObjectName name = new ObjectName("test:test=test");
            server.registerMBean(new Test(), name);
            server.invoke(name, "operationWithException", null, null);
            MBeanServerTEST.fail((String)"MBeanException was not thrown.");
        }
        catch (MBeanException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof MyScreamingException));
        }
    }

    public void testGetAttributeWithNonExistingAttribute() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object foo = server.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "Foo");
            MBeanServerTEST.fail((String)"AttributeNotFoundexception was not thrown when invoking getAttribute() call on a non-existant attribute.");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
    }

    public void testGetAttributeWithBusinessException() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            ObjectName name = new ObjectName("test:test=test");
            server.registerMBean(new Test(), name);
            Object foo = server.getAttribute(name, "ThisWillScream");
            MBeanServerTEST.fail((String)"Did not throw the screaming exception");
        }
        catch (MBeanException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof MyScreamingException));
        }
    }

    public void testGetAttributeWithNonExistingMBean() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            ObjectName name = new ObjectName("test:name=DoesNotExist");
            server.getAttribute(name, "Whatever");
            MBeanServerTEST.fail((String)"InstanceNotFoundException was not thrown on a nonexistant MBean.");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    public void testGetAttributeWithUncheckedException() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            ObjectName name = new ObjectName("test:test=test");
            server.registerMBean(new Test(), name);
            server.getAttribute(name, "ThrowUncheckedException");
            MBeanServerTEST.fail((String)"RuntimeMBeanException was not thrown");
        }
        catch (RuntimeMBeanException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof ExceptionOnTheRun));
        }
    }

    public void testGetAttributeWithError() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            ObjectName name = new ObjectName("test:test=test");
            server.registerMBean(new Test(), name);
            server.getAttribute(name, "Error");
            MBeanServerTEST.fail((String)"Error was not thrown");
        }
        catch (RuntimeErrorException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetError() instanceof BabarError));
        }
    }

    public void testSetAttributeWithNonExistingAttribute() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            server.setAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), new Attribute("Foo", "value"));
            MBeanServerTEST.fail((String)"AttributeNotFoundexception was not thrown when invoking getAttribute() call on a non-existant attribute.");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
    }

    public void testSetAttributeWithBusinessException() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            ObjectName name = new ObjectName("test:test=test");
            server.registerMBean(new Test(), name);
            server.setAttribute(name, new Attribute("ThisWillScream", "value"));
            MBeanServerTEST.fail((String)"Did not throw the screaming exception");
        }
        catch (MBeanException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof MyScreamingException));
        }
    }

    public void testSetAttributeWithNonExistingMBean() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            ObjectName name = new ObjectName("test:name=DoesNotExist");
            server.setAttribute(name, new Attribute("Whatever", "nothing"));
            MBeanServerTEST.fail((String)"InstanceNotFoundException was not thrown on a nonexistant MBean.");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    public void testSetAttributeWithUncheckedException() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            ObjectName name = new ObjectName("test:test=test");
            server.registerMBean(new Test(), name);
            server.setAttribute(name, new Attribute("ThrowUncheckedException", "value"));
            MBeanServerTEST.fail((String)"RuntimeMBeanException was not thrown");
        }
        catch (RuntimeMBeanException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof ExceptionOnTheRun));
        }
    }

    public void testSetAttributeWithError() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            ObjectName name = new ObjectName("test:test=test");
            server.registerMBean(new Test(), name);
            server.setAttribute(name, new Attribute("Error", "value"));
            MBeanServerTEST.fail((String)"Error was not thrown");
        }
        catch (RuntimeErrorException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetError() instanceof BabarError));
        }
    }

    public void testInstantiateWithDefaultConstructor() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        Object o = server.instantiate("test.compliance.server.support.Test");
        MBeanServerTEST.assertTrue((boolean)(o instanceof Test));
    }

    public void testInstantiateWithDefaultConstructorAndApplicationException() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object o = server.instantiate("test.compliance.server.support.ConstructorTest");
            MBeanServerTEST.fail((String)"Instantiate should have thrown an MBeanException.");
        }
        catch (MBeanException mBeanException) {
            // empty catch block
        }
    }

    public void testInstantiateWithDefaultConstructorAndRuntimeException() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object o = server.instantiate("test.compliance.server.support.ConstructorTest2");
            MBeanServerTEST.fail((String)"Instantiate should have thrown a RuntimeMBeanException.");
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            // empty catch block
        }
    }

    public void testInstantiateWithDefaultConstructorAndError() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object o = server.instantiate("test.compliance.server.support.ConstructorTest3");
            MBeanServerTEST.fail((String)"Instantiate should have thrown a RuntimeErrorException.");
        }
        catch (RuntimeErrorException runtimeErrorException) {
            // empty catch block
        }
    }

    public void testInstantiateWithDefaultConstructorAndExceptionInInit() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            try {
                Object o = server.instantiate("test.compliance.server.support.ConstructorTest4");
            }
            catch (ExceptionInInitializerError e) {
                MBeanServerTEST.fail((String)"FAILS IN RI: MBeanServer fails to wrap an error or exception from a static initializer block correctly.");
            }
            MBeanServerTEST.fail((String)"Instantiate should have thrown a RuntimeMBeanException.");
        }
        catch (RuntimeMBeanException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof NullPointerException));
        }
    }

    public void testInstantiateWithDefaultConstructorAndErrorInInit() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            try {
                Object o = server.instantiate("test.compliance.server.support.ConstructorTest5");
            }
            catch (BabarError e) {
                MBeanServerTEST.fail((String)"FAILS IN RI: MBeanServer fails to wrap an error or exception from a static initializer block correctly.");
            }
            MBeanServerTEST.fail((String)"Instantiate should have thrown a RuntimeErrorException.");
        }
        catch (RuntimeErrorException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetError() instanceof BabarError));
        }
    }

    public void testInstantiateWithDefaultConstructorAndUnknownClass() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object o = server.instantiate("foo.Bar");
            MBeanServerTEST.fail((String)"Instantiate should have thrown a ReflectionException.");
        }
        catch (ReflectionException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof ClassNotFoundException));
        }
    }

    public void testInstantiateWithMissingDefaultConstructor() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object o = server.instantiate("test.compliance.server.support.ConstructorTest6");
            MBeanServerTEST.fail((String)"Instantiate should have thrown a ReflectionException.");
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public void testInstantiateWithInaccessibleNoArgsConstructor() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object o = server.instantiate("test.compliance.server.support.ConstructorTest7");
            MBeanServerTEST.fail((String)"Instantiate should have thrown a ReflectionException.");
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public void testInstantiateWithNullClassName() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object o = server.instantiate(null);
            MBeanServerTEST.fail((String)"incorrect exception behavior");
        }
        catch (RuntimeOperationsException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof IllegalArgumentException));
        }
    }

    public void testInstantiateWithEmptyClassName() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object o = server.instantiate("");
            MBeanServerTEST.fail((String)"incorrect exception/classloading behavior");
        }
        catch (ReflectionException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof ClassNotFoundException));
        }
    }

    public void testInstantiateWithNullClassName2() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object o = server.instantiate(null, null);
            MBeanServerTEST.fail((String)"incorrect exception behavior");
        }
        catch (RuntimeOperationsException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof IllegalArgumentException));
        }
    }

    public void testInstantiateWithEmptyClassName2() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object o = server.instantiate("", null);
            MBeanServerTEST.fail((String)"incorrect exception/classloading behavior");
        }
        catch (ReflectionException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof ClassNotFoundException));
        }
    }

    public void testInstantiateWithNullClassName3() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object o = server.instantiate(null, null, null);
            MBeanServerTEST.fail((String)"incorrect exception behavior");
        }
        catch (RuntimeOperationsException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof IllegalArgumentException));
        }
    }

    public void testInstantiateWithEmptyClassName3() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object o = server.instantiate("", null, null);
            MBeanServerTEST.fail((String)"incorrect exception/classloading behavior");
        }
        catch (ReflectionException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof ClassNotFoundException));
        }
    }

    public void testInstantiateWithNullClassName4() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object o = server.instantiate(null, null, null, null);
            MBeanServerTEST.fail((String)"incorrect exception behavior");
        }
        catch (RuntimeOperationsException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof IllegalArgumentException));
        }
    }

    public void testInstantiateWithEmptyClassName4() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Object o = server.instantiate("", null, null, null);
            MBeanServerTEST.fail((String)"incorrect exception/classloading behavior");
        }
        catch (ReflectionException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof ClassNotFoundException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstantiateWithDefaultLoaderRepository() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName(":test=test");
        try {
            mlet.addURL("file:./output/etc/test/compliance/server/Test.jar");
            server.registerMBean(mlet, name);
            Object o = server.instantiate("test.compliance.server.support.AClass");
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    public void testInstantiateWithDefaultLoaderRepository2() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            MLet mlet = new MLet();
            mlet.addURL("file:./output/etc/test/compliance/server/Test.jar");
            Object object = server.instantiate("test.compliance.server.support.AClass");
        }
        catch (ReflectionException e) {
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof ClassNotFoundException));
        }
    }

    public void testRegisterNullObjectName() throws Exception {
        boolean caught = false;
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            server.registerMBean(new Test(), null);
        }
        catch (RuntimeOperationsException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                caught = true;
            }
            MBeanServerTEST.fail((String)("Wrong wrapped exception " + e.getTargetException()));
        }
        if (!caught) {
            MBeanServerTEST.fail((String)"Allowed to register with a null object name");
        }
    }

    public void testRegisterPatternObjectName() throws Exception {
        boolean caught = false;
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            server.registerMBean(new Test(), new ObjectName("Domai?:type=test"));
        }
        catch (RuntimeOperationsException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                caught = true;
            }
            MBeanServerTEST.fail((String)("Wrong wrapped exception " + e.getTargetException()));
        }
        if (!caught) {
            MBeanServerTEST.fail((String)"Allowed to register with a pattern object name");
        }
    }

    public void testRegisterJMImplementationObjectName() throws Exception {
        boolean caught = false;
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            server.registerMBean(new Test(), new ObjectName("JMImplementation:type=test"));
        }
        catch (RuntimeOperationsException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                caught = true;
            }
            MBeanServerTEST.fail((String)("Wrong wrapped exception " + e.getTargetException()));
        }
        if (!caught) {
            MBeanServerTEST.fail((String)"Allowed to register into JMImplementation");
        }
    }

    public void testRegisterJMImplementationDefaultDomainObjectName() throws Exception {
        boolean caught = false;
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer("JMImplementation");
            server.registerMBean(new Test(), new ObjectName(":type=test"));
        }
        catch (RuntimeOperationsException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                caught = true;
            }
            MBeanServerTEST.fail((String)("Wrong wrapped exception " + e.getTargetException()));
        }
        if (!caught) {
            MBeanServerTEST.fail((String)"Allowed to register into JMImplementation");
        }
    }

    public void testRegisterMBeanOnExceptionFromPreRegister() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName("test:foo=bar");
        try {
            server.registerMBean(new Test2(), name);
            MBeanServerTEST.fail((String)"Test2 registered despite of throwing an exception from the preRegister() method.");
        }
        catch (MBeanRegistrationException e) {
            MBeanServerTEST.assertTrue((!server.isRegistered(name) ? 1 : 0) != 0);
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof RuntimeException));
        }
        catch (RuntimeMBeanException e) {
            MBeanServerTEST.fail((String)"FAILS IN RI: RuntimeMBeanException instead of MBeanRegistrationException?");
        }
    }

    public void testRegisterMBeanOnExceptionFromPreRegister2() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName("test:foo=bar");
        try {
            server.registerMBean(new Test3(), name);
            MBeanServerTEST.fail((String)"Test3 registered despite of throwin an exception from the preRegister() method");
        }
        catch (MBeanRegistrationException e) {
            MBeanServerTEST.assertTrue((!server.isRegistered(name) ? 1 : 0) != 0);
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof MyScreamingException));
        }
    }

    public void testRegisterMBeanOnExceptionFromPreRegister3() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName("test:foo=bar");
        try {
            server.registerMBean(new Test4(), name);
            MBeanServerTEST.fail((String)"Test4 registered despite of throwing an exception from the preRegister() method.");
        }
        catch (MBeanRegistrationException e) {
            MBeanServerTEST.assertTrue((!server.isRegistered(name) ? 1 : 0) != 0);
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof MyScreamingException));
        }
    }

    public void testUnregisterDelegate() throws Exception {
        boolean caught = false;
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            server.unregisterMBean(new ObjectName("JMImplementation:type=MBeanServerDelegate"));
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        if (!caught) {
            MBeanServerTEST.fail((String)"Allowed to unregister the delegate");
        }
    }

    public void testBasicUnregister() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName("test:foo=bar");
        server.registerMBean(new Test(), name);
        server.unregisterMBean(name);
    }

    public void testUnregisterWithDefaultDomainName() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            ObjectName name = new ObjectName(":foo=bar");
            server.registerMBean(new Test(), name);
            server.unregisterMBean(name);
        }
        catch (InstanceNotFoundException e) {
            MBeanServerTEST.fail((String)"FAILS IN RI: RI throws InstanceNotFoundException when an existing MBean is unregistered with an implicit default domain name.");
        }
    }

    public void testUnregisterWithObjectNameFromRegistration() throws Exception {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            ObjectName name = new ObjectName(":foo=bar");
            ObjectInstance oi = server.registerMBean(new Test(), name);
            name = oi.getObjectName();
            server.unregisterMBean(name);
        }
        catch (InstanceNotFoundException e) {
            MBeanServerTEST.fail((String)"FAILS IN RI: RI throws InstanceNotFoundException when an existing MBean is unregistered with an implicit default domain name retrieved from the ObjectInstance returned at registration time.");
        }
    }

    public void testUnregisterMBeanOnExceptionFromPreDeregister() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName("test:foo=bar");
        server.registerMBean(new LockedTest(), name);
        try {
            server.unregisterMBean(name);
            MBeanServerTEST.fail((String)"LockedTest unregistered despite of throwing an exception from the preDeregister() method.");
        }
        catch (MBeanRegistrationException e) {
            MBeanServerTEST.assertTrue((boolean)server.isRegistered(name));
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof RuntimeException));
        }
        catch (RuntimeMBeanException e) {
            MBeanServerTEST.fail((String)"FAILS IN RI: spec v1.0: any exception thrown from MBean's preDeregister() method should be wrapped in an MBeanRegistrationException by the agent.");
        }
    }

    public void testUnregisterMBeanOnExceptionFromPreDeregister2() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName("test:foo=bar");
        server.registerMBean(new LockedTest2(), name);
        try {
            server.unregisterMBean(name);
            MBeanServerTEST.fail((String)"LockedTest2 unregistered despite of throwin an exception from the preDeregister() method");
        }
        catch (MBeanRegistrationException e) {
            MBeanServerTEST.assertTrue((boolean)server.isRegistered(name));
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof MyScreamingException));
        }
    }

    public void testUnregisterMBeanOnExceptionFromPreDeregister3() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName("test:foo=bar");
        server.registerMBean(new LockedTest3(), name);
        try {
            server.unregisterMBean(name);
            MBeanServerTEST.fail((String)"LockedTest3 unregistered despite of throwing an exception from the preDeregister() method.");
        }
        catch (MBeanRegistrationException e) {
            MBeanServerTEST.assertTrue((boolean)server.isRegistered(name));
            MBeanServerTEST.assertTrue((boolean)(e.getTargetException() instanceof MyScreamingException));
        }
    }

    public synchronized void testAddNotificationListenerToDelegate() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        class MyNotificationListener
        implements NotificationListener {
            int notificationCount = 0;

            MyNotificationListener() {
            }

            public void handleNotification(Notification notification, Object handback) {
                try {
                    ++this.notificationCount;
                    Assert.assertTrue((boolean)(handback instanceof String));
                    Assert.assertTrue((boolean)handback.equals("MyHandback"));
                    Assert.assertTrue((boolean)notification.getSource().equals(new ObjectName("JMImplementation:type=MBeanServerDelegate")));
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected error: " + e.toString()));
                }
            }
        }
        MyNotificationListener listener = new MyNotificationListener();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("JMX.mbean.registered");
        server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener, (NotificationFilter)filter, (Object)"MyHandback");
        server.registerMBean(new Test(), new ObjectName(":foo=bar"));
        MBeanServerTEST.assertTrue((listener.notificationCount == 1 ? 1 : 0) != 0);
    }

    public synchronized void testAddMultipleListeners() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        class MyNotificationListener
        implements NotificationListener {
            Object handback;
            int result = 0;

            public MyNotificationListener(Object handback) {
                this.handback = handback;
            }

            public void handleNotification(Notification notification, Object handback) {
                ++this.result;
                Assert.assertEquals((Object)this.handback, (Object)handback);
                ++this.result;
            }
        }
        MyNotificationListener listener1 = new MyNotificationListener("handback1");
        MyNotificationListener listener2 = new MyNotificationListener("handback2");
        server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener1, null, (Object)"handback1");
        server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener2, null, (Object)"handback2");
        server.registerMBean(new Test(), new ObjectName(":foo=bar"));
        MBeanServerTEST.assertTrue((listener1.result == 2 ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((listener2.result == 2 ? 1 : 0) != 0);
    }

    public synchronized void testAddListenerMultipleHandbacks() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        class MyNotificationListener
        implements NotificationListener {
            boolean result1 = false;
            boolean result2 = false;

            MyNotificationListener() {
            }

            public void handleNotification(Notification notification, Object handback) {
                if (handback.equals("handback1")) {
                    this.result1 = true;
                } else if (handback.equals("handback2")) {
                    this.result2 = true;
                } else {
                    Assert.fail((String)("Unexpected handback: " + handback));
                }
            }
        }
        MyNotificationListener listener = new MyNotificationListener();
        server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener, null, (Object)"handback1");
        server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener, null, (Object)"handback2");
        server.registerMBean(new Test(), new ObjectName(":foo=bar"));
        MBeanServerTEST.assertTrue((boolean)listener.result1);
        MBeanServerTEST.assertTrue((boolean)listener.result2);
    }

    public synchronized void testRemoveListener() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        class MyNotificationListener
        implements NotificationListener {
            Object handback;
            int result = 0;

            public MyNotificationListener(Object handback) {
                this.handback = handback;
            }

            public void handleNotification(Notification notification, Object handback) {
                ++this.result;
                Assert.assertEquals((Object)this.handback, (Object)handback);
                ++this.result;
            }
        }
        MyNotificationListener listener1 = new MyNotificationListener("handback1");
        class MyOtherNotificationListener
        implements NotificationListener {
            boolean result1 = false;
            boolean result2 = false;

            MyOtherNotificationListener() {
            }

            public void handleNotification(Notification notification, Object handback) {
                if (handback.equals("handback1")) {
                    this.result1 = true;
                } else if (handback.equals("handback2")) {
                    this.result2 = true;
                } else {
                    Assert.fail((String)("Unexpected handback: " + handback));
                }
            }
        }
        MyOtherNotificationListener listener2 = new MyOtherNotificationListener();
        server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener1, null, (Object)"handback1");
        server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener2, null, (Object)"handback2");
        server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener2, null, (Object)"handback3");
        server.removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener2);
        server.registerMBean(new Test(), new ObjectName(":foo=bar"));
        MBeanServerTEST.assertTrue((listener1.result == 2 ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((!listener2.result1 ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((!listener2.result2 ? 1 : 0) != 0);
    }

    public synchronized void testRemoveTriplet() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        class MyNotificationListener
        implements NotificationListener {
            Object handback;
            int result = 0;

            public MyNotificationListener(Object handback) {
                this.handback = handback;
            }

            public void handleNotification(Notification notification, Object handback) {
                ++this.result;
                Assert.assertEquals((Object)this.handback, (Object)handback);
                ++this.result;
            }
        }
        MyNotificationListener listener1 = new MyNotificationListener("handback1");
        MyNotificationListener listener2 = new MyNotificationListener("handback2");
        server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener1, null, (Object)"handback1");
        server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener2, null, (Object)"handback2");
        server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener2, null, (Object)"handback3");
        server.removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener2, null, (Object)"handback3");
        server.registerMBean(new Test(), new ObjectName(":foo=bar"));
        MBeanServerTEST.assertTrue((listener1.result == 2 ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((listener1.result == 2 ? 1 : 0) != 0);
    }

    public synchronized void testRemoveBroadcaster() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName broadcasterName = new ObjectName("test:type=broadcaster");
        Broadcaster broadcaster = new Broadcaster();
        server.registerMBean(broadcaster, broadcasterName);
        class MyNotificationListener
        implements NotificationListener {
            long result = 0L;

            public void handleNotification(Notification notification, Object handback) {
                this.result = notification.getSequenceNumber();
            }
        }
        MyNotificationListener listener = new MyNotificationListener();
        server.addNotificationListener(broadcasterName, listener, null, null);
        broadcaster.doSomething();
        MBeanServerTEST.assertEquals((long)1L, (long)listener.result);
        server.unregisterMBean(broadcasterName);
        broadcaster.doSomething();
        try {
            MBeanServerTEST.assertEquals((long)1L, (long)listener.result);
        }
        catch (AssertionFailedError e) {
            MBeanServerTEST.fail((String)"FAILS IN RI: Removing a notification broadcaster does not remove the listeners registered against the object name.");
        }
    }

    public synchronized void testAddListenerToTwoBroadcasters() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName broadcasterName = new ObjectName("test:type=broadcaster");
        Broadcaster broadcaster = new Broadcaster();
        server.registerMBean(broadcaster, broadcasterName);
        class MyNotificationListener
        implements NotificationListener {
            long result = 0L;

            public void handleNotification(Notification notification, Object handback) {
                ++this.result;
            }
        }
        MyNotificationListener listener = new MyNotificationListener();
        server.addNotificationListener(broadcasterName, listener, null, null);
        server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener, null, null);
        broadcaster.doSomething();
        MBeanServerTEST.assertEquals((long)1L, (long)listener.result);
        server.registerMBean(new Test(), new ObjectName("Test:foo=bar"));
        MBeanServerTEST.assertEquals((long)2L, (long)listener.result);
        server.unregisterMBean(broadcasterName);
        MBeanServerTEST.assertEquals((long)3L, (long)listener.result);
        server.unregisterMBean(new ObjectName("Test:foo=bar"));
        MBeanServerTEST.assertEquals((long)4L, (long)listener.result);
    }

    public synchronized void testAddListenerToTwoBroadcastersRemoveOne() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName broadcasterName = new ObjectName("test:type=broadcaster");
        Broadcaster broadcaster = new Broadcaster();
        server.registerMBean(broadcaster, broadcasterName);
        class MyNotificationListener
        implements NotificationListener {
            long result = 0L;

            public void handleNotification(Notification notification, Object handback) {
                ++this.result;
            }
        }
        MyNotificationListener listener = new MyNotificationListener();
        server.addNotificationListener(broadcasterName, listener, null, null);
        server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), listener, null, null);
        server.removeNotificationListener(broadcasterName, listener);
        broadcaster.doSomething();
        MBeanServerTEST.assertEquals((long)0L, (long)listener.result);
        server.registerMBean(new Test(), new ObjectName("Test:foo=bar"));
        MBeanServerTEST.assertEquals((long)1L, (long)listener.result);
    }

    public synchronized void testaddMBeanToDelegate() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        MBeanListener listener = new MBeanListener();
        ObjectName listenerName = new ObjectName("test:type=listener");
        server.registerMBean(listener, listenerName);
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("JMX.mbean.registered");
        ObjectName delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        server.addNotificationListener(delegateName, listenerName, (NotificationFilter)filter, (Object)"MyHandback");
        server.registerMBean(new Test(), new ObjectName(":foo=bar"));
        MBeanServerTEST.assertTrue((listener.count == 1L ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((boolean)listener.source.equals(delegateName));
        MBeanServerTEST.assertTrue((boolean)listener.handback.equals("MyHandback"));
    }

    public synchronized void testAddMBeanMultipleListeners() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        MBeanListener listener1 = new MBeanListener();
        ObjectName listenerName1 = new ObjectName("test:type=listener1");
        server.registerMBean(listener1, listenerName1);
        MBeanListener listener2 = new MBeanListener();
        ObjectName listenerName2 = new ObjectName("test:type=listener2");
        server.registerMBean(listener2, listenerName2);
        ObjectName delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        server.addNotificationListener(delegateName, listenerName1, null, (Object)"handback1");
        server.addNotificationListener(delegateName, listenerName2, null, (Object)"handback2");
        server.registerMBean(new Test(), new ObjectName(":foo=bar"));
        MBeanServerTEST.assertEquals((long)1L, (long)listener1.count);
        MBeanServerTEST.assertEquals((Object)listener1.source, (Object)delegateName);
        MBeanServerTEST.assertEquals((Object)listener1.handback, (Object)"handback1");
        MBeanServerTEST.assertEquals((long)1L, (long)listener2.count);
        MBeanServerTEST.assertEquals((Object)listener2.source, (Object)delegateName);
        MBeanServerTEST.assertEquals((Object)listener2.handback, (Object)"handback2");
    }

    public synchronized void testAddMBeanListenerMultipleHandbacks() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        MBeanListener listener = new MBeanListener("handback1", "handback2");
        ObjectName listenerName = new ObjectName("test:type=listener");
        server.registerMBean(listener, listenerName);
        ObjectName delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        server.addNotificationListener(delegateName, listenerName, null, (Object)"handback1");
        server.addNotificationListener(delegateName, listenerName, null, (Object)"handback2");
        server.registerMBean(new Test(), new ObjectName(":foo=bar"));
        MBeanServerTEST.assertTrue((listener.count1 == 1L ? 1 : 0) != 0);
        MBeanServerTEST.assertEquals((Object)listener.source1, (Object)delegateName);
        MBeanServerTEST.assertEquals((Object)listener.handback1, (Object)"handback1");
        MBeanServerTEST.assertTrue((listener.count2 == 1L ? 1 : 0) != 0);
        MBeanServerTEST.assertEquals((Object)listener.source2, (Object)delegateName);
        MBeanServerTEST.assertEquals((Object)listener.handback2, (Object)"handback2");
    }

    public synchronized void testMBeanRemoveListener() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        MBeanListener listener1 = new MBeanListener();
        ObjectName listenerName1 = new ObjectName("test:type=listener1");
        server.registerMBean(listener1, listenerName1);
        MBeanListener listener2 = new MBeanListener("handback2", "handback3");
        ObjectName listenerName2 = new ObjectName("test:type=listener2");
        server.registerMBean(listener2, listenerName2);
        ObjectName delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        server.addNotificationListener(delegateName, listenerName1, null, (Object)"handback1");
        server.addNotificationListener(delegateName, listenerName2, null, (Object)"handback2");
        server.addNotificationListener(delegateName, listenerName2, null, (Object)"handback3");
        server.removeNotificationListener(delegateName, listenerName2);
        server.registerMBean(new Test(), new ObjectName(":foo=bar"));
        MBeanServerTEST.assertTrue((String)"Listener1 should get a notification", (listener1.count == 1L ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((String)"Source should be the delegate", (boolean)listener1.source.equals(delegateName));
        MBeanServerTEST.assertTrue((String)"Listener1 should get handback1", (boolean)listener1.handback.equals("handback1"));
        MBeanServerTEST.assertTrue((String)"Listener2 should have no notiifcation", (listener2.count == 0L ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((String)"Listener2 should have no notiifcation for handback2", (listener2.count1 == 0L ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((String)"Listener2 should have no notiifcation for handback3", (listener2.count2 == 0L ? 1 : 0) != 0);
    }

    public synchronized void testMBeanRemoveTriplet() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        MBeanListener listener1 = new MBeanListener();
        ObjectName listenerName1 = new ObjectName("test:type=listener1");
        server.registerMBean(listener1, listenerName1);
        MBeanListener listener2 = new MBeanListener("handback2", "handback3");
        ObjectName listenerName2 = new ObjectName("test:type=listener2");
        server.registerMBean(listener2, listenerName2);
        ObjectName delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        server.addNotificationListener(delegateName, listenerName1, null, (Object)"handback1");
        server.addNotificationListener(delegateName, listenerName2, null, (Object)"handback2");
        server.addNotificationListener(delegateName, listenerName2, null, (Object)"handback3");
        server.removeNotificationListener(delegateName, listenerName2, null, (Object)"handback3");
        server.registerMBean(new Test(), new ObjectName(":foo=bar"));
        MBeanServerTEST.assertTrue((String)"Listener1 should get a notification", (listener1.count == 1L ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((String)"Source should be the delegate", (boolean)listener1.source.equals(delegateName));
        MBeanServerTEST.assertTrue((String)"Listener1 should get handback1", (boolean)listener1.handback.equals("handback1"));
        MBeanServerTEST.assertTrue((String)"Listener2 should get a notification", (listener2.count1 == 1L ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((String)"Source should be the delegate", (boolean)listener2.source1.equals(delegateName));
        MBeanServerTEST.assertTrue((String)"Listener2 should get handback2", (boolean)listener2.handback1.equals("handback2"));
        MBeanServerTEST.assertTrue((String)"Listener2 should have no notiifcation for handback3", (listener2.count2 == 0L ? 1 : 0) != 0);
    }

    public synchronized void testMBeanRedeployNotification() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        MBeanListener listener = new MBeanListener();
        ObjectName listenerName = new ObjectName("test:type=listener");
        server.registerMBean(listener, listenerName);
        ObjectName broadcasterName = new ObjectName("test:type=Broadcaster");
        server.registerMBean(new Broadcaster(), broadcasterName);
        server.addNotificationListener(broadcasterName, listenerName, null, (Object)"handback1");
        server.removeNotificationListener(broadcasterName, listenerName, null, (Object)"handback1");
        server.unregisterMBean(broadcasterName);
        Broadcaster broadcaster = new Broadcaster();
        server.registerMBean(broadcaster, broadcasterName);
        server.addNotificationListener(broadcasterName, listenerName, null, (Object)"handback2");
        broadcaster.doSomething();
        MBeanServerTEST.assertTrue((String)"Listener should get a notification", (listener.count == 1L ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((String)"Source should be the broadcaster", (boolean)listener.source.equals(broadcasterName));
        MBeanServerTEST.assertTrue((String)"Listener should get handback2", (boolean)listener.handback.equals("handback2"));
    }

    public synchronized void testMBeanRemoveBroadcaster() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        MBeanListener listener1 = new MBeanListener();
        ObjectName listenerName1 = new ObjectName("test:type=listener1");
        server.registerMBean(listener1, listenerName1);
        ObjectName broadcasterName = new ObjectName("test:type=broadcaster");
        Broadcaster broadcaster = new Broadcaster();
        server.registerMBean(broadcaster, broadcasterName);
        server.addNotificationListener(broadcasterName, listenerName1, null, null);
        broadcaster.doSomething();
        MBeanServerTEST.assertEquals((long)1L, (long)listener1.count);
        MBeanServerTEST.assertEquals((Object)broadcasterName, (Object)listener1.source);
        server.unregisterMBean(broadcasterName);
        broadcaster.doSomething();
        try {
            MBeanServerTEST.assertEquals((long)1L, (long)listener1.count);
        }
        catch (AssertionFailedError e) {
            MBeanServerTEST.fail((String)"FAILS IN RI: Removing a notification broadcaster does not remove the listeners registered against the object name.");
        }
    }

    public synchronized void testAddMBeanListenerToTwoBroadcasters() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        MBeanListener listener1 = new MBeanListener();
        ObjectName listenerName1 = new ObjectName("test:type=listener1");
        server.registerMBean(listener1, listenerName1);
        ObjectName broadcasterName = new ObjectName("test:type=broadcaster");
        Broadcaster broadcaster = new Broadcaster();
        server.registerMBean(broadcaster, broadcasterName);
        server.addNotificationListener(broadcasterName, listenerName1, null, null);
        ObjectName delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        server.addNotificationListener(delegateName, listenerName1, null, null);
        broadcaster.doSomething();
        MBeanServerTEST.assertEquals((long)1L, (long)listener1.count);
        MBeanServerTEST.assertEquals((Object)broadcasterName, (Object)listener1.source);
        try {
            server.registerMBean(new Test(), new ObjectName("Test:foo=bar"));
            MBeanServerTEST.assertEquals((long)2L, (long)listener1.count);
            MBeanServerTEST.assertEquals((Object)delegateName, (Object)listener1.source);
            server.unregisterMBean(broadcasterName);
            MBeanServerTEST.assertEquals((long)3L, (long)listener1.count);
            MBeanServerTEST.assertEquals((Object)delegateName, (Object)listener1.source);
            server.unregisterMBean(new ObjectName("Test:foo=bar"));
            MBeanServerTEST.assertEquals((long)4L, (long)listener1.count);
            MBeanServerTEST.assertEquals((Object)delegateName, (Object)listener1.source);
        }
        catch (AssertionFailedError e) {
            MBeanServerTEST.fail((String)"FAILS IN RI: Listener registered with ObjectName in MBeanServer reports the wrong source for multiple broadcaster.");
        }
    }

    public synchronized void testAddMBeanListenerToTwoBroadcastersRemoveOne() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        MBeanListener listener1 = new MBeanListener();
        ObjectName listenerName1 = new ObjectName("test:type=listener1");
        server.registerMBean(listener1, listenerName1);
        ObjectName broadcasterName = new ObjectName("test:type=broadcaster");
        Broadcaster broadcaster = new Broadcaster();
        server.registerMBean(broadcaster, broadcasterName);
        server.addNotificationListener(broadcasterName, listenerName1, null, null);
        ObjectName delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        server.addNotificationListener(delegateName, listenerName1, null, null);
        server.removeNotificationListener(broadcasterName, listener1);
        broadcaster.doSomething();
        MBeanServerTEST.assertEquals((long)0L, (long)listener1.count);
        server.registerMBean(new Test(), new ObjectName("Test:foo=bar"));
        MBeanServerTEST.assertEquals((long)1L, (long)listener1.count);
        try {
            MBeanServerTEST.assertEquals((Object)delegateName, (Object)listener1.source);
        }
        catch (AssertionFailedError e) {
            MBeanServerTEST.fail((String)"FAILS IN RI: Listener registered with ObjectName in MBeanServer reports the wrong source for multiple broadcaster, even when the broadcaster it reports has been removed.");
        }
    }

    public void testGetDomains() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        MBeanServerTEST.assertTrue((String)"Only one domain at the start", (server.getDomains().length == 1 ? 1 : 0) != 0);
        MBeanServerTEST.assertEquals((String)server.getDomains()[0], (String)"JMImplementation");
        server.registerMBean(new Test(), new ObjectName("Domain1:test=test1"));
        server.registerMBean(new Test(), new ObjectName("Domain1:test=test2"));
        server.registerMBean(new Test(), new ObjectName("Domain2:test=test1"));
        server.registerMBean(new Test(), new ObjectName("Domain3:test=test1"));
        MBeanServerTEST.assertTrue((String)"Now four domains", (server.getDomains().length == 4 ? 1 : 0) != 0);
        List<String> domains = Arrays.asList(server.getDomains());
        MBeanServerTEST.assertTrue((String)"server has JMImplementation", (boolean)domains.contains("JMImplementation"));
        MBeanServerTEST.assertTrue((String)"server has Domain1", (boolean)domains.contains("Domain1"));
        MBeanServerTEST.assertTrue((String)"server has Domain2", (boolean)domains.contains("Domain2"));
        MBeanServerTEST.assertTrue((String)"server has Domain3", (boolean)domains.contains("Domain3"));
        server.unregisterMBean(new ObjectName("Domain3:test=test1"));
        MBeanServerTEST.assertTrue((String)"Now three domains", (server.getDomains().length == 3 ? 1 : 0) != 0);
        domains = Arrays.asList(server.getDomains());
        MBeanServerTEST.assertTrue((String)"server has JMImplementation", (boolean)domains.contains("JMImplementation"));
        MBeanServerTEST.assertTrue((String)"server has Domain1", (boolean)domains.contains("Domain1"));
        MBeanServerTEST.assertTrue((String)"server has Domain2", (boolean)domains.contains("Domain2"));
        MBeanServerTEST.assertTrue((String)"server no longer has Domain3", (!domains.contains("Domain3") ? 1 : 0) != 0);
        server.unregisterMBean(new ObjectName("Domain1:test=test1"));
        MBeanServerTEST.assertTrue((String)"Still three domains", (server.getDomains().length == 3 ? 1 : 0) != 0);
        domains = Arrays.asList(server.getDomains());
        MBeanServerTEST.assertTrue((String)"server has JMImplementation", (boolean)domains.contains("JMImplementation"));
        MBeanServerTEST.assertTrue((String)"server still has Domain1", (boolean)domains.contains("Domain1"));
        MBeanServerTEST.assertTrue((String)"server has Domain2", (boolean)domains.contains("Domain2"));
        MBeanServerTEST.assertTrue((String)"server no longer has Domain3", (!domains.contains("Domain3") ? 1 : 0) != 0);
    }

    public void testIsInstanceOf() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName baseName = new ObjectName("MBeanServerTEST:type=testIsInstanceOf,name=Base");
        ObjectName derivedName = new ObjectName("MBeanServerTEST:type=testIsInstanceOf,name=Derived");
        ObjectName unrelatedName = new ObjectName("MBeanServerTEST:type=testIsInstanceOf,name=Unrelated");
        server.registerMBean(new Base(), baseName);
        server.registerMBean(new Derived(), derivedName);
        server.registerMBean(new Unrelated(), unrelatedName);
        MBeanServerTEST.assertTrue((String)"Base is an instance Object", (boolean)server.isInstanceOf(baseName, (class$java$lang$Object == null ? (class$java$lang$Object = MBeanServerTEST.class$("java.lang.Object")) : class$java$lang$Object).getName()));
        MBeanServerTEST.assertTrue((String)"Base is an instance BaseMBean", (boolean)server.isInstanceOf(baseName, (class$test$compliance$server$support$BaseMBean == null ? (class$test$compliance$server$support$BaseMBean = MBeanServerTEST.class$("test.compliance.server.support.BaseMBean")) : class$test$compliance$server$support$BaseMBean).getName()));
        MBeanServerTEST.assertTrue((String)"Base is an instance Base", (boolean)server.isInstanceOf(baseName, (class$test$compliance$server$support$Base == null ? (class$test$compliance$server$support$Base = MBeanServerTEST.class$("test.compliance.server.support.Base")) : class$test$compliance$server$support$Base).getName()));
        MBeanServerTEST.assertTrue((String)"Derived is an instance Object", (boolean)server.isInstanceOf(derivedName, (class$java$lang$Object == null ? (class$java$lang$Object = MBeanServerTEST.class$("java.lang.Object")) : class$java$lang$Object).getName()));
        MBeanServerTEST.assertTrue((String)"Derived is an instance BaseMBean", (boolean)server.isInstanceOf(derivedName, (class$test$compliance$server$support$BaseMBean == null ? (class$test$compliance$server$support$BaseMBean = MBeanServerTEST.class$("test.compliance.server.support.BaseMBean")) : class$test$compliance$server$support$BaseMBean).getName()));
        MBeanServerTEST.assertTrue((String)"Derived is an instance Base", (boolean)server.isInstanceOf(derivedName, (class$test$compliance$server$support$Base == null ? (class$test$compliance$server$support$Base = MBeanServerTEST.class$("test.compliance.server.support.Base")) : class$test$compliance$server$support$Base).getName()));
        MBeanServerTEST.assertTrue((String)"Derived is an instance Derived", (boolean)server.isInstanceOf(derivedName, (class$test$compliance$server$support$Derived == null ? (class$test$compliance$server$support$Derived = MBeanServerTEST.class$("test.compliance.server.support.Derived")) : class$test$compliance$server$support$Derived).getName()));
        MBeanServerTEST.assertTrue((String)"Unrelated is an instance Object", (boolean)server.isInstanceOf(unrelatedName, (class$java$lang$Object == null ? (class$java$lang$Object = MBeanServerTEST.class$("java.lang.Object")) : class$java$lang$Object).getName()));
        MBeanServerTEST.assertTrue((String)"Unrelated is an instance UnrelatedMBean", (boolean)server.isInstanceOf(unrelatedName, (class$test$compliance$server$support$UnrelatedMBean == null ? (class$test$compliance$server$support$UnrelatedMBean = MBeanServerTEST.class$("test.compliance.server.support.UnrelatedMBean")) : class$test$compliance$server$support$UnrelatedMBean).getName()));
        MBeanServerTEST.assertTrue((String)"Unrelated is an instance Unrelated", (boolean)server.isInstanceOf(unrelatedName, (class$test$compliance$server$support$Unrelated == null ? (class$test$compliance$server$support$Unrelated = MBeanServerTEST.class$("test.compliance.server.support.Unrelated")) : class$test$compliance$server$support$Unrelated).getName()));
        MBeanServerTEST.assertTrue((String)"Base is an not instance Derived", (!server.isInstanceOf(baseName, (class$test$compliance$server$support$Derived == null ? (class$test$compliance$server$support$Derived = MBeanServerTEST.class$("test.compliance.server.support.Derived")) : class$test$compliance$server$support$Derived).getName()) ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((String)"Base is an not instance UnrelatedMBean", (!server.isInstanceOf(baseName, (class$test$compliance$server$support$UnrelatedMBean == null ? (class$test$compliance$server$support$UnrelatedMBean = MBeanServerTEST.class$("test.compliance.server.support.UnrelatedMBean")) : class$test$compliance$server$support$UnrelatedMBean).getName()) ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((String)"Base is an not instance Unrelated", (!server.isInstanceOf(baseName, (class$test$compliance$server$support$Unrelated == null ? (class$test$compliance$server$support$Unrelated = MBeanServerTEST.class$("test.compliance.server.support.Unrelated")) : class$test$compliance$server$support$Unrelated).getName()) ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((String)"Derived is an not instance UnrelatedMBean", (!server.isInstanceOf(derivedName, (class$test$compliance$server$support$UnrelatedMBean == null ? (class$test$compliance$server$support$UnrelatedMBean = MBeanServerTEST.class$("test.compliance.server.support.UnrelatedMBean")) : class$test$compliance$server$support$UnrelatedMBean).getName()) ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((String)"Dervied is an not instance Unrelated", (!server.isInstanceOf(derivedName, (class$test$compliance$server$support$Unrelated == null ? (class$test$compliance$server$support$Unrelated = MBeanServerTEST.class$("test.compliance.server.support.Unrelated")) : class$test$compliance$server$support$Unrelated).getName()) ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((String)"Unrelated is an not instance BaseMBean", (!server.isInstanceOf(unrelatedName, (class$test$compliance$server$support$BaseMBean == null ? (class$test$compliance$server$support$BaseMBean = MBeanServerTEST.class$("test.compliance.server.support.BaseMBean")) : class$test$compliance$server$support$BaseMBean).getName()) ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((String)"Unrelated is an not instance Base", (!server.isInstanceOf(unrelatedName, (class$test$compliance$server$support$Base == null ? (class$test$compliance$server$support$Base = MBeanServerTEST.class$("test.compliance.server.support.Base")) : class$test$compliance$server$support$Base).getName()) ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((String)"Unrelated is an not instance Derived", (!server.isInstanceOf(unrelatedName, (class$test$compliance$server$support$Derived == null ? (class$test$compliance$server$support$Derived = MBeanServerTEST.class$("test.compliance.server.support.Derived")) : class$test$compliance$server$support$Derived).getName()) ? 1 : 0) != 0);
    }

    public void testIsInstanceOfErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName baseName = new ObjectName("MBeanServerTEST:type=testIsInstanceOf,name=Base");
        ObjectName dynamicName = new ObjectName("MBeanServerTEST:type=testIsInstanceOf,name=Dynamic");
        ObjectName doesNotExistName = new ObjectName("MBeanServerTEST:type=testIsInstanceOf,name=DoesNotExist");
        server.registerMBean(new Base(), baseName);
        server.registerMBean(new Dynamic(), dynamicName);
        MBeanServerTEST.assertTrue((String)"Base is not an instance of a class that does not exist", (!server.isInstanceOf(baseName, "does.not.exist") ? 1 : 0) != 0);
        MBeanServerTEST.assertTrue((String)"FAILS IN RI: Not an instance if the getMBeanInfo reports a class name that does not exist", (!server.isInstanceOf(dynamicName, (class$java$lang$Object == null ? (class$java$lang$Object = MBeanServerTEST.class$("java.lang.Object")) : class$java$lang$Object).getName()) ? 1 : 0) != 0);
        boolean caught = false;
        try {
            server.isInstanceOf(doesNotExistName, (class$java$lang$Object == null ? (class$java$lang$Object = MBeanServerTEST.class$("java.lang.Object")) : class$java$lang$Object).getName());
        }
        catch (InstanceNotFoundException e) {
            caught = true;
        }
        MBeanServerTEST.assertTrue((String)"Should get an instance not found for a non-existent mbean", (boolean)caught);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

