/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.relation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.RelationTypeSupport;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import junit.framework.TestCase;

public class RelationTypeSupportTestCase
extends TestCase {
    static /* synthetic */ Class class$javax$management$relation$RelationSupport;

    public RelationTypeSupportTestCase(String s) {
        super(s);
    }

    public void testBasic() {
        RoleInfo roleInfo1 = null;
        RoleInfo roleInfo2 = null;
        RoleInfo[] roleInfos = null;
        RelationTypeSupport support = null;
        try {
            roleInfo1 = new RoleInfo("roleInfo1", (class$javax$management$relation$RelationSupport == null ? (class$javax$management$relation$RelationSupport = RelationTypeSupportTestCase.class$("javax.management.relation.RelationSupport")) : class$javax$management$relation$RelationSupport).getName());
            roleInfo2 = new RoleInfo("roleInfo2", (class$javax$management$relation$RelationSupport == null ? (class$javax$management$relation$RelationSupport = RelationTypeSupportTestCase.class$("javax.management.relation.RelationSupport")) : class$javax$management$relation$RelationSupport).getName());
            roleInfos = new RoleInfo[]{roleInfo1, roleInfo2};
            support = new RelationTypeSupport("name", roleInfos);
        }
        catch (Exception e) {
            RelationTypeSupportTestCase.fail((String)e.toString());
        }
        RelationTypeSupportTestCase.assertEquals((String)"name", (String)support.getRelationTypeName());
        ArrayList result = (ArrayList)support.getRoleInfos();
        RelationTypeSupportTestCase.assertEquals((int)2, (int)result.size());
        try {
            RelationTypeSupportTestCase.assertEquals((String)roleInfo1.toString(), (String)support.getRoleInfo("roleInfo1").toString());
            RelationTypeSupportTestCase.assertEquals((String)roleInfo2.toString(), (String)support.getRoleInfo("roleInfo2").toString());
        }
        catch (Exception e) {
            RelationTypeSupportTestCase.fail((String)e.toString());
        }
        MyRelationTypeSupport mySupport = new MyRelationTypeSupport("myName");
        RelationTypeSupportTestCase.assertEquals((String)"myName", (String)mySupport.getRelationTypeName());
        result = (ArrayList)mySupport.getRoleInfos();
        RelationTypeSupportTestCase.assertEquals((int)0, (int)result.size());
        try {
            mySupport.addRoleInfo(roleInfo1);
            result = (ArrayList)mySupport.getRoleInfos();
            RelationTypeSupportTestCase.assertEquals((int)1, (int)result.size());
        }
        catch (Exception e) {
            RelationTypeSupportTestCase.fail((String)e.toString());
        }
    }

    public void testErrorHandling() {
        RoleInfo roleInfo1 = null;
        RoleInfo roleInfo2 = null;
        RoleInfo[] roleInfos = null;
        RelationTypeSupport support = null;
        boolean caught = false;
        try {
            roleInfo1 = new RoleInfo("roleInfo1", (class$javax$management$relation$RelationSupport == null ? (class$javax$management$relation$RelationSupport = RelationTypeSupportTestCase.class$("javax.management.relation.RelationSupport")) : class$javax$management$relation$RelationSupport).getName());
            roleInfo2 = new RoleInfo("roleInfo2", (class$javax$management$relation$RelationSupport == null ? (class$javax$management$relation$RelationSupport = RelationTypeSupportTestCase.class$("javax.management.relation.RelationSupport")) : class$javax$management$relation$RelationSupport).getName());
            roleInfos = new RoleInfo[]{roleInfo1, roleInfo2};
            support = new RelationTypeSupport(null, roleInfos);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationTypeSupportTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationTypeSupportTestCase.fail((String)"Constructor accepts null relation type name");
        }
        caught = false;
        try {
            support = new RelationTypeSupport("name", null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationTypeSupportTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationTypeSupportTestCase.fail((String)"Constructor accepts null role infos");
        }
        caught = false;
        try {
            support = new RelationTypeSupport("name", new RoleInfo[0]);
        }
        catch (InvalidRelationTypeException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationTypeSupportTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationTypeSupportTestCase.fail((String)"Constructor accepts no role infos");
        }
        caught = false;
        try {
            roleInfo1 = new RoleInfo("roleInfo1", (class$javax$management$relation$RelationSupport == null ? (class$javax$management$relation$RelationSupport = RelationTypeSupportTestCase.class$("javax.management.relation.RelationSupport")) : class$javax$management$relation$RelationSupport).getName());
            roleInfos = new RoleInfo[]{roleInfo1, null};
            support = new RelationTypeSupport("name", roleInfos);
        }
        catch (InvalidRelationTypeException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationTypeSupportTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationTypeSupportTestCase.fail((String)"Constructor accepts null role");
        }
        caught = false;
        try {
            roleInfo1 = new RoleInfo("roleInfo1", (class$javax$management$relation$RelationSupport == null ? (class$javax$management$relation$RelationSupport = RelationTypeSupportTestCase.class$("javax.management.relation.RelationSupport")) : class$javax$management$relation$RelationSupport).getName());
            roleInfos = new RoleInfo[]{roleInfo1};
            support = new RelationTypeSupport("name", roleInfos);
            support.getRoleInfo(null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationTypeSupportTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationTypeSupportTestCase.fail((String)"getRoleInfo allows a null role info name");
        }
        caught = false;
        try {
            roleInfo1 = new RoleInfo("roleInfo1", (class$javax$management$relation$RelationSupport == null ? (class$javax$management$relation$RelationSupport = RelationTypeSupportTestCase.class$("javax.management.relation.RelationSupport")) : class$javax$management$relation$RelationSupport).getName());
            roleInfos = new RoleInfo[]{roleInfo1};
            support = new RelationTypeSupport("name", roleInfos);
            support.getRoleInfo("rubbish");
        }
        catch (RoleInfoNotFoundException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationTypeSupportTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationTypeSupportTestCase.fail((String)"getRoleInfo returns a not existent role info");
        }
        MyRelationTypeSupport mySupport = new MyRelationTypeSupport("myName");
        caught = false;
        try {
            mySupport.addRoleInfo(null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationTypeSupportTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationTypeSupportTestCase.fail((String)"addRoleInfo accepts null");
        }
        caught = false;
        try {
            mySupport.addRoleInfo(roleInfo1);
            mySupport.addRoleInfo(roleInfo1);
        }
        catch (InvalidRelationTypeException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationTypeSupportTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationTypeSupportTestCase.fail((String)"addRoleInfo accepts duplicates role infos");
        }
    }

    public void testSerialization() {
        RoleInfo roleInfo1 = null;
        RoleInfo roleInfo2 = null;
        RoleInfo[] roleInfos = null;
        RelationTypeSupport support = null;
        try {
            roleInfo1 = new RoleInfo("roleInfo1", (class$javax$management$relation$RelationSupport == null ? (class$javax$management$relation$RelationSupport = RelationTypeSupportTestCase.class$("javax.management.relation.RelationSupport")) : class$javax$management$relation$RelationSupport).getName());
            roleInfo2 = new RoleInfo("roleInfo2", (class$javax$management$relation$RelationSupport == null ? (class$javax$management$relation$RelationSupport = RelationTypeSupportTestCase.class$("javax.management.relation.RelationSupport")) : class$javax$management$relation$RelationSupport).getName());
            roleInfos = new RoleInfo[]{roleInfo1, roleInfo2};
            support = new RelationTypeSupport("name", roleInfos);
        }
        catch (Exception e) {
            RelationTypeSupportTestCase.fail((String)e.toString());
        }
        RelationTypeSupport support2 = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(support);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            support2 = (RelationTypeSupport)ois.readObject();
        }
        catch (IOException ioe) {
            RelationTypeSupportTestCase.fail((String)ioe.toString());
        }
        catch (ClassNotFoundException cnfe) {
            RelationTypeSupportTestCase.fail((String)cnfe.toString());
        }
        RelationTypeSupportTestCase.assertEquals((String)"name", (String)support2.getRelationTypeName());
        ArrayList result = (ArrayList)support2.getRoleInfos();
        RelationTypeSupportTestCase.assertEquals((int)2, (int)result.size());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MyRelationTypeSupport
    extends RelationTypeSupport {
        public MyRelationTypeSupport(String relationTypeName) {
            super(relationTypeName);
        }

        public void addRoleInfo(RoleInfo roleInfo) throws IllegalArgumentException, InvalidRelationTypeException {
            super.addRoleInfo(roleInfo);
        }
    }
}

