/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.relation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.InvalidRelationIdException;
import javax.management.relation.InvalidRelationServiceException;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationNotification;
import javax.management.relation.RelationService;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupport;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.RelationTypeSupport;
import javax.management.relation.Role;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;
import javax.management.relation.RoleUnresolved;
import javax.management.relation.RoleUnresolvedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import test.compliance.relation.support.Trivial;

public class RelationServiceTestCase
extends TestCase {
    HashMap services = new HashMap();
    RoleList rolesA;
    HashMap roleInfosA = new HashMap();
    Role roleB1;
    Role roleB2;
    RoleList rolesB;
    HashMap roleInfosB = new HashMap();
    Role roleC1;
    Role roleC2;
    RoleList rolesC;
    HashMap roleInfosC = new HashMap();
    Role roleCX1;
    Role roleCX2;
    RoleList rolesCX;
    HashMap roleInfosCX = new HashMap();
    Role roleCZ2;
    RoleList rolesCZ;
    HashMap roleInfosCZ = new HashMap();
    Role roleCZZ;
    RoleList rolesCZZ;
    HashMap roleInfosCZZ = new HashMap();
    Role roleCZZZ;
    RoleList rolesCZZZ;
    HashMap roleInfosCZZZ = new HashMap();
    static /* synthetic */ Class class$test$compliance$relation$support$Trivial;

    public RelationServiceTestCase(String s) {
        super(s);
    }

    public void testConstructor() throws Exception {
        RelationService rs = null;
        rs = new RelationService(true);
        RelationServiceTestCase.assertEquals((boolean)true, (boolean)rs.getPurgeFlag());
        rs = new RelationService(false);
        RelationServiceTestCase.assertEquals((boolean)false, (boolean)rs.getPurgeFlag());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddRelation() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeB(service);
            this.createRolesB(server);
            RelationSupport support = null;
            ObjectName rsupp = null;
            String result = null;
            Listener listener = new Listener("jmx.relation.creation.mbean");
            RelationService rs = (RelationService)this.services.get(service);
            server.addNotificationListener(service, listener, null, null);
            support = new RelationSupport("id", service, server, "relationTypeB", this.rolesB);
            rsupp = new ObjectName("test:add=relation");
            server.registerMBean(support, rsupp);
            rs.addRelation(rsupp);
            result = rs.isRelation(rsupp);
            RelationServiceTestCase.assertEquals((String)"id", (String)result);
            listener.check(1);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddRelationErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", null);
            RelationService rs = (RelationService)this.services.get(service);
            this.createRelationTypeB(service);
            this.createRolesB(server);
            RelationSupport support = null;
            ObjectName name = null;
            support = new RelationSupport("id", service, server, "relationTypeB", this.rolesB);
            name = new ObjectName("test:type=relation");
            server.registerMBean(support, name);
            boolean caught = false;
            try {
                rs.addRelation(null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"addRelation allows null relation");
            }
            caught = false;
            try {
                rs.addRelation(name);
            }
            catch (RelationServiceNotRegisteredException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"addRelation allowed when not registered");
            }
            ObjectName badRelation = null;
            server.registerMBean(rs, service);
            badRelation = new ObjectName("test:type=bad");
            server.registerMBean(new Trivial(), badRelation);
            caught = false;
            try {
                rs.addRelation(badRelation);
            }
            catch (NoSuchMethodException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"addRelation allowed when not a relation");
            }
            caught = false;
            try {
                rs.addRelation(name);
                rs.addRelation(name);
            }
            catch (InvalidRelationIdException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"addRelation allows duplicate relation ids");
            }
            rs.removeRelation("id");
            server.unregisterMBean(name);
            caught = false;
            try {
                rs.addRelation(name);
            }
            catch (InstanceNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"addRelation allows unregistered relation");
            }
            ObjectName service2 = this.createRelationService("test:type=service2", null);
            RelationService rs2 = (RelationService)this.services.get(service);
            this.createRelationTypeB(service2);
            Object support2 = null;
            ObjectName name2 = null;
            support = new RelationSupport("id", service2, server, "relationTypeB", this.rolesB);
            name2 = new ObjectName("test:type=relation2");
            server.registerMBean(support, name2);
            caught = false;
            try {
                rs.addRelation(name2);
            }
            catch (InvalidRelationServiceException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"addRelation allows registration in the wrong relation service");
            }
            support = new RelationSupport("id", service, server, "relationTypeX", this.rolesB);
            name = new ObjectName("test:type=relationX");
            server.registerMBean(support, name);
            caught = false;
            try {
                rs.addRelation(name);
            }
            catch (RelationTypeNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"addRelation allows registration with invalid relation type");
            }
            this.createRelationTypeC(service);
            this.createRolesC(server);
            this.createRolesCZ(server);
            support = new RelationSupport("idC", service, server, "relationTypeB", this.rolesC);
            name = new ObjectName("test:type=relationC");
            server.registerMBean(support, name);
            caught = false;
            try {
                rs.addRelation(name);
            }
            catch (RoleNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"addRelation allows registration with invalid role name");
            }
            support = new RelationSupport("idCZ", service, server, "relationTypeC", this.rolesCZ);
            name = new ObjectName("test:type=relationCZ");
            server.registerMBean(support, name);
            caught = false;
            try {
                rs.addRelation(name);
            }
            catch (InvalidRoleValueException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"addRelation allows registration with invalid role value");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testAddRelationType() throws Exception {
        RoleInfo roleInfo1 = null;
        RoleInfo roleInfo2 = null;
        RoleInfo[] roleInfos = null;
        RelationService rs = null;
        ArrayList result = null;
        RoleInfo result1 = null;
        RoleInfo result2 = null;
        roleInfo1 = new RoleInfo("roleInfo1", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
        roleInfo2 = new RoleInfo("roleInfo2", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
        roleInfos = new RoleInfo[]{roleInfo1, roleInfo2};
        RelationTypeSupport rtsupp = new RelationTypeSupport("RelationTypeName", roleInfos);
        rs = new RelationService(true);
        rs.addRelationType(rtsupp);
        result = (ArrayList)rs.getRoleInfos("RelationTypeName");
        result1 = rs.getRoleInfo("RelationTypeName", "roleInfo1");
        result2 = rs.getRoleInfo("RelationTypeName", "roleInfo2");
        RelationServiceTestCase.assertEquals((int)2, (int)result.size());
        RelationServiceTestCase.assertEquals((String)roleInfo1.toString(), (String)result1.toString());
        RelationServiceTestCase.assertEquals((String)roleInfo2.toString(), (String)result2.toString());
    }

    public void testAddRelationTypeErrors() throws Exception {
        RoleInfo roleInfo1 = null;
        RoleInfo roleInfo2 = null;
        RoleInfo[] roleInfos = null;
        RelationService rs = null;
        RelationTypeSupport rtsupp = null;
        boolean caught = false;
        try {
            roleInfo1 = new RoleInfo("roleInfo1", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
            roleInfo2 = new RoleInfo("roleInfo2", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
            roleInfos = new RoleInfo[]{roleInfo1, roleInfo2};
            rs = new RelationService(true);
            rs.addRelationType(null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"addRelationType allows null relation type");
        }
        caught = false;
        try {
            rtsupp = new RelationTypeSupport("RelationTypeName", roleInfos);
            rs.addRelationType(rtsupp);
            rs.addRelationType(rtsupp);
        }
        catch (InvalidRelationTypeException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"addRelationType allows duplication relation types");
        }
        caught = false;
        try {
            roleInfos[1] = roleInfos[0];
            rtsupp = new RelationTypeSupport("RelationTypeName1", roleInfos);
            rs.addRelationType(rtsupp);
        }
        catch (InvalidRelationTypeException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"addRelationType allows duplicate role names");
        }
        caught = false;
        try {
            roleInfos[1] = null;
            rtsupp = new RelationTypeSupport("RelationTypeName1", roleInfos);
            rs.addRelationType(rtsupp);
        }
        catch (InvalidRelationTypeException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"addRelationType allows null role info");
        }
        caught = false;
        try {
            rtsupp = new RelationTypeSupport("RelationTypeName1", new RoleInfo[0]);
            rs.addRelationType(rtsupp);
        }
        catch (InvalidRelationTypeException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"addRelationType allows no role info");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCheckRoleReadingExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeB(service);
            this.createRolesB(server);
            RelationSupport support = null;
            Integer readB1 = null;
            Integer readB2 = null;
            RelationService rs = (RelationService)this.services.get(service);
            support = new RelationSupport("id", service, server, "relationTypeB", this.rolesB);
            this.addRelation(server, service, support, "test:type=support");
            readB1 = rs.checkRoleReading("roleB1", "relationTypeB");
            readB2 = rs.checkRoleReading("roleB2", "relationTypeB");
            RelationServiceTestCase.assertEquals((int)0, (int)readB1);
            RelationServiceTestCase.assertEquals((int)2, (int)readB2);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testCheckRoleReadingErrors() throws Exception {
        ObjectName service = this.createRelationService("test:type=service", null);
        RelationService rs = (RelationService)this.services.get(service);
        this.createRelationTypeB(service);
        this.createRolesB(null);
        boolean caught = false;
        try {
            rs.checkRoleReading(null, "relationTypeB");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"checkRoleReading allows null role name");
        }
        caught = false;
        try {
            rs.checkRoleReading("roleB1", null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"checkRoleReading allows null relation name");
        }
        caught = false;
        try {
            rs.checkRoleReading("roleB1", "rubbish");
        }
        catch (RelationTypeNotFoundException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"checkRoleReading allows invalid relation type name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCheckRoleWritingExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeB(service);
            this.createRolesB(server);
            RelationSupport support = null;
            Integer writeB1normal = null;
            Integer writeB2normal = null;
            Integer writeB1init = null;
            Integer writeB2init = null;
            RelationService rs = (RelationService)this.services.get(service);
            support = new RelationSupport("id", service, server, "relationTypeB", this.rolesB);
            this.addRelation(server, service, support, "test:type=support");
            writeB1normal = rs.checkRoleWriting(this.roleB1, "relationTypeB", new Boolean(false));
            writeB2normal = rs.checkRoleWriting(this.roleB2, "relationTypeB", new Boolean(false));
            writeB1init = rs.checkRoleWriting(this.roleB1, "relationTypeB", new Boolean(true));
            writeB2init = rs.checkRoleWriting(this.roleB2, "relationTypeB", new Boolean(true));
            RelationServiceTestCase.assertEquals((int)3, (int)writeB1normal);
            RelationServiceTestCase.assertEquals((int)0, (int)writeB2normal);
            RelationServiceTestCase.assertEquals((int)0, (int)writeB1init);
            RelationServiceTestCase.assertEquals((int)0, (int)writeB2init);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testCheckRoleWritingErrors() throws Exception {
        ObjectName service = this.createRelationService("test:type=service", null);
        RelationService rs = (RelationService)this.services.get(service);
        this.createRelationTypeB(service);
        this.createRolesB(null);
        boolean caught = false;
        try {
            rs.checkRoleWriting(null, "relationTypeB", new Boolean(true));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"checkRoleWriting allows null role name");
        }
        caught = false;
        try {
            rs.checkRoleWriting(this.roleB1, null, new Boolean(true));
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"checkRoleWriting allows null relation name");
        }
        caught = false;
        try {
            rs.checkRoleWriting(this.roleB1, "relationTypeB", null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"checkRoleWriting allows null init flag");
        }
        caught = false;
        try {
            rs.checkRoleWriting(this.roleB1, "rubbish", new Boolean(true));
        }
        catch (RelationTypeNotFoundException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"checkRoleWriting allows invalid relation type name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateRelation() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeB(service);
            this.createRolesB(server);
            Object support = null;
            Listener listener = new Listener("jmx.relation.creation.basic");
            RelationService rs = (RelationService)this.services.get(service);
            server.addNotificationListener(service, listener, null, null);
            rs.createRelation("id", "relationTypeB", this.rolesB);
            boolean result = rs.hasRelation("id");
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)result);
            listener.check(1);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateRelationErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            RoleList roleList;
            ObjectName service = this.createRelationService("test:type=service", server);
            RelationService rs = (RelationService)this.services.get(service);
            this.createRelationTypeB(service);
            this.createRolesB(server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            this.createRolesCZ(server);
            this.createRolesCZZ(server);
            boolean caught = false;
            try {
                rs.createRelation(null, "relationTypeC", this.rolesC);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"createRelation allows null relation id");
            }
            caught = false;
            try {
                rs.createRelation("relationId", null, this.rolesC);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"createRelation allows null relation type name");
            }
            caught = false;
            try {
                rs.createRelation("relationId", "rubbish", this.rolesC);
            }
            catch (RelationTypeNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"createRelation allows invalid relation type name");
            }
            caught = false;
            try {
                roleList = new RoleList();
                roleList.add(this.roleC1);
                roleList.add(this.roleB1);
                rs.createRelation("relationId", "relationTypeC", roleList);
            }
            catch (RoleNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"createRelation allows invalid role name");
            }
            caught = false;
            try {
                roleList = new RoleList();
                roleList.add(this.roleC1);
                roleList.add(this.roleCZ2);
                rs.createRelation("relationId", "relationTypeC", roleList);
            }
            catch (InvalidRoleValueException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"createRelation allows a role below the minimum");
            }
            caught = false;
            try {
                roleList = new RoleList();
                roleList.add(this.roleC1);
                roleList.add(this.roleCZZ);
                rs.createRelation("relationId", "relationTypeC", roleList);
            }
            catch (InvalidRoleValueException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"createRelation allows a role above the maximum");
            }
            caught = false;
            try {
                roleList = new RoleList();
                roleList.add(this.roleC1);
                roleList.add(this.roleCZZZ);
                rs.createRelation("relationId", "relationTypeC", roleList);
            }
            catch (InvalidRoleValueException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"createRelation allows a role with unregistered beans");
            }
            caught = false;
            try {
                rs.createRelation("relationId", "relationTypeC", this.rolesC);
                rs.createRelation("relationId", "relationTypeC", this.rolesC);
            }
            catch (InvalidRelationIdException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"createRelation allows duplicate relation id");
            }
            server.unregisterMBean(service);
            caught = false;
            try {
                rs.createRelation("relationId2", "relationTypeC", this.rolesC);
            }
            catch (RelationServiceNotRegisteredException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"FAILS IN RI: createRelation allowed when not registered");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testCreationRelationType() throws Exception {
        RoleInfo roleInfo1 = null;
        RoleInfo roleInfo2 = null;
        RoleInfo[] roleInfos = null;
        RelationService rs = null;
        ArrayList result = null;
        RoleInfo result1 = null;
        RoleInfo result2 = null;
        roleInfo1 = new RoleInfo("roleInfo1", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
        roleInfo2 = new RoleInfo("roleInfo2", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
        roleInfos = new RoleInfo[]{roleInfo1, roleInfo2};
        rs = new RelationService(true);
        rs.createRelationType("RelationTypeName", roleInfos);
        result = (ArrayList)rs.getRoleInfos("RelationTypeName");
        result1 = rs.getRoleInfo("RelationTypeName", "roleInfo1");
        result2 = rs.getRoleInfo("RelationTypeName", "roleInfo2");
        RelationServiceTestCase.assertEquals((int)2, (int)result.size());
        RelationServiceTestCase.assertEquals((String)roleInfo1.toString(), (String)result1.toString());
        RelationServiceTestCase.assertEquals((String)roleInfo2.toString(), (String)result2.toString());
    }

    public void testCreateRelationTypeErrors() throws Exception {
        RoleInfo roleInfo1 = null;
        RoleInfo roleInfo2 = null;
        RoleInfo[] roleInfos = null;
        RelationService rs = null;
        boolean caught = false;
        try {
            roleInfo1 = new RoleInfo("roleInfo1", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
            roleInfo2 = new RoleInfo("roleInfo2", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
            roleInfos = new RoleInfo[]{roleInfo1, roleInfo2};
            rs = new RelationService(true);
            rs.createRelationType(null, roleInfos);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"createRelationType allows null relation type name");
        }
        caught = false;
        try {
            rs.createRelationType("relationTypeName", null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"createRelationType allows null role infos");
        }
        caught = false;
        try {
            rs.createRelationType("relationTypeName", roleInfos);
            rs.createRelationType("relationTypeName", roleInfos);
        }
        catch (InvalidRelationTypeException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"createRelationType allows duplicate relation type names");
        }
        caught = false;
        try {
            roleInfos[1] = roleInfos[0];
            rs.createRelationType("relationTypeName1", roleInfos);
        }
        catch (InvalidRelationTypeException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"createRelationType allows duplicate role names");
        }
        caught = false;
        try {
            roleInfos[1] = null;
            rs.createRelationType("relationTypeName1", roleInfos);
        }
        catch (InvalidRelationTypeException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"createRelationType allows null role info");
        }
        caught = false;
        try {
            rs.createRelationType("relationTypeName1", new RoleInfo[0]);
        }
        catch (InvalidRelationTypeException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"createRelationType allows no role info");
        }
    }

    public void testGetRoleInfoErrors() throws Exception {
        RoleInfo roleInfo1 = null;
        RoleInfo roleInfo2 = null;
        RoleInfo[] roleInfos = null;
        RelationService rs = null;
        Object result = null;
        Object result1 = null;
        roleInfo1 = new RoleInfo("roleInfo1", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
        roleInfo2 = new RoleInfo("roleInfo2", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
        roleInfos = new RoleInfo[]{roleInfo1, roleInfo2};
        rs = new RelationService(true);
        rs.createRelationType("RelationTypeName", roleInfos);
        boolean caught = false;
        try {
            rs.getRoleInfo(null, "roleInfo1");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"getRoleInfo allows null relation type name");
        }
        caught = false;
        try {
            rs.getRoleInfo("RelationTypeName", null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"getRoleInfo allows null role info name");
        }
        caught = false;
        try {
            rs.getRoleInfo("RelationTypeNameX", "roleInfo1");
        }
        catch (RelationTypeNotFoundException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"getRoleInfo allows non-existent relation type name");
        }
        caught = false;
        try {
            rs.getRoleInfo("RelationTypeName", "roleInfoX");
        }
        catch (RoleInfoNotFoundException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"getRoleInfo allows non-existent role info name");
        }
    }

    public void testGetRoleInfosErrors() throws Exception {
        RoleInfo roleInfo1 = null;
        RoleInfo roleInfo2 = null;
        RoleInfo[] roleInfos = null;
        RelationService rs = null;
        Object result = null;
        Object result1 = null;
        roleInfo1 = new RoleInfo("roleInfo1", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
        roleInfo2 = new RoleInfo("roleInfo2", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
        roleInfos = new RoleInfo[]{roleInfo1, roleInfo2};
        rs = new RelationService(true);
        rs.createRelationType("RelationTypeName", roleInfos);
        boolean caught = false;
        try {
            rs.getRoleInfos(null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"getRoleInfos allows null relation type name");
        }
        caught = false;
        try {
            rs.getRoleInfos("RelationTypeNameX");
        }
        catch (RelationTypeNotFoundException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"getRoleInfos allows non-existent relation type name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindAssociatedMBeansExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            this.createRelationTypeCX(service);
            this.createRolesCX(server);
            Map<ObjectName, List<String>> result1 = null;
            Map<ObjectName, List<String>> result2 = null;
            Map<ObjectName, List<String>> result3 = null;
            Map<ObjectName, List<String>> result4 = null;
            Map<ObjectName, List<String>> result5 = null;
            Map<ObjectName, List<String>> result6 = null;
            Map<ObjectName, List<String>> result7 = null;
            Map<ObjectName, List<String>> result8 = null;
            Map<ObjectName, List<String>> result9 = null;
            Map<ObjectName, List<String>> result10 = null;
            Map<ObjectName, List<String>> result11 = null;
            Map<ObjectName, List<String>> result12 = null;
            Map<ObjectName, List<String>> result13 = null;
            Map<ObjectName, List<String>> result14 = null;
            Map<ObjectName, List<String>> result15 = null;
            Map<ObjectName, List<String>> result16 = null;
            RelationSupport supportCX = new RelationSupport("idcx", service, server, "relationTypeCX", this.rolesCX);
            RelationSupport supportC = new RelationSupport("idc", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, supportCX, "test:type=supportCX");
            this.addRelation(server, service, supportC, "test:type=supportC");
            RelationService rs = (RelationService)this.services.get(service);
            result1 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), null, null);
            result2 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), null, null);
            result3 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeCX", null);
            result4 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeC", null);
            result5 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), null, "roleC1");
            result6 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), null, "roleC2");
            result7 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), null, "roleC1");
            result8 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), null, "roleC2");
            result9 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeCX", "roleC1");
            result10 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeC", "roleC1");
            result11 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeCX", "roleC2");
            result12 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeC", "roleC2");
            result13 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeCX", "roleC1");
            result14 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeC", "roleC1");
            result15 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeCX", "roleC2");
            result16 = rs.findAssociatedMBeans(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeC", "roleC2");
            RelationServiceTestCase.assertEquals((int)5, (int)result1.size());
            RelationServiceTestCase.assertEquals((int)5, (int)result2.size());
            RelationServiceTestCase.assertEquals((int)4, (int)result3.size());
            RelationServiceTestCase.assertEquals((int)2, (int)result4.size());
            RelationServiceTestCase.assertEquals((int)2, (int)result5.size());
            RelationServiceTestCase.assertEquals((int)5, (int)result6.size());
            RelationServiceTestCase.assertEquals((int)2, (int)result7.size());
            RelationServiceTestCase.assertEquals((int)5, (int)result8.size());
            RelationServiceTestCase.assertEquals((int)0, (int)result9.size());
            RelationServiceTestCase.assertEquals((int)2, (int)result10.size());
            RelationServiceTestCase.assertEquals((int)4, (int)result11.size());
            RelationServiceTestCase.assertEquals((int)2, (int)result12.size());
            RelationServiceTestCase.assertEquals((int)0, (int)result13.size());
            RelationServiceTestCase.assertEquals((int)2, (int)result14.size());
            RelationServiceTestCase.assertEquals((int)4, (int)result15.size());
            RelationServiceTestCase.assertEquals((int)2, (int)result16.size());
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testFindAssociatedMBeansErrors() throws Exception {
        RelationService rs = new RelationService(true);
        boolean caught = false;
        try {
            rs.findAssociatedMBeans(null, null, null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"findAssociatedMBeans allows a null mbean name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindReferencingRelationsExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            this.createRelationTypeCX(service);
            this.createRolesCX(server);
            Map<String, List<String>> result1 = null;
            Map<String, List<String>> result2 = null;
            Map<String, List<String>> result3 = null;
            Map<String, List<String>> result4 = null;
            Map<String, List<String>> result5 = null;
            Map<String, List<String>> result6 = null;
            Map<String, List<String>> result7 = null;
            Map<String, List<String>> result8 = null;
            Map<String, List<String>> result9 = null;
            Map<String, List<String>> result10 = null;
            Map<String, List<String>> result11 = null;
            Map<String, List<String>> result12 = null;
            Map<String, List<String>> result13 = null;
            Map<String, List<String>> result14 = null;
            Map<String, List<String>> result15 = null;
            Map<String, List<String>> result16 = null;
            RelationSupport supportCX = new RelationSupport("idcx", service, server, "relationTypeCX", this.rolesCX);
            RelationSupport supportC = new RelationSupport("idc", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, supportCX, "test:type=supportCX");
            this.addRelation(server, service, supportC, "test:type=supportC");
            RelationService rs = (RelationService)this.services.get(service);
            result1 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), null, null);
            result2 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), null, null);
            result3 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeCX", null);
            result4 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeC", null);
            result5 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), null, "roleC1");
            result6 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), null, "roleC2");
            result7 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), null, "roleC1");
            result8 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), null, "roleC2");
            result9 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeCX", "roleC1");
            result10 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeC", "roleC1");
            result11 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeCX", "roleC2");
            result12 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeC", "roleC2");
            result13 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeCX", "roleC1");
            result14 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeC", "roleC1");
            result15 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeCX", "roleC2");
            result16 = rs.findReferencingRelations(new ObjectName("x:relation=c,role=1,bean=1"), "relationTypeC", "roleC2");
            RelationServiceTestCase.assertEquals((int)2, (int)result1.size());
            RelationServiceTestCase.assertEquals((int)2, (int)result2.size());
            RelationServiceTestCase.assertEquals((int)1, (int)result3.size());
            RelationServiceTestCase.assertEquals((int)1, (int)result4.size());
            RelationServiceTestCase.assertEquals((int)1, (int)result5.size());
            RelationServiceTestCase.assertEquals((int)2, (int)result6.size());
            RelationServiceTestCase.assertEquals((int)1, (int)result7.size());
            RelationServiceTestCase.assertEquals((int)2, (int)result8.size());
            RelationServiceTestCase.assertEquals((int)0, (int)result9.size());
            RelationServiceTestCase.assertEquals((int)1, (int)result10.size());
            RelationServiceTestCase.assertEquals((int)1, (int)result11.size());
            RelationServiceTestCase.assertEquals((int)1, (int)result12.size());
            RelationServiceTestCase.assertEquals((int)0, (int)result13.size());
            RelationServiceTestCase.assertEquals((int)1, (int)result14.size());
            RelationServiceTestCase.assertEquals((int)1, (int)result15.size());
            RelationServiceTestCase.assertEquals((int)1, (int)result16.size());
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testFindReferencingRelationsErrors() throws Exception {
        RelationService rs = new RelationService(true);
        boolean caught = false;
        try {
            rs.findReferencingRelations(null, null, null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"findReferencingRelations allows a null mbean name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindRelationsOfTypeExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeA(service);
            this.createRolesA(server);
            this.createRelationTypeB(service);
            this.createRolesB(server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            this.createRelationTypeCX(service);
            this.createRolesCX(server);
            List<String> result1 = null;
            List<String> result2 = null;
            List<String> result3 = null;
            List<String> result4 = null;
            RelationSupport supportA1 = new RelationSupport("ida1", service, server, "relationTypeA", this.rolesA);
            RelationSupport supportA2 = new RelationSupport("ida2", service, server, "relationTypeA", this.rolesA);
            RelationSupport supportCX = new RelationSupport("idcx", service, server, "relationTypeCX", this.rolesCX);
            RelationSupport supportC = new RelationSupport("idc", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, supportA1, "test:type=supportA1");
            this.addRelation(server, service, supportA2, "test:type=supportA2");
            this.addRelation(server, service, supportCX, "test:type=supportCX");
            this.addRelation(server, service, supportC, "test:type=supportC");
            RelationService rs = (RelationService)this.services.get(service);
            result1 = rs.findRelationsOfType("relationTypeA");
            result2 = rs.findRelationsOfType("relationTypeB");
            result3 = rs.findRelationsOfType("relationTypeC");
            result4 = rs.findRelationsOfType("relationTypeCX");
            RelationServiceTestCase.assertEquals((int)2, (int)result1.size());
            RelationServiceTestCase.assertEquals((int)0, (int)result2.size());
            RelationServiceTestCase.assertEquals((int)1, (int)result3.size());
            RelationServiceTestCase.assertEquals((int)1, (int)result4.size());
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testFindRelationsOfTypeErrors() throws Exception {
        RelationService rs = new RelationService(true);
        boolean caught = false;
        try {
            rs.findRelationsOfType(null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"findRelationsOfType allows a null relation type name");
        }
        caught = false;
        try {
            rs.findRelationsOfType("rubbish");
        }
        catch (RelationTypeNotFoundException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"findRelationsOfType allows an invalid relation type name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetAllRelationsIdsExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeA(service);
            this.createRolesA(server);
            this.createRelationTypeB(service);
            this.createRolesB(server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            this.createRelationTypeCX(service);
            this.createRolesCX(server);
            List<String> result = null;
            RelationSupport supportA1 = new RelationSupport("ida1", service, server, "relationTypeA", this.rolesA);
            RelationSupport supportA2 = new RelationSupport("ida2", service, server, "relationTypeA", this.rolesA);
            RelationSupport supportCX = new RelationSupport("idcx", service, server, "relationTypeCX", this.rolesCX);
            RelationSupport supportC = new RelationSupport("idc", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, supportA1, "test:type=supportA1");
            this.addRelation(server, service, supportA2, "test:type=supportA2");
            this.addRelation(server, service, supportCX, "test:type=supportCX");
            this.addRelation(server, service, supportC, "test:type=supportC");
            RelationService rs = (RelationService)this.services.get(service);
            result = rs.getAllRelationIds();
            RelationServiceTestCase.assertEquals((int)4, (int)result.size());
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)result.contains("ida1"));
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)result.contains("ida2"));
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)result.contains("idcx"));
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)result.contains("idc"));
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testGetAllRelationTypeNames() throws Exception {
        RelationService rs = new RelationService(true);
        RelationServiceTestCase.assertEquals((int)0, (int)rs.getAllRelationTypeNames().size());
        RoleInfo roleInfo1 = null;
        RoleInfo roleInfo2 = null;
        RoleInfo[] roleInfos = null;
        roleInfo1 = new RoleInfo("roleInfo1", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
        roleInfo2 = new RoleInfo("roleInfo2", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
        roleInfos = new RoleInfo[]{roleInfo1, roleInfo2};
        rs.createRelationType("name1", roleInfos);
        rs.createRelationType("name2", roleInfos);
        rs.createRelationType("name3", roleInfos);
        ArrayList result = (ArrayList)rs.getAllRelationTypeNames();
        RelationServiceTestCase.assertEquals((int)3, (int)result.size());
        RelationServiceTestCase.assertEquals((boolean)true, (boolean)result.contains("name1"));
        RelationServiceTestCase.assertEquals((boolean)true, (boolean)result.contains("name2"));
        RelationServiceTestCase.assertEquals((boolean)true, (boolean)result.contains("name3"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetAllRolesExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeB(service);
            this.createRolesB(server);
            RoleResult result = null;
            RelationSupport support = new RelationSupport("id", service, server, "relationTypeB", this.rolesB);
            this.addRelation(server, service, support, "test:type=support");
            result = support.getAllRoles();
            this.checkResult(result, this.roleInfosB, this.rolesB);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetAllRolesErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            RelationService rs = (RelationService)this.services.get(service);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RoleList roles = new RoleList();
            roles.add(this.roleC1);
            roles.add(this.roleC2);
            rs.createRelation("relationId", "relationTypeC", roles);
            String[] roleNames = new String[]{"roleC1"};
            boolean caught = false;
            try {
                rs.getAllRoles(null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getAllRoles allows null relation id");
            }
            caught = false;
            try {
                rs.getAllRoles("rubbish");
            }
            catch (RelationNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getAllRoles allows invalid relation id");
            }
            server.unregisterMBean(service);
            caught = false;
            try {
                rs.getAllRoles("relationId");
            }
            catch (RelationServiceNotRegisteredException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"FAILS IN RI: getAllRoles allowed when not registered");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testGetNotificationInfo() {
        RelationService rs = new RelationService(true);
        MBeanNotificationInfo[] mbni = rs.getNotificationInfo();
        RelationServiceTestCase.assertEquals((int)1, (int)mbni.length);
        HashSet<String> types = new HashSet<String>();
        types.add("jmx.relation.creation.basic");
        types.add("jmx.relation.removal.basic");
        types.add("jmx.relation.update.basic");
        types.add("jmx.relation.creation.mbean");
        types.add("jmx.relation.removal.mbean");
        types.add("jmx.relation.update.mbean");
        String[] mbniTypes = mbni[0].getNotifTypes();
        RelationServiceTestCase.assertEquals((int)types.size(), (int)mbniTypes.length);
        for (int i = 0; i < mbniTypes.length; ++i) {
            if (types.contains(mbniTypes[i])) continue;
            RelationServiceTestCase.fail((String)("Unexpected relation notification type: " + mbniTypes[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSetPurgeFlag() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            RelationService rs = null;
            ObjectName name = null;
            rs = new RelationService(true);
            name = new ObjectName("test:type = rs");
            server.registerMBean(rs, name);
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)rs.getPurgeFlag());
            rs.setPurgeFlag(false);
            RelationServiceTestCase.assertEquals((boolean)false, (boolean)rs.getPurgeFlag());
            rs.setPurgeFlag(true);
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)rs.getPurgeFlag());
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetReferencedMBeansExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            Map<ObjectName, List<String>> result = null;
            RelationSupport support = new RelationSupport("id", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support");
            result = support.getReferencedMBeans();
            this.checkMBeans(result, this.rolesC);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetReferencedMBeansErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            RelationService rs = (RelationService)this.services.get(service);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RoleList roles = new RoleList();
            roles.add(this.roleC1);
            roles.add(this.roleC2);
            rs.createRelation("relationId", "relationTypeC", roles);
            String[] roleNames = new String[]{"roleC1"};
            boolean caught = false;
            try {
                rs.getReferencedMBeans(null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getReferencedMBeans allows null relation id");
            }
            caught = false;
            try {
                rs.getReferencedMBeans("rubbish");
            }
            catch (RelationNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getReferencedMBeans allows invalid relation id");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRelationTypeNameExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            RelationService rs = (RelationService)this.services.get(service);
            this.createRelationTypeB(service);
            this.createRolesB(server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RelationSupport relB = null;
            RelationSupport relC = null;
            String resultB = null;
            String resultC = null;
            relB = new RelationSupport("idB", service, server, "relationTypeB", this.rolesB);
            this.addRelation(server, service, relB, "test:type=supportB");
            relC = new RelationSupport("idC", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, relC, "test:type=supportC");
            resultB = rs.getRelationTypeName("idB");
            resultC = rs.getRelationTypeName("idC");
            RelationServiceTestCase.assertEquals((String)"relationTypeB", (String)resultB);
            RelationServiceTestCase.assertEquals((String)"relationTypeC", (String)resultC);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRelationTypeNameErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            RelationService rs = (RelationService)this.services.get(service);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RoleList roles = new RoleList();
            roles.add(this.roleC1);
            roles.add(this.roleC2);
            rs.createRelation("relationId", "relationTypeC", roles);
            String[] roleNames = new String[]{"roleC1"};
            boolean caught = false;
            try {
                rs.getRelationTypeName(null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getRelationTypeName allows null relation id");
            }
            caught = false;
            try {
                rs.getRelationTypeName("rubbish");
            }
            catch (RelationNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getRelationTypeName allows invalid relation id");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRoleExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            List<ObjectName> result = null;
            RelationSupport support = new RelationSupport("id", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support");
            result = support.getRole("roleC1");
            this.compareListOfObjectNames(this.getRole(this.rolesC, "roleC1").getRoleValue(), result);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRoleErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            RelationService rs = (RelationService)this.services.get(service);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RoleList roles = new RoleList();
            roles.add(this.roleC1);
            roles.add(this.roleC2);
            rs.createRelation("relationId", "relationTypeC", roles);
            boolean caught = false;
            try {
                rs.getRole(null, "roleC1");
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getRole allows null relation id");
            }
            caught = false;
            try {
                rs.getRole("relationId", null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getRole allows null role");
            }
            caught = false;
            try {
                rs.getRole("rubbish", "roleC1");
            }
            catch (RelationNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getRole allows invalid relation id");
            }
            caught = false;
            try {
                rs.getRole("relationId", "rubbish");
            }
            catch (RoleNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getRole allows invalid role name");
            }
            caught = false;
            try {
                rs.getRole("relationId", "roleC2");
            }
            catch (RoleNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getRole allows unreadable role");
            }
            server.unregisterMBean(service);
            caught = false;
            try {
                rs.getRole("relationId", "roleC1");
            }
            catch (RelationServiceNotRegisteredException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"FAILS IN RI: getRole allowed when not registered");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRoleCardinalityExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            Integer result = null;
            RelationSupport support = null;
            support = new RelationSupport("id", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support");
            result = support.getRoleCardinality("roleC1");
            RelationServiceTestCase.assertEquals((int)2, (int)result);
            result = support.getRoleCardinality("roleC2");
            RelationServiceTestCase.assertEquals((int)3, (int)result);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRoleCardinalityErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            RelationService rs = (RelationService)this.services.get(service);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RoleList roles = new RoleList();
            roles.add(this.roleC1);
            roles.add(this.roleC2);
            rs.createRelation("relationId", "relationTypeC", roles);
            boolean caught = false;
            try {
                rs.getRoleCardinality(null, "roleC1");
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getRoleCardinality allows null relation id");
            }
            caught = false;
            try {
                rs.getRoleCardinality("relationId", null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getRoleCardinality allows null role");
            }
            caught = false;
            try {
                rs.getRoleCardinality("rubbish", "roleC1");
            }
            catch (RelationNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getRoleCardinality allows invalid relation id");
            }
            caught = false;
            try {
                rs.getRoleCardinality("relationId", "rubbish");
            }
            catch (RoleNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getRoleCardinality allows invalid role name");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRolesExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            RelationService rs = (RelationService)this.services.get(service);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RoleResult result = null;
            RelationSupport support = null;
            support = new RelationSupport("id", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support");
            result = rs.getRoles("id", new String[]{"roleC1", "roleC2"});
            this.checkResult(result, this.roleInfosC, this.rolesC);
            result = rs.getRoles("id", new String[]{"roleC1"});
            RoleList resolved = result.getRoles();
            RelationServiceTestCase.assertEquals((int)1, (int)resolved.size());
            RelationServiceTestCase.assertEquals((int)0, (int)result.getRolesUnresolved().size());
            this.compare(this.getRole(this.rolesC, "roleC1"), (Role)resolved.get(0));
            result = rs.getRoles("id", new String[]{"roleC2"});
            RoleUnresolvedList unresolved = result.getRolesUnresolved();
            RelationServiceTestCase.assertEquals((int)0, (int)result.getRoles().size());
            RelationServiceTestCase.assertEquals((int)1, (int)unresolved.size());
            RelationServiceTestCase.assertEquals((String)"roleC2", (String)((RoleUnresolved)unresolved.get(0)).getRoleName());
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRolesErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            RelationService rs = (RelationService)this.services.get(service);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RoleList roles = new RoleList();
            roles.add(this.roleC1);
            roles.add(this.roleC2);
            rs.createRelation("relationId", "relationTypeC", roles);
            String[] roleNames = new String[]{"roleC1"};
            boolean caught = false;
            try {
                rs.getRoles(null, roleNames);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getRoles allows null relation id");
            }
            caught = false;
            try {
                rs.getRoles("relationId", null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getRoles allows null role name array");
            }
            caught = false;
            try {
                rs.getRoles("rubbish", roleNames);
            }
            catch (RelationNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"getRoles allows invalid relation id");
            }
            server.unregisterMBean(service);
            caught = false;
            try {
                rs.getRoles("relationId", roleNames);
            }
            catch (RelationServiceNotRegisteredException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"FAILS IN RI: getRoles allowed when not registered");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHasRelationExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RelationSupport support = null;
            Boolean result1 = null;
            Boolean result2 = null;
            Boolean result3 = null;
            Boolean result4 = null;
            Boolean result5 = null;
            Boolean result6 = null;
            support = new RelationSupport("id1", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support1");
            support = new RelationSupport("id2", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support2");
            RelationService rs = (RelationService)this.services.get(service);
            result1 = rs.hasRelation("id1");
            result2 = rs.hasRelation("id2");
            result3 = rs.hasRelation("id3");
            rs.removeRelation("id2");
            result4 = rs.hasRelation("id1");
            result5 = rs.hasRelation("id2");
            result6 = rs.hasRelation("id3");
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)result1);
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)result2);
            RelationServiceTestCase.assertEquals((boolean)false, (boolean)result3);
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)result4);
            RelationServiceTestCase.assertEquals((boolean)false, (boolean)result5);
            RelationServiceTestCase.assertEquals((boolean)false, (boolean)result6);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testHasRelationErrors() throws Exception {
        RelationService rs = new RelationService(true);
        boolean caught = false;
        try {
            rs.hasRelation(null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"hasRelation allows null relation id");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsActive() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            RelationService rs = null;
            boolean caught = false;
            try {
                rs = new RelationService(true);
                rs.isActive();
            }
            catch (RelationServiceNotRegisteredException e) {
                caught = true;
            }
            catch (Exception e) {
                RelationServiceTestCase.fail((String)e.toString());
            }
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)caught);
            ObjectName name = null;
            name = new ObjectName("test:type = rs");
            server.registerMBean(rs, name);
            rs.isActive();
            caught = false;
            try {
                server.unregisterMBean(name);
                rs.isActive();
            }
            catch (RelationServiceNotRegisteredException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"FAILS IN RI: Relation Service still reports itself active.");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsRelationExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RelationSupport support = null;
            String result1 = null;
            String result2 = null;
            String result3 = null;
            String result4 = null;
            String result5 = null;
            String result6 = null;
            support = new RelationSupport("id1", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support1");
            support = new RelationSupport("id2", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support2");
            RelationService rs = (RelationService)this.services.get(service);
            result1 = rs.isRelation(new ObjectName("test:type=support1"));
            result2 = rs.isRelation(new ObjectName("test:type=support2"));
            result3 = rs.isRelation(new ObjectName("test:type=support3"));
            rs.removeRelation("id2");
            result4 = rs.isRelation(new ObjectName("test:type=support1"));
            result5 = rs.isRelation(new ObjectName("test:type=support2"));
            result6 = rs.isRelation(new ObjectName("test:type=support3"));
            RelationServiceTestCase.assertEquals((String)"id1", (String)result1);
            RelationServiceTestCase.assertEquals((String)"id2", (String)result2);
            RelationServiceTestCase.assertEquals(null, (String)result3);
            RelationServiceTestCase.assertEquals((String)"id1", (String)result4);
            RelationServiceTestCase.assertEquals(null, (String)result5);
            RelationServiceTestCase.assertEquals(null, (String)result6);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testIsRelationErrors() throws Exception {
        RelationService rs = new RelationService(true);
        boolean caught = false;
        try {
            rs.isRelation(null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"isRelation allows null relation id");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsRelationMBeanExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RelationSupport support = null;
            ObjectName result1 = null;
            ObjectName result2 = null;
            ObjectName on1 = null;
            ObjectName on2 = null;
            support = new RelationSupport("id1", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support1");
            support = new RelationSupport("id2", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support2");
            RelationService rs = (RelationService)this.services.get(service);
            result1 = rs.isRelationMBean("id1");
            result2 = rs.isRelationMBean("id2");
            on1 = new ObjectName("test:type=support1");
            on2 = new ObjectName("test:type=support2");
            RelationServiceTestCase.assertEquals((Object)on1, (Object)result1);
            RelationServiceTestCase.assertEquals((Object)on2, (Object)result2);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testIsRelationMBeanErrors() throws Exception {
        RelationService rs = new RelationService(true);
        boolean caught = false;
        try {
            rs.isRelationMBean(null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"isRelationMBean allows null relation id");
        }
        caught = false;
        try {
            rs.isRelationMBean("rubbish");
        }
        catch (RelationNotFoundException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"isRelationMBean allows non-existent relation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPurgeRelationsAutomaticExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RelationSupport support = null;
            ObjectName on = null;
            Listener listener = new Listener("jmx.relation.removal.mbean");
            boolean result = false;
            support = new RelationSupport("id1", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support1");
            server.addNotificationListener(service, listener, null, null);
            RelationService rs = (RelationService)this.services.get(service);
            server.unregisterMBean(new ObjectName("x:relation=c,role=2,bean=1"));
            on = new ObjectName("test:type=support1");
            result = rs.hasRelation("id1");
            RelationServiceTestCase.assertEquals((boolean)false, (boolean)result);
            RelationNotification rn = listener.check(1);
            RelationServiceTestCase.assertEquals(new ArrayList(), rn.getMBeansToUnregister());
            RelationServiceTestCase.assertEquals((Object)on, (Object)rn.getObjectName());
            RelationServiceTestCase.assertEquals((String)"id1", (String)rn.getRelationId());
            RelationServiceTestCase.assertEquals((String)"relationTypeC", (String)rn.getRelationTypeName());
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPurgeRelationsManuallyExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RelationSupport support = null;
            ObjectName on = null;
            Listener listener = new Listener("jmx.relation.removal.mbean");
            boolean result = false;
            RelationService rs = null;
            support = new RelationSupport("id1", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support1");
            server.addNotificationListener(service, listener, null, null);
            rs = (RelationService)this.services.get(service);
            rs.setPurgeFlag(false);
            server.unregisterMBean(new ObjectName("x:relation=c,role=2,bean=1"));
            on = new ObjectName("test:type=support1");
            result = rs.hasRelation("id1");
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)result);
            RelationNotification rn = listener.check(0);
            rs.purgeRelations();
            result = rs.hasRelation("id1");
            RelationServiceTestCase.assertEquals((boolean)false, (boolean)result);
            rn = listener.check(1);
            RelationServiceTestCase.assertEquals(new ArrayList(), rn.getMBeansToUnregister());
            RelationServiceTestCase.assertEquals((Object)on, (Object)rn.getObjectName());
            RelationServiceTestCase.assertEquals((String)"id1", (String)rn.getRelationId());
            RelationServiceTestCase.assertEquals((String)"relationTypeC", (String)rn.getRelationTypeName());
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testPurgeRelationsErrors() throws Exception {
        RelationService rs = new RelationService(true);
        boolean caught = false;
        try {
            rs.purgeRelations();
        }
        catch (RelationServiceNotRegisteredException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"purgeRelations allowed when not registered");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveRelationExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeA(service);
            this.createRolesA(server);
            this.createRelationTypeB(service);
            this.createRolesB(server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            this.createRelationTypeCX(service);
            this.createRolesCX(server);
            List<String> result = null;
            RelationSupport supportA1 = new RelationSupport("ida1", service, server, "relationTypeA", this.rolesA);
            RelationSupport supportA2 = new RelationSupport("ida2", service, server, "relationTypeA", this.rolesA);
            RelationSupport supportCX = new RelationSupport("idcx", service, server, "relationTypeCX", this.rolesCX);
            RelationSupport supportC = new RelationSupport("idc", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, supportA1, "test:type=supportA1");
            this.addRelation(server, service, supportA2, "test:type=supportA2");
            this.addRelation(server, service, supportCX, "test:type=supportCX");
            this.addRelation(server, service, supportC, "test:type=supportC");
            RelationService rs = (RelationService)this.services.get(service);
            rs.removeRelation("idcx");
            result = rs.getAllRelationIds();
            RelationServiceTestCase.assertEquals((int)3, (int)result.size());
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)result.contains("ida1"));
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)result.contains("ida2"));
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)result.contains("idc"));
            RelationServiceTestCase.assertEquals((boolean)false, (boolean)result.contains("idcx"));
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveRelationErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=serviceA", null);
            RelationService rs = null;
            rs = (RelationService)this.services.get(service);
            boolean caught = false;
            try {
                rs.removeRelation("RelationId");
            }
            catch (RelationServiceNotRegisteredException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"removeRelation allowed when not registered");
            }
            service = this.createRelationService("test:type=service", server);
            this.createRelationTypeA(service);
            this.createRolesA(server);
            RelationSupport supportA1 = new RelationSupport("ida1", service, server, "relationTypeA", this.rolesA);
            this.addRelation(server, service, supportA1, "test:type=supportA1");
            rs = (RelationService)this.services.get(service);
            caught = false;
            try {
                rs.removeRelation(null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"removeRelation accepts a null relation");
            }
            caught = false;
            try {
                rs.removeRelation("rubbish");
            }
            catch (RelationNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"removeRelation accepts a non existent relation");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveRelationType() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            RelationService rs = new RelationService(true);
            RelationServiceTestCase.assertEquals((int)0, (int)rs.getAllRelationTypeNames().size());
            RoleInfo roleInfo1 = null;
            RoleInfo roleInfo2 = null;
            RoleInfo[] roleInfos = null;
            ObjectName name = new ObjectName("test:type = rs");
            server.registerMBean(rs, name);
            roleInfo1 = new RoleInfo("roleInfo1", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
            roleInfo2 = new RoleInfo("roleInfo2", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
            roleInfos = new RoleInfo[]{roleInfo1, roleInfo2};
            rs.createRelationType("name1", roleInfos);
            rs.createRelationType("name2", roleInfos);
            rs.createRelationType("name3", roleInfos);
            rs.removeRelationType("name3");
            ArrayList result = (ArrayList)rs.getAllRelationTypeNames();
            RelationServiceTestCase.assertEquals((int)2, (int)result.size());
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)result.contains("name1"));
            RelationServiceTestCase.assertEquals((boolean)true, (boolean)result.contains("name2"));
            RelationServiceTestCase.assertEquals((boolean)false, (boolean)result.contains("name3"));
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveRelationTypeErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            RelationService rs = null;
            RoleInfo roleInfo1 = null;
            RoleInfo roleInfo2 = null;
            RoleInfo[] roleInfos = null;
            rs = new RelationService(true);
            roleInfo1 = new RoleInfo("roleInfo1", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
            roleInfo2 = new RoleInfo("roleInfo2", (class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial).getName());
            roleInfos = new RoleInfo[]{roleInfo1, roleInfo2};
            rs.createRelationType("name1", roleInfos);
            boolean caught = false;
            try {
                rs.removeRelationType("name1");
            }
            catch (RelationServiceNotRegisteredException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"Remove relation type allowed when not registered, why not?");
            }
            server.registerMBean(rs, new ObjectName("test:type=RelationService"));
            caught = false;
            try {
                rs.removeRelationType(null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"Remove relation type allows null relation type name");
            }
            caught = false;
            try {
                rs.removeRelationType("rubbish");
            }
            catch (RelationTypeNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"Remove relation type allows non-existent relation type name");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendRelationCreationNotificationExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RelationSupport support = null;
            ObjectName on = null;
            Listener listener = new Listener("jmx.relation.creation.mbean");
            support = new RelationSupport("id1", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support1");
            server.addNotificationListener(service, listener, null, null);
            RelationService rs = (RelationService)this.services.get(service);
            rs.sendRelationCreationNotification("id1");
            on = new ObjectName("test:type=support1");
            RelationNotification rn = listener.check(1);
            RelationServiceTestCase.assertEquals(new ArrayList(), rn.getMBeansToUnregister());
            RelationServiceTestCase.assertEquals(new ArrayList(), rn.getNewRoleValue());
            RelationServiceTestCase.assertEquals((Object)on, (Object)rn.getObjectName());
            RelationServiceTestCase.assertEquals(new ArrayList(), rn.getOldRoleValue());
            RelationServiceTestCase.assertEquals((String)"id1", (String)rn.getRelationId());
            RelationServiceTestCase.assertEquals((String)"relationTypeC", (String)rn.getRelationTypeName());
            RelationServiceTestCase.assertEquals(null, (String)rn.getRoleName());
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testSendRelationCreationNotificationErrors() throws Exception {
        RelationService rs = new RelationService(true);
        boolean caught = false;
        try {
            rs.sendRelationCreationNotification(null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"sendRelationCreationNotification allows null relation id");
        }
        caught = false;
        try {
            rs.sendRelationCreationNotification("rubbish");
        }
        catch (RelationNotFoundException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"sendRelationCreationNotification allows invalid relation id");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendRelationRemovalNotificationExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RelationSupport support = null;
            ObjectName on = null;
            ArrayList<ObjectName> test = new ArrayList<ObjectName>();
            Listener listener = new Listener("jmx.relation.removal.mbean");
            support = new RelationSupport("id1", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support1");
            server.addNotificationListener(service, listener, null, null);
            RelationService rs = (RelationService)this.services.get(service);
            test.add(new ObjectName("test:type=test"));
            rs.sendRelationRemovalNotification("id1", test);
            on = new ObjectName("test:type=support1");
            RelationNotification rn = listener.check(1);
            RelationServiceTestCase.assertEquals(test, rn.getMBeansToUnregister());
            RelationServiceTestCase.assertEquals(new ArrayList(), rn.getNewRoleValue());
            RelationServiceTestCase.assertEquals((Object)on, (Object)rn.getObjectName());
            RelationServiceTestCase.assertEquals(new ArrayList(), rn.getOldRoleValue());
            RelationServiceTestCase.assertEquals((String)"id1", (String)rn.getRelationId());
            RelationServiceTestCase.assertEquals((String)"relationTypeC", (String)rn.getRelationTypeName());
            RelationServiceTestCase.assertEquals(null, (String)rn.getRoleName());
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testSendRelationRemovalNotificationErrors() throws Exception {
        RelationService rs = new RelationService(true);
        boolean caught = false;
        try {
            rs.sendRelationRemovalNotification(null, new ArrayList<ObjectName>());
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"sendRelationRemovalNotification allows null relation id");
        }
        caught = false;
        try {
            rs.sendRelationRemovalNotification("rubbish", new ArrayList<ObjectName>());
        }
        catch (RelationNotFoundException e) {
            caught = true;
        }
        if (!caught) {
            RelationServiceTestCase.fail((String)"sendRelationRemovalNotification allows invalid relation id");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendRoleUpdateNotificationExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesB(server);
            this.createRolesC(server);
            RelationSupport support = null;
            ObjectName on = null;
            ArrayList<ObjectName> test = new ArrayList<ObjectName>();
            Listener listener = new Listener("jmx.relation.update.mbean");
            support = new RelationSupport("id1", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support1");
            server.addNotificationListener(service, listener, null, null);
            RelationService rs = (RelationService)this.services.get(service);
            test.add(new ObjectName("test:type=test"));
            rs.sendRoleUpdateNotification("id1", this.roleB1, test);
            on = new ObjectName("test:type=support1");
            RelationNotification rn = listener.check(1);
            RelationServiceTestCase.assertEquals(new ArrayList(), rn.getMBeansToUnregister());
            RelationServiceTestCase.assertEquals(this.roleB1.getRoleValue(), rn.getNewRoleValue());
            RelationServiceTestCase.assertEquals((Object)on, (Object)rn.getObjectName());
            RelationServiceTestCase.assertEquals(test, rn.getOldRoleValue());
            RelationServiceTestCase.assertEquals((String)"id1", (String)rn.getRelationId());
            RelationServiceTestCase.assertEquals((String)"relationTypeC", (String)rn.getRelationTypeName());
            RelationServiceTestCase.assertEquals((String)"roleB1", (String)rn.getRoleName());
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendRoleUpdateNotificationErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            RelationService rs = (RelationService)this.services.get(service);
            this.createRelationTypeB(service);
            this.createRolesB(server);
            boolean caught = false;
            try {
                rs.sendRoleUpdateNotification(null, this.roleB1, new ArrayList<ObjectName>());
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"sendRoleUpdateNotification allows null relation id");
            }
            RoleList roleList = new RoleList();
            roleList.add(this.roleB1);
            roleList.add(this.roleB2);
            rs.createRelation("relationId", "relationTypeB", roleList);
            caught = false;
            try {
                rs.sendRoleUpdateNotification("relationId", null, new ArrayList<ObjectName>());
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"sendRoleUpdateNotification allows null role");
            }
            caught = false;
            try {
                rs.sendRoleUpdateNotification("rubbish", this.roleB1, new ArrayList<ObjectName>());
            }
            catch (RelationNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"sendRoleUpdateNotification allows invalid relation id");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetRoleExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            this.createRolesCX(server);
            RelationSupport support = null;
            ObjectName on = null;
            Listener listener = new Listener("jmx.relation.update.mbean");
            support = new RelationSupport("id1", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support1");
            server.addNotificationListener(service, listener, null, null);
            RelationService rs = (RelationService)this.services.get(service);
            rs.setRole("id1", this.roleCX2);
            on = new ObjectName("test:type=support1");
            RoleList shouldBe = new RoleList();
            shouldBe.add(this.roleC1);
            shouldBe.add(this.roleCX2);
            this.compare(shouldBe, support.retrieveAllRoles());
            RelationNotification rn = listener.check(1);
            RelationServiceTestCase.assertEquals(new ArrayList(), rn.getMBeansToUnregister());
            RelationServiceTestCase.assertEquals(this.roleCX2.getRoleValue(), rn.getNewRoleValue());
            RelationServiceTestCase.assertEquals((Object)on, (Object)rn.getObjectName());
            RelationServiceTestCase.assertEquals(this.roleC2.getRoleValue(), rn.getOldRoleValue());
            RelationServiceTestCase.assertEquals((String)"id1", (String)rn.getRelationId());
            RelationServiceTestCase.assertEquals((String)"relationTypeC", (String)rn.getRelationTypeName());
            RelationServiceTestCase.assertEquals((String)"roleC2", (String)rn.getRoleName());
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetRoleErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            RelationService rs = (RelationService)this.services.get(service);
            this.createRelationTypeB(service);
            this.createRolesB(server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            this.createRolesCZ(server);
            this.createRolesCZZ(server);
            RoleList roles = new RoleList();
            roles.add(this.roleC1);
            roles.add(this.roleC2);
            rs.createRelation("relationId", "relationTypeC", roles);
            boolean caught = false;
            try {
                rs.setRole(null, this.roleC2);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"setRole allows null relation id");
            }
            caught = false;
            try {
                rs.setRole("relationId", null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"setRole allows null role");
            }
            caught = false;
            try {
                rs.setRole("rubbish", this.roleC2);
            }
            catch (RelationNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"setRole allows invalid relation id");
            }
            caught = false;
            try {
                rs.setRole("relationId", this.roleB1);
            }
            catch (RoleNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"setRole allows invalid role name");
            }
            caught = false;
            try {
                rs.setRole("relationId", this.roleC1);
            }
            catch (RoleNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"setRole allows non-writable role");
            }
            caught = false;
            try {
                rs.setRole("relationId", this.roleCZ2);
            }
            catch (InvalidRoleValueException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"setRole allows a role below the minimum");
            }
            caught = false;
            try {
                rs.setRole("relationId", this.roleCZZ);
            }
            catch (InvalidRoleValueException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"setRole allows a role above the maximum");
            }
            caught = false;
            try {
                rs.setRole("relationId", this.roleCZZZ);
            }
            catch (InvalidRoleValueException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"setRole allows a role with unregistered beans");
            }
            server.unregisterMBean(service);
            caught = false;
            try {
                rs.setRole("relationId", this.roleC2);
            }
            catch (RelationServiceNotRegisteredException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"FAILS IN RI: setRole allowed when not registered");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetRolesExternal() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            this.createRolesCX(server);
            RelationSupport support = null;
            ObjectName on = null;
            Listener listener = new Listener("jmx.relation.update.mbean");
            RoleList shouldBe = new RoleList();
            shouldBe.add(this.roleC1);
            shouldBe.add(this.roleCX2);
            support = new RelationSupport("id1", service, server, "relationTypeC", this.rolesC);
            this.addRelation(server, service, support, "test:type=support1");
            server.addNotificationListener(service, listener, null, null);
            RelationService rs = (RelationService)this.services.get(service);
            rs.setRoles("id1", shouldBe);
            on = new ObjectName("test:type=support1");
            this.compare(shouldBe, support.retrieveAllRoles());
            RelationNotification rn = listener.check(1);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetRolesErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            RelationService rs = (RelationService)this.services.get(service);
            this.createRelationTypeC(service);
            this.createRolesC(server);
            RoleList roles = new RoleList();
            roles.add(this.roleC1);
            roles.add(this.roleC2);
            rs.createRelation("relationId", "relationTypeC", roles);
            RoleList newRoles = new RoleList();
            newRoles.add(this.roleC2);
            boolean caught = false;
            try {
                rs.setRoles(null, newRoles);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"setRoles allows null relation id");
            }
            caught = false;
            try {
                rs.setRole("relationId", null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"setRoles allows null role list");
            }
            caught = false;
            try {
                rs.setRoles("rubbish", newRoles);
            }
            catch (RelationNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"setRoles allows invalid relation id");
            }
            server.unregisterMBean(service);
            caught = false;
            try {
                rs.setRoles("relationId", newRoles);
            }
            catch (RelationServiceNotRegisteredException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"FAILS IN RI: setRoles allowed when not registered");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateRoleMapErrors() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName service = this.createRelationService("test:type=service", server);
            RelationService rs = (RelationService)this.services.get(service);
            this.createRelationTypeB(service);
            this.createRolesB(server);
            RoleList roleList = new RoleList();
            roleList.add(this.roleB1);
            roleList.add(this.roleB2);
            rs.createRelation("relationId", "relationTypeB", roleList);
            boolean caught = false;
            try {
                rs.updateRoleMap(null, this.roleB1, new ArrayList<ObjectName>());
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"updateRoleMap allows null relation id");
            }
            caught = false;
            try {
                rs.updateRoleMap("relationId", null, new ArrayList<ObjectName>());
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"updateRoleMap allows null role");
            }
            caught = false;
            try {
                rs.updateRoleMap("rubbish", this.roleB1, new ArrayList<ObjectName>());
            }
            catch (RelationNotFoundException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"updateRoleMap allows invalid relation id");
            }
            server.unregisterMBean(service);
            caught = false;
            try {
                rs.updateRoleMap("relationId", this.roleB1, new ArrayList<ObjectName>());
            }
            catch (RelationServiceNotRegisteredException e) {
                caught = true;
            }
            if (!caught) {
                RelationServiceTestCase.fail((String)"FAILS IN RI: updateRoleMap allowed when not registered");
            }
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    private ObjectName createRelationService(String name, MBeanServer server) {
        ObjectName result = null;
        RelationService relationService = new RelationService(true);
        try {
            result = new ObjectName(name);
            this.services.put(result, relationService);
            if (server != null) {
                server.registerMBean(relationService, result);
            }
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
        return result;
    }

    private ObjectName addRelation(MBeanServer server, ObjectName service, RelationSupport support, String name) {
        ObjectName result = null;
        try {
            result = new ObjectName(name);
            server.registerMBean(support, result);
            if (service != null) {
                RelationService relationService = (RelationService)this.services.get(service);
                relationService.addRelation(result);
            }
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
        return result;
    }

    private RoleInfo createRoleInfo(String name, Class mbean, boolean read, boolean write, int min, int max) {
        RoleInfo result = null;
        try {
            result = new RoleInfo(name, mbean.getName(), read, write, min, max, "");
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
        return result;
    }

    private void createRelationType(ObjectName relationService, String name, RoleInfo[] roleInfos) {
        try {
            RelationService service = (RelationService)this.services.get(relationService);
            service.createRelationType(name, roleInfos);
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
    }

    private void compare(RoleList original, RoleList result) {
        RelationServiceTestCase.assertEquals((int)original.size(), (int)result.size());
        Iterator iterator = original.iterator();
        while (iterator.hasNext()) {
            Role originalRole = (Role)iterator.next();
            Iterator iterator2 = result.iterator();
            while (iterator2.hasNext()) {
                Role resultRole = (Role)iterator2.next();
                if (!originalRole.getRoleName().equals(resultRole.getRoleName())) continue;
                this.compare(originalRole, resultRole);
                iterator2.remove();
            }
        }
        RelationServiceTestCase.assertEquals((int)0, (int)result.size());
    }

    private void compare(Role original, Role result) {
        RelationServiceTestCase.assertEquals((String)original.getRoleName(), (String)result.getRoleName());
        this.compareListOfObjectNames(original.getRoleValue(), result.getRoleValue());
    }

    private void compareListOfObjectNames(List original, List result) {
        RelationServiceTestCase.assertEquals((int)original.size(), (int)result.size());
        Iterator iterator = original.iterator();
        while (iterator.hasNext()) {
            ObjectName originalBean = (ObjectName)iterator.next();
            Iterator iterator2 = result.iterator();
            while (iterator2.hasNext()) {
                ObjectName resultBean = (ObjectName)iterator2.next();
                if (!originalBean.equals(resultBean)) continue;
                iterator2.remove();
            }
        }
        RelationServiceTestCase.assertEquals((int)0, (int)result.size());
    }

    private void compareListOfStrings(List original, List result) {
        RelationServiceTestCase.assertEquals((int)original.size(), (int)result.size());
        Iterator iterator = original.iterator();
        while (iterator.hasNext()) {
            String originalString = (String)iterator.next();
            Iterator iterator2 = result.iterator();
            while (iterator2.hasNext()) {
                String resultString = (String)iterator2.next();
                if (!originalString.equals(resultString)) continue;
                iterator2.remove();
            }
        }
        RelationServiceTestCase.assertEquals((int)0, (int)result.size());
    }

    private ObjectName createRoleValueBean(String name, Class mbean, MBeanServer server) {
        ObjectName result = null;
        try {
            result = new ObjectName(name);
            if (server != null) {
                server.registerMBean(mbean.newInstance(), result);
            }
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
        return result;
    }

    private void checkResult(RoleResult result, HashMap infos, RoleList roles) {
        this.checkResolved(result.getRoles(), infos, roles);
        this.checkUnresolved(result.getRolesUnresolved(), infos, roles);
    }

    private void checkResolved(RoleList resolved, HashMap infos, RoleList roles) {
        RoleInfo info;
        String roleName;
        Role role;
        RoleList copy = (RoleList)roles.clone();
        Iterator iterator = resolved.iterator();
        while (iterator.hasNext()) {
            role = (Role)iterator.next();
            roleName = role.getRoleName();
            info = (RoleInfo)infos.get(roleName);
            if (info == null) {
                RelationServiceTestCase.fail((String)("unknown role " + roleName));
            }
            if (!info.isReadable()) {
                RelationServiceTestCase.fail((String)("role should not be readable " + roleName));
            }
            Role original = this.removeRole(copy, roleName);
            this.compareListOfObjectNames(original.getRoleValue(), role.getRoleValue());
        }
        iterator = copy.iterator();
        while (iterator.hasNext()) {
            role = (Role)iterator.next();
            roleName = role.getRoleName();
            info = (RoleInfo)infos.get(roleName);
            if (!info.isReadable()) continue;
            RelationServiceTestCase.fail((String)("missing role " + roleName));
        }
    }

    private void checkUnresolved(RoleUnresolvedList unresolved, HashMap infos, RoleList roles) {
        RoleInfo info;
        String roleName;
        RoleList copy = (RoleList)roles.clone();
        Iterator iterator = unresolved.iterator();
        while (iterator.hasNext()) {
            RoleUnresolved roleUnresolved = (RoleUnresolved)iterator.next();
            roleName = roleUnresolved.getRoleName();
            info = (RoleInfo)infos.get(roleName);
            if (info == null) {
                RelationServiceTestCase.fail((String)("unknown role " + roleName));
            }
            if (info.isReadable()) {
                RelationServiceTestCase.fail((String)("role should be readable " + roleName));
            }
            this.removeRole(copy, roleName);
        }
        iterator = copy.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            roleName = role.getRoleName();
            info = (RoleInfo)infos.get(roleName);
            if (info.isReadable()) continue;
            RelationServiceTestCase.fail((String)("missing unresolved role " + roleName));
        }
    }

    private Role removeRole(RoleList roles, String roleName) {
        Iterator iterator = roles.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            if (!role.getRoleName().equals(roleName)) continue;
            iterator.remove();
            return role;
        }
        RelationServiceTestCase.fail((String)("role was not in the original " + roleName));
        return null;
    }

    private Role getRole(RoleList roles, String roleName) {
        Iterator iterator = roles.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            if (!role.getRoleName().equals(roleName)) continue;
            return role;
        }
        RelationServiceTestCase.fail((String)("role was not in the original " + roleName));
        return null;
    }

    private void checkMBeans(Map result, RoleList roles) {
        Map expected = this.calcMBeanRoleMap(roles);
        Iterator iterator = result.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ObjectName key = (ObjectName)entry.getKey();
            ArrayList roleNames = (ArrayList)entry.getValue();
            ArrayList expectedNames = (ArrayList)expected.get(key);
            if (expectedNames == null) {
                RelationServiceTestCase.fail((String)("Unexpected object name " + key));
            }
            this.compareListOfStrings(expectedNames, roleNames);
            expected.remove(key);
        }
        RelationServiceTestCase.assertEquals((int)0, (int)expected.size());
    }

    private Map calcMBeanRoleMap(RoleList roles) {
        HashMap<ObjectName, ArrayList<String>> result = new HashMap<ObjectName, ArrayList<String>>();
        Iterator iterator = roles.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            String roleName = role.getRoleName();
            ArrayList mbeans = (ArrayList)role.getRoleValue();
            Iterator iterator2 = mbeans.iterator();
            while (iterator2.hasNext()) {
                ObjectName objectName = (ObjectName)iterator2.next();
                ArrayList<String> names = (ArrayList<String>)result.get(objectName);
                if (names == null) {
                    names = new ArrayList<String>();
                    result.put(objectName, names);
                }
                names.add(roleName);
            }
        }
        return result;
    }

    private void createRolesA(MBeanServer server) {
        try {
            ArrayList<ObjectName> roleA1Values = new ArrayList<ObjectName>();
            roleA1Values.add(this.createRoleValueBean("x:relation=a,role=1,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            Role roleA1 = new Role("roleA1", roleA1Values);
            this.rolesA = new RoleList();
            this.rolesA.add(roleA1);
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
    }

    private void createRelationTypeA(ObjectName relationService) {
        try {
            RoleInfo roleInfoA1 = this.createRoleInfo("roleA1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, true, true, 1, 1);
            RoleInfo[] roleInfos = new RoleInfo[]{roleInfoA1};
            this.createRelationType(relationService, "relationTypeA", roleInfos);
            for (int i = 0; i < roleInfos.length; ++i) {
                this.roleInfosA.put(roleInfos[i].getName(), roleInfos[i]);
            }
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
    }

    private void createRolesB(MBeanServer server) {
        try {
            ArrayList<ObjectName> roleB1Values = new ArrayList<ObjectName>();
            roleB1Values.add(this.createRoleValueBean("x:relation=b,role=1,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            roleB1Values.add(this.createRoleValueBean("x:relation=b,role=1,bean=2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            this.roleB1 = new Role("roleB1", roleB1Values);
            ArrayList<ObjectName> roleB2Values = new ArrayList<ObjectName>();
            roleB2Values.add(this.createRoleValueBean("x:relation=b,role=2,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            roleB2Values.add(this.createRoleValueBean("x:relation=b,role=2,bean=2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            roleB2Values.add(this.createRoleValueBean("x:relation=b,role=2,bean=3", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            this.roleB2 = new Role("roleB2", roleB2Values);
            this.rolesB = new RoleList();
            this.rolesB.add(this.roleB1);
            this.rolesB.add(this.roleB2);
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
    }

    private void createRelationTypeB(ObjectName relationService) {
        try {
            RoleInfo roleInfoB1 = this.createRoleInfo("roleB1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, true, false, 1, 2);
            RoleInfo roleInfoB2 = this.createRoleInfo("roleB2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, false, true, 3, 4);
            RoleInfo[] roleInfos = new RoleInfo[]{roleInfoB1, roleInfoB2};
            this.createRelationType(relationService, "relationTypeB", roleInfos);
            for (int i = 0; i < roleInfos.length; ++i) {
                this.roleInfosB.put(roleInfos[i].getName(), roleInfos[i]);
            }
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
    }

    private void createRolesC(MBeanServer server) {
        try {
            ArrayList<ObjectName> roleC1Values = new ArrayList<ObjectName>();
            roleC1Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            roleC1Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            this.roleC1 = new Role("roleC1", roleC1Values);
            ArrayList<ObjectName> roleC2Values = new ArrayList<ObjectName>();
            roleC2Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            roleC2Values.add(this.createRoleValueBean("x:relation=c,role=2,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            roleC2Values.add(this.createRoleValueBean("x:relation=c,role=2,bean=2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            this.roleC2 = new Role("roleC2", roleC2Values);
            this.rolesC = new RoleList();
            this.rolesC.add(this.roleC1);
            this.rolesC.add(this.roleC2);
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
    }

    private void createRelationTypeC(ObjectName relationService) {
        try {
            RoleInfo roleInfoC1 = this.createRoleInfo("roleC1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, true, false, 1, 2);
            RoleInfo roleInfoC2 = this.createRoleInfo("roleC2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, false, true, 3, 4);
            RoleInfo[] roleInfos = new RoleInfo[]{roleInfoC1, roleInfoC2};
            this.createRelationType(relationService, "relationTypeC", roleInfos);
            for (int i = 0; i < roleInfos.length; ++i) {
                this.roleInfosC.put(roleInfos[i].getName(), roleInfos[i]);
            }
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
    }

    private void createRolesCX(MBeanServer server) {
        try {
            ArrayList<ObjectName> roleCX1Values = new ArrayList<ObjectName>();
            roleCX1Values.add(this.createRoleValueBean("x:relation=c,role=2,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            this.roleCX1 = new Role("roleC1", roleCX1Values);
            ArrayList<ObjectName> roleCX2Values = new ArrayList<ObjectName>();
            roleCX2Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            roleCX2Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            roleCX2Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=3", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            roleCX2Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=4", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            this.roleCX2 = new Role("roleC2", roleCX2Values);
            this.rolesCX = new RoleList();
            this.rolesCX.add(this.roleCX1);
            this.rolesCX.add(this.roleCX2);
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
    }

    private void createRelationTypeCX(ObjectName relationService) {
        try {
            RoleInfo roleInfoCX1 = this.createRoleInfo("roleC1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, true, false, 1, 2);
            RoleInfo roleInfoCX2 = this.createRoleInfo("roleC2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, false, true, 3, 4);
            RoleInfo[] roleInfos = new RoleInfo[]{roleInfoCX1, roleInfoCX2};
            this.createRelationType(relationService, "relationTypeCX", roleInfos);
            for (int i = 0; i < roleInfos.length; ++i) {
                this.roleInfosCX.put(roleInfos[i].getName(), roleInfos[i]);
            }
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
    }

    private void createRolesCZ(MBeanServer server) {
        try {
            ArrayList<ObjectName> roleCZ2Values = new ArrayList<ObjectName>();
            roleCZ2Values.add(this.createRoleValueBean("x:relation=c,role=1,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            this.roleCZ2 = new Role("roleC2", roleCZ2Values);
            this.rolesCZ = new RoleList();
            this.rolesCZ.add(this.roleCZ2);
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
    }

    private void createRolesCZZ(MBeanServer server) {
        try {
            ArrayList<ObjectName> roleCZZValues = new ArrayList<ObjectName>();
            roleCZZValues.add(this.createRoleValueBean("x:relation=c,role=1,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            roleCZZValues.add(this.createRoleValueBean("x:relation=c,role=1,bean=2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            roleCZZValues.add(this.createRoleValueBean("x:relation=c,role=1,bean=3", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            roleCZZValues.add(this.createRoleValueBean("x:relation=c,role=1,bean=4", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            roleCZZValues.add(this.createRoleValueBean("x:relation=c,role=1,bean=5", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, server));
            this.roleCZZ = new Role("roleC2", roleCZZValues);
            this.rolesCZZ = new RoleList();
            this.rolesCZZ.add(this.roleCZZ);
            ArrayList<ObjectName> roleCZZZValues = new ArrayList<ObjectName>();
            roleCZZZValues.add(this.createRoleValueBean("x:relation=c,role=1x,bean=1", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            roleCZZZValues.add(this.createRoleValueBean("x:relation=c,role=1x,bean=2", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            roleCZZZValues.add(this.createRoleValueBean("x:relation=c,role=1x,bean=3", class$test$compliance$relation$support$Trivial == null ? (class$test$compliance$relation$support$Trivial = RelationServiceTestCase.class$("test.compliance.relation.support.Trivial")) : class$test$compliance$relation$support$Trivial, null));
            this.roleCZZZ = new Role("roleC2", roleCZZZValues);
            this.rolesCZZZ = new RoleList();
            this.rolesCZZZ.add(this.roleCZZZ);
        }
        catch (Exception e) {
            RelationServiceTestCase.fail((String)e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Listener
    implements NotificationListener {
        String type;
        HashSet notifications = new HashSet();

        public Listener(String type) {
            this.type = type;
        }

        public void handleNotification(Notification n, Object h) {
            this.notifications.add(n);
        }

        public RelationNotification check(int size) {
            RelationNotification result = null;
            Assert.assertEquals((int)size, (int)this.notifications.size());
            Iterator iterator = this.notifications.iterator();
            while (iterator.hasNext()) {
                RelationNotification rn = (RelationNotification)iterator.next();
                Assert.assertEquals((String)this.type, (String)rn.getType());
                result = rn;
            }
            return result;
        }
    }
}

