/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.openmbean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import javax.management.ObjectName;
import javax.management.openmbean.SimpleType;
import junit.framework.TestCase;

public class SimpleTypeTestCase
extends TestCase {
    static ObjectName objectName;
    SimpleType[] types = new SimpleType[]{SimpleType.BIGDECIMAL, SimpleType.BIGINTEGER, SimpleType.BOOLEAN, SimpleType.BYTE, SimpleType.CHARACTER, SimpleType.DATE, SimpleType.DOUBLE, SimpleType.FLOAT, SimpleType.INTEGER, SimpleType.LONG, SimpleType.OBJECTNAME, SimpleType.SHORT, SimpleType.STRING, SimpleType.VOID};
    Class[] classes = new Class[]{class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SimpleTypeTestCase.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SimpleTypeTestCase.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$lang$Boolean == null ? (class$java$lang$Boolean = SimpleTypeTestCase.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Byte == null ? (class$java$lang$Byte = SimpleTypeTestCase.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Character == null ? (class$java$lang$Character = SimpleTypeTestCase.class$("java.lang.Character")) : class$java$lang$Character, class$java$util$Date == null ? (class$java$util$Date = SimpleTypeTestCase.class$("java.util.Date")) : class$java$util$Date, class$java$lang$Double == null ? (class$java$lang$Double = SimpleTypeTestCase.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Float == null ? (class$java$lang$Float = SimpleTypeTestCase.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Integer == null ? (class$java$lang$Integer = SimpleTypeTestCase.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = SimpleTypeTestCase.class$("java.lang.Long")) : class$java$lang$Long, class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = SimpleTypeTestCase.class$("javax.management.ObjectName")) : class$javax$management$ObjectName, class$java$lang$Short == null ? (class$java$lang$Short = SimpleTypeTestCase.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$String == null ? (class$java$lang$String = SimpleTypeTestCase.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Void == null ? (class$java$lang$Void = SimpleTypeTestCase.class$("java.lang.Void")) : class$java$lang$Void};
    Object[] objects = new Object[]{new BigDecimal(1), BigInteger.ONE, new Boolean(false), new Byte(127), new Character('a'), new Date(System.currentTimeMillis()), new Double(1.0), new Float(1.0f), new Integer(1), new Long(1L), objectName, new Short(Short.MAX_VALUE), new String("hello"), null};
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$javax$management$openmbean$SimpleType;

    public SimpleTypeTestCase(String s) {
        super(s);
    }

    public void testSimpleTypes() throws Exception {
        for (int i = 0; i < this.types.length; ++i) {
            String className = this.classes[i].getName();
            SimpleTypeTestCase.assertEquals((String)className, (String)this.types[i].getClassName());
            SimpleTypeTestCase.assertEquals((String)className, (String)this.types[i].getTypeName());
            SimpleTypeTestCase.assertEquals((String)className, (String)this.types[i].getDescription());
        }
    }

    public void testEquals() throws Exception {
        for (int i = 0; i < this.types.length; ++i) {
            for (int j = 0; j < this.types.length; ++j) {
                if (i == j) {
                    SimpleTypeTestCase.assertEquals((Object)this.types[i], (Object)this.types[j]);
                    continue;
                }
                SimpleTypeTestCase.assertTrue((String)("Simple Types should be different " + this.classes[i]), (this.types[i] != this.types[j] ? 1 : 0) != 0);
            }
        }
    }

    public void testIsValue() throws Exception {
        for (int i = 0; i < this.types.length; ++i) {
            for (int j = 0; j < this.types.length; ++j) {
                if (this.objects[i] == null) continue;
                if (i == j) {
                    SimpleTypeTestCase.assertTrue((String)(this.classes[i] + " should be a simple value of " + this.types[j]), (boolean)this.types[j].isValue(this.objects[i]));
                    continue;
                }
                SimpleTypeTestCase.assertTrue((String)(this.classes[i] + " should NOT be a simple value of " + this.types[j]), (!this.types[j].isValue(this.objects[i]) ? 1 : 0) != 0);
            }
            SimpleTypeTestCase.assertTrue((String)("null should NOT be a simple value of " + this.types[i]), (!this.types[i].isValue(null) ? 1 : 0) != 0);
        }
    }

    public void testHashCode() throws Exception {
        for (int i = 0; i < this.types.length; ++i) {
            SimpleTypeTestCase.assertEquals((int)this.classes[i].getName().hashCode(), (int)this.types[i].hashCode());
        }
    }

    public void testToString() throws Exception {
        for (int i = 0; i < this.types.length; ++i) {
            SimpleTypeTestCase.assertTrue((String)("Simple Type " + this.classes[i].getName() + " should contain " + (class$javax$management$openmbean$SimpleType == null ? SimpleTypeTestCase.class$("javax.management.openmbean.SimpleType") : class$javax$management$openmbean$SimpleType).getName()), (this.types[i].toString().indexOf((class$javax$management$openmbean$SimpleType == null ? SimpleTypeTestCase.class$("javax.management.openmbean.SimpleType") : class$javax$management$openmbean$SimpleType).getName()) != -1 ? 1 : 0) != 0);
            SimpleTypeTestCase.assertTrue((String)("Simple Type " + this.classes[i].getName() + " should contain " + this.classes[i].getName()), (this.types[i].toString().indexOf(this.classes[i].getName()) != -1 ? 1 : 0) != 0);
        }
    }

    public void testSerialization() throws Exception {
        for (int i = 0; i < this.types.length; ++i) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.types[i]);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            SimpleType result = (SimpleType)ois.readObject();
            SimpleTypeTestCase.assertTrue((String)("Should resolve to same object after serialization " + this.types[i]), (this.types[i] == result ? 1 : 0) != 0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            objectName = new ObjectName("test:test=test");
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }
}

