/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.openmbean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import junit.framework.TestCase;

public class OpenTypeTestCase
extends TestCase {
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$javax$management$openmbean$CompositeData;
    static /* synthetic */ Class class$javax$management$openmbean$TabularData;

    public OpenTypeTestCase(String s) {
        super(s);
    }

    public void testAllowedClasses() throws Exception {
        String[] allowedClassNames = OpenType.ALLOWED_CLASSNAMES;
        OpenTypeTestCase.assertEquals((int)16, (int)allowedClassNames.length);
        List<String> names = Arrays.asList(allowedClassNames);
        this.checkOpenType(names, class$java$lang$Void == null ? (class$java$lang$Void = OpenTypeTestCase.class$("java.lang.Void")) : class$java$lang$Void);
        this.checkOpenType(names, class$java$lang$Boolean == null ? (class$java$lang$Boolean = OpenTypeTestCase.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.checkOpenType(names, class$java$lang$Character == null ? (class$java$lang$Character = OpenTypeTestCase.class$("java.lang.Character")) : class$java$lang$Character);
        this.checkOpenType(names, class$java$lang$Byte == null ? (class$java$lang$Byte = OpenTypeTestCase.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.checkOpenType(names, class$java$lang$Short == null ? (class$java$lang$Short = OpenTypeTestCase.class$("java.lang.Short")) : class$java$lang$Short);
        this.checkOpenType(names, class$java$lang$Integer == null ? (class$java$lang$Integer = OpenTypeTestCase.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.checkOpenType(names, class$java$lang$Long == null ? (class$java$lang$Long = OpenTypeTestCase.class$("java.lang.Long")) : class$java$lang$Long);
        this.checkOpenType(names, class$java$lang$Float == null ? (class$java$lang$Float = OpenTypeTestCase.class$("java.lang.Float")) : class$java$lang$Float);
        this.checkOpenType(names, class$java$lang$Double == null ? (class$java$lang$Double = OpenTypeTestCase.class$("java.lang.Double")) : class$java$lang$Double);
        this.checkOpenType(names, class$java$lang$String == null ? (class$java$lang$String = OpenTypeTestCase.class$("java.lang.String")) : class$java$lang$String);
        this.checkOpenType(names, class$java$util$Date == null ? (class$java$util$Date = OpenTypeTestCase.class$("java.util.Date")) : class$java$util$Date);
        this.checkOpenType(names, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = OpenTypeTestCase.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        this.checkOpenType(names, class$java$math$BigInteger == null ? (class$java$math$BigInteger = OpenTypeTestCase.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        this.checkOpenType(names, class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = OpenTypeTestCase.class$("javax.management.ObjectName")) : class$javax$management$ObjectName);
        this.checkOpenType(names, class$javax$management$openmbean$CompositeData == null ? (class$javax$management$openmbean$CompositeData = OpenTypeTestCase.class$("javax.management.openmbean.CompositeData")) : class$javax$management$openmbean$CompositeData);
        this.checkOpenType(names, class$javax$management$openmbean$TabularData == null ? (class$javax$management$openmbean$TabularData = OpenTypeTestCase.class$("javax.management.openmbean.TabularData")) : class$javax$management$openmbean$TabularData);
    }

    public void testConstructorSimple() throws Exception {
        MyOpenType test = new MyOpenType("java.lang.Void", "type", "description");
        OpenTypeTestCase.assertEquals((String)"java.lang.Void", (String)test.getClassName());
        OpenTypeTestCase.assertEquals((String)"type", (String)test.getTypeName());
        OpenTypeTestCase.assertEquals((String)"description", (String)test.getDescription());
        OpenTypeTestCase.assertEquals((boolean)false, (boolean)test.isArray());
    }

    public void testConstructorArray() throws Exception {
        MyOpenType test = new MyOpenType("[[Ljava.lang.Void;", "type", "description");
        OpenTypeTestCase.assertEquals((String)"[[Ljava.lang.Void;", (String)test.getClassName());
        OpenTypeTestCase.assertEquals((String)"type", (String)test.getTypeName());
        OpenTypeTestCase.assertEquals((String)"description", (String)test.getDescription());
        OpenTypeTestCase.assertEquals((boolean)true, (boolean)test.isArray());
    }

    public void testSerializationSimple() throws Exception {
        this.testSerialization("java.lang.Void", "type", "description");
    }

    public void testSerializationArray() throws Exception {
        this.testSerialization("[[Ljava.lang.Void;", "type", "description");
    }

    public void testErrors() throws Exception {
        boolean caught = false;
        try {
            new MyOpenType(null, "dummy", "dummy");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"className cannot be null", (boolean)caught);
        caught = false;
        try {
            new MyOpenType("", "dummy", "dummy");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"className cannot be empty", (boolean)caught);
        caught = false;
        try {
            new MyOpenType("java.lang.Void", null, "dummy");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"typeName cannot be null", (boolean)caught);
        caught = false;
        try {
            new MyOpenType("java.lang.Void", null, "dummy");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"typeName cannot be empty", (boolean)caught);
        caught = false;
        try {
            new MyOpenType("java.lang.Void", "dummy", null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"description cannot be null", (boolean)caught);
        caught = false;
        try {
            new MyOpenType("java.lang.Void", "dummy", "");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"description cannot be empty", (boolean)caught);
        caught = false;
        try {
            new MyOpenType("java.lang.Class", "dummy", "dummy");
        }
        catch (OpenDataException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"className must be an OpenDataType", (boolean)caught);
        caught = false;
        try {
            new MyOpenType("[Ljava.lang.Void", "dummy", "dummy");
        }
        catch (OpenDataException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"[Ljava.lang.Void is not a valid array", (boolean)caught);
    }

    public void testErrors2() throws Exception {
        boolean caught = false;
        try {
            new MyOpenType("[L", "dummy", "dummy");
        }
        catch (StringIndexOutOfBoundsException e) {
            OpenTypeTestCase.fail((String)"FAILS IN RI: [L open type should be an OpenDataException not a StringIndexOutOfBoundsException");
        }
        catch (OpenDataException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"[L is not a valid array", (boolean)caught);
    }

    public void testErrors3() throws Exception {
        boolean caught = false;
        try {
            new MyOpenType("[Xjava.lang.Void;", "dummy", "dummy");
        }
        catch (OpenDataException e) {
            caught = true;
        }
        OpenTypeTestCase.assertTrue((String)"FAILS IN RI: [Xjava.lang.Void; is not a valid array", (boolean)caught);
    }

    private void checkOpenType(List names, Class clazz) throws Exception {
        String name = clazz.getName();
        OpenTypeTestCase.assertTrue((String)(name + " is an OpenType"), (boolean)names.contains(name));
        new MyOpenType(name, "dummy", "dummy");
        new MyOpenType("[L" + name + ";", "dummy", "dummy");
        new MyOpenType("[[[[[L" + name + ";", "dummy", "dummy");
    }

    private void testSerialization(String className, String type, String description) throws Exception {
        MyOpenType original = new MyOpenType(className, type, description);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(original);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        OpenType result = (OpenType)ois.readObject();
        OpenTypeTestCase.assertEquals((String)original.getClassName(), (String)result.getClassName());
        OpenTypeTestCase.assertEquals((String)original.getTypeName(), (String)result.getTypeName());
        OpenTypeTestCase.assertEquals((String)original.getDescription(), (String)result.getDescription());
        OpenTypeTestCase.assertEquals((boolean)original.isArray(), (boolean)result.isArray());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MyOpenType
    extends OpenType {
        public MyOpenType(String className, String typeName, String description) throws OpenDataException {
            super(className, typeName, description);
        }

        public boolean equals(Object other) {
            throw new UnsupportedOperationException("irrelevent");
        }

        public int hashCode() {
            throw new UnsupportedOperationException("irrelevent");
        }

        public boolean isValue(Object other) {
            throw new UnsupportedOperationException("irrelevent");
        }

        public String toString() {
            throw new UnsupportedOperationException("irrelevent");
        }
    }
}

