/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.objectname;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MalformedSUITE
extends TestSuite {
    public static final String GOOD_DOMAIN = "domain";
    public static final String GOOD_KEY = "key1";
    public static final String GOOD_VALUE = "val1";
    public static final String[] BAD_KEYS = new String[]{"", "som:thing", "som?thing", "som*thing", "som,thing", "som=thing", "som\nthing"};
    public static final String[] BAD_VALS = new String[]{"som:thing", "som?thing", "som*thing", "som,thing", "som=thing", "som\nthing", "som\"thing", "som\"\\b\"thing", "som\"\n\"thing", "som\"\"\"thing", "som\"?\"thing", "som\"*\"thing"};
    public static final String[] BAD_DOMAINS = new String[]{"doma:in", "doma\nin"};
    public static final String[] BAD_FULLNAMES = new String[]{"domain:key=val,key=val2", "domain:=,foo=bar", "domain:key=val,,foo=bar", "domain:,key=val,foo=bar", "domain:key=val,foo=bar,", "domain:key=val,   ,foo=bar", "domain:key=val,*,*", "domain:*,key=val,*", "domain:*,key1=val1,*,key2=val2", "domain: *,key1=val1,key2=val2", "domain:key1=val1,key2=val2, *", "domain:key1=val1,key2=val2,* ", "domain:", null};
    static /* synthetic */ Class class$test$compliance$objectname$MalformedSUITE$DomainHashtableExtraTEST;

    public static void main(String[] args) {
        TestRunner.run((Test)MalformedSUITE.suite());
    }

    public static Test suite() {
        int i;
        TestSuite suite = new TestSuite("All Malformed Tests");
        suite.addTest((Test)new DomainKeyValueTEST(null, null, null));
        suite.addTest((Test)new DomainKeyValueTEST(null, GOOD_KEY, GOOD_VALUE));
        suite.addTest((Test)new DomainKeyValueTEST(GOOD_DOMAIN, null, GOOD_VALUE));
        suite.addTest((Test)new DomainKeyValueTEST(GOOD_DOMAIN, GOOD_KEY, null));
        suite.addTest((Test)new DomainKeyValueTEST(GOOD_DOMAIN, null, null));
        suite.addTest((Test)new DomainHashtableTEST(null, GOOD_KEY, GOOD_VALUE));
        suite.addTestSuite(class$test$compliance$objectname$MalformedSUITE$DomainHashtableExtraTEST == null ? (class$test$compliance$objectname$MalformedSUITE$DomainHashtableExtraTEST = MalformedSUITE.class$("test.compliance.objectname.MalformedSUITE$DomainHashtableExtraTEST")) : class$test$compliance$objectname$MalformedSUITE$DomainHashtableExtraTEST);
        for (i = 0; i < BAD_DOMAINS.length; ++i) {
            suite.addTest((Test)new FullNameTEST(BAD_DOMAINS[i] + ":" + GOOD_KEY + "=" + GOOD_VALUE));
            suite.addTest((Test)new DomainKeyValueTEST(BAD_DOMAINS[i], GOOD_KEY, GOOD_VALUE));
            suite.addTest((Test)new DomainHashtableTEST(BAD_DOMAINS[i], GOOD_KEY, GOOD_VALUE));
        }
        for (i = 0; i < BAD_KEYS.length; ++i) {
            suite.addTest((Test)new FullNameTEST("domain:" + BAD_KEYS[i] + "=" + GOOD_VALUE));
            suite.addTest((Test)new DomainKeyValueTEST(GOOD_DOMAIN, BAD_KEYS[i], GOOD_VALUE));
            suite.addTest((Test)new DomainHashtableTEST(GOOD_DOMAIN, BAD_KEYS[i], GOOD_VALUE));
        }
        for (i = 0; i < BAD_VALS.length; ++i) {
            suite.addTest((Test)new FullNameTEST("domain:key1=" + BAD_VALS[i]));
            suite.addTest((Test)new DomainKeyValueTEST(GOOD_DOMAIN, GOOD_KEY, BAD_VALS[i]));
            suite.addTest((Test)new DomainHashtableTEST(GOOD_DOMAIN, GOOD_KEY, BAD_VALS[i]));
        }
        for (i = 0; i < BAD_FULLNAMES.length; ++i) {
            suite.addTest((Test)new FullNameTEST(BAD_FULLNAMES[i]));
        }
        return suite;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DomainHashtableExtraTEST
    extends TestCase {
        public DomainHashtableExtraTEST(String s) {
            super(s);
        }

        public void testNullDomain() {
            Hashtable<Object, String> h = new Hashtable<Object, String>();
            h.put(new Object(), MalformedSUITE.GOOD_VALUE);
            this.doCheck(null, h, "<null domain>", true);
        }

        public void testNullHashtable() {
            this.doCheck(MalformedSUITE.GOOD_DOMAIN, null, "<null hashtable>", true);
        }

        public void testEmptyHashtable() {
            this.doCheck(MalformedSUITE.GOOD_DOMAIN, new Hashtable(), "<empty_hashtable>", false);
        }

        public void testNonStringKey() {
            Hashtable<Object, String> h = new Hashtable<Object, String>();
            h.put(new Object(), MalformedSUITE.GOOD_VALUE);
            this.doCheck(MalformedSUITE.GOOD_DOMAIN, h, "<non_string_key>=val1", false);
        }

        public void testNonStringValue() {
            Hashtable<String, Object> h = new Hashtable<String, Object>();
            h.put(MalformedSUITE.GOOD_KEY, new Object());
            this.doCheck(MalformedSUITE.GOOD_DOMAIN, h, "key1=<non_string_value>", false);
        }

        private void doCheck(String domain, Hashtable h, String failureHint, boolean expectNull) {
            boolean caught;
            block11: {
                ObjectName name;
                block10: {
                    caught = true;
                    try {
                        name = new ObjectName(domain, h);
                    }
                    catch (MalformedObjectNameException e) {
                        caught = true;
                        if (expectNull) {
                            DomainHashtableExtraTEST.fail((String)("FAILS IN RI: Expected a NullPointerException for: " + domain + ":" + failureHint));
                        }
                    }
                    catch (NullPointerException e) {
                        if (expectNull) break block10;
                        DomainHashtableExtraTEST.fail((String)("unexpected a NullPointerException for: " + domain + ":" + failureHint));
                    }
                }
                if (!caught) {
                    DomainHashtableExtraTEST.fail((String)("expected a MalformedObjectNameException for: " + domain + ":" + failureHint));
                }
                caught = true;
                try {
                    name = ObjectName.getInstance(domain, h);
                }
                catch (MalformedObjectNameException e) {
                    caught = true;
                    if (expectNull) {
                        DomainHashtableExtraTEST.fail((String)("FAILS IN RI: Expected a NullPointerException for: " + domain + ":" + failureHint));
                    }
                }
                catch (NullPointerException e) {
                    if (expectNull) break block11;
                    DomainHashtableExtraTEST.fail((String)("unexpected a NullPointerException for: " + domain + ":" + failureHint));
                }
            }
            if (!caught) {
                DomainHashtableExtraTEST.fail((String)("expected a MalformedObjectNameException for: " + domain + ":" + failureHint));
            }
        }
    }

    public static class DomainHashtableTEST
    extends TestCase {
        private String domain;
        private String key;
        private String value;

        public DomainHashtableTEST(String domain, String key, String value) {
            super("testMalformed");
            this.domain = domain;
            this.key = key;
            this.value = value;
        }

        public void testMalformed() {
            boolean caught;
            block11: {
                Hashtable<String, String> h;
                block10: {
                    caught = false;
                    try {
                        h = new Hashtable<String, String>();
                        h.put(this.key, this.value);
                        ObjectName name = new ObjectName(this.domain, h);
                    }
                    catch (MalformedObjectNameException e) {
                        caught = true;
                    }
                    catch (NullPointerException e) {
                        caught = true;
                        if (this.domain == null || this.key == null || this.value == null) break block10;
                        DomainHashtableTEST.fail((String)("Unexpected NullPointerException for " + this.domain + ":" + this.key + "=" + this.value));
                    }
                }
                if (!caught) {
                    if (this.value != null && (this.value.equals("som\"thing") || this.value.equals("som\"\\b\"thing") || this.value.equals("som\"\"\"thing"))) {
                        DomainHashtableTEST.fail((String)("FAILS IN RI: expected a MalformedObjectNameException for: " + this.domain + ":" + this.key + "=" + this.value));
                    }
                    DomainHashtableTEST.fail((String)("expected a MalformedObjectNameException for: " + this.domain + ":" + this.key + "=" + this.value));
                }
                caught = false;
                try {
                    h = new Hashtable();
                    h.put(this.key, this.value);
                    ObjectName objectName = ObjectName.getInstance(this.domain, h);
                }
                catch (MalformedObjectNameException e) {
                    caught = true;
                }
                catch (NullPointerException e) {
                    caught = true;
                    if (this.domain == null || this.key == null || this.value == null) break block11;
                    DomainHashtableTEST.fail((String)("Unexpected NullPointerException for " + this.domain + ":" + this.key + "=" + this.value));
                }
            }
            if (!caught) {
                if (this.value != null && (this.value.equals("som\"thing") || this.value.equals("som\"\\b\"thing") || this.value.equals("som\"\"\"thing"))) {
                    DomainHashtableTEST.fail((String)("FAILS IN RI: expected a MalformedObjectNameException for: " + this.domain + ":" + this.key + "=" + this.value));
                }
                DomainHashtableTEST.fail((String)("expected a MalformedObjectNameException for: " + this.domain + ":" + this.key + "=" + this.value));
            }
        }
    }

    public static class DomainKeyValueTEST
    extends TestCase {
        private String domain;
        private String key;
        private String value;

        public DomainKeyValueTEST(String domain, String key, String value) {
            super("testMalformed");
            this.domain = domain;
            this.key = key;
            this.value = value;
        }

        public void testMalformed() {
            boolean caught;
            block11: {
                ObjectName name;
                block10: {
                    caught = false;
                    try {
                        name = new ObjectName(this.domain, this.key, this.value);
                    }
                    catch (MalformedObjectNameException e) {
                        caught = true;
                    }
                    catch (NullPointerException e) {
                        caught = true;
                        if (this.domain == null || this.key == null || this.value == null) break block10;
                        DomainKeyValueTEST.fail((String)("Unexpected NullPointerException for " + this.domain + ":" + this.key + "=" + this.value));
                    }
                }
                if (!caught) {
                    if (this.value != null && (this.value.equals("som\"thing") || this.value.equals("som\"\\b\"thing") || this.value.equals("som\"\"\"thing"))) {
                        DomainKeyValueTEST.fail((String)("FAILS IN RI: expected a MalformedObjectNameException for: " + this.domain + ":" + this.key + "=" + this.value));
                    }
                    DomainKeyValueTEST.fail((String)("expected a MalformedObjectNameException for: " + this.domain + ":" + this.key + "=" + this.value));
                }
                caught = false;
                try {
                    name = ObjectName.getInstance(this.domain, this.key, this.value);
                }
                catch (MalformedObjectNameException e) {
                    caught = true;
                }
                catch (NullPointerException e) {
                    caught = true;
                    if (this.domain == null || this.key == null || this.value == null) break block11;
                    DomainKeyValueTEST.fail((String)("Unexpected NullPointerException for " + this.domain + ":" + this.key + "=" + this.value));
                }
            }
            if (!caught) {
                if (this.value != null && (this.value.equals("som\"thing") || this.value.equals("som\"\\b\"thing") || this.value.equals("som\"\"\"thing"))) {
                    DomainKeyValueTEST.fail((String)("FAILS IN RI: expected a MalformedObjectNameException for: " + this.domain + ":" + this.key + "=" + this.value));
                }
                DomainKeyValueTEST.fail((String)("expected a MalformedObjectNameException for: " + this.domain + ":" + this.key + "=" + this.value));
            }
        }
    }

    public static class FullNameTEST
    extends TestCase {
        private String fullName;

        public FullNameTEST(String fullName) {
            super("testMalformed");
            this.fullName = fullName;
        }

        public void testMalformed() {
            boolean caught;
            block11: {
                ObjectName name;
                block10: {
                    caught = false;
                    try {
                        name = new ObjectName(this.fullName);
                    }
                    catch (MalformedObjectNameException e) {
                        caught = true;
                    }
                    catch (NullPointerException e) {
                        caught = true;
                        if (this.fullName == null) break block10;
                        FullNameTEST.fail((String)("Unexpected NullPointerException for " + this.fullName));
                    }
                }
                if (!caught) {
                    if (this.fullName != null && (this.fullName.equals("domain:=val1") || this.fullName.equals("domain:=,foo=bar"))) {
                        FullNameTEST.fail((String)("FAILS IN RI: expected a MalformedObjectNameException for: " + this.fullName));
                    }
                    FullNameTEST.fail((String)("expected a MalformedObjectNameException for: " + this.fullName));
                }
                caught = false;
                try {
                    name = ObjectName.getInstance(this.fullName);
                }
                catch (MalformedObjectNameException e) {
                    caught = true;
                }
                catch (NullPointerException e) {
                    caught = true;
                    if (this.fullName == null) break block11;
                    FullNameTEST.fail((String)("Unexpected NullPointerException for " + this.fullName));
                }
            }
            if (!caught) {
                if (this.fullName != null && (this.fullName.equals("domain:=val1") || this.fullName.equals("domain:=,foo=bar"))) {
                    FullNameTEST.fail((String)("FAILS IN RI: expected a MalformedObjectNameException for: " + this.fullName));
                }
                FullNameTEST.fail((String)("expected a MalformedObjectNameException for: " + this.fullName));
            }
        }
    }
}

