/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.objectname;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class CanonicalTEST
extends TestCase {
    public static final String EXPECTED_NAME = "domain:a=a,b=b,c=c,d=d,e=e";
    public static final String[] KVP = new String[]{"a", "b", "c", "d", "e"};

    public CanonicalTEST(String s) {
        super(s);
    }

    public void testBasicCanonical() {
        try {
            ObjectName name = new ObjectName("domain:e=e,b=b,d=d,c=c,a=a");
            CanonicalTEST.assertEquals((String)EXPECTED_NAME, (String)name.getCanonicalName());
        }
        catch (MalformedObjectNameException e) {
            CanonicalTEST.fail((String)"spurious MalformedObjectNameException");
        }
    }

    public void testHashtableCanonical() {
        try {
            Hashtable<String, String> h = new Hashtable<String, String>();
            for (int i = 0; i < KVP.length; ++i) {
                h.put(KVP[i], KVP[i]);
            }
            ObjectName name = new ObjectName("domain", h);
            CanonicalTEST.assertEquals((String)EXPECTED_NAME, (String)name.getCanonicalName());
        }
        catch (MalformedObjectNameException e) {
            CanonicalTEST.fail((String)"spurious MalformedObjectNameException");
        }
    }

    public void testSingleKVP() {
        try {
            ObjectName name = new ObjectName("domain", "a", "a");
            CanonicalTEST.assertEquals((String)"domain:a=a", (String)name.getCanonicalName());
        }
        catch (MalformedObjectNameException e) {
            CanonicalTEST.fail((String)"spurious MalformedObjectNameException");
        }
    }
}

