/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.objectname;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class BasicTEST
extends TestCase {
    public static final String STD_DOMAIN = "domain";
    public static final String WHITESPACE = " ";
    public static final String COMMA = ",";
    public static final String EQUALS = "=";
    public static final String COLON = ":";
    public static final String EMPTY = "";
    public static final String ASTERISK = "*";
    public static final String QUESTION = "?";
    public static final String QUOTE = "\"";
    public static final String ESCAPE = "\\";
    public static final String STD_KEYPROP_STRING = "key1=val1,key2=val2";
    public static final String REV_KEYPROP_STRING = "key2=val2,key1=val1";
    public static final String KEY1 = "key1";
    public static final String KEY2 = "key2";
    public static final String VAL1 = "val1";
    public static final String VAL2 = "val2";
    public static final int JMX1_0 = 0;
    public static final int JMX1_2 = 1;
    public static final int QUOTED = 100;
    public static final int QUOTEDBACKSLASH = 101;

    public BasicTEST(String s) {
        super(s);
    }

    public void testStringNoDomain() {
        String nameArg = ":key1=val1,key2=val2";
        try {
            ObjectName name = new ObjectName(nameArg);
            String domain = name.getDomain();
            if (null == domain) {
                BasicTEST.fail((String)"getDomain() should return empty string rather than null");
            }
            BasicTEST.assertTrue((String)"domain should have been zero size", (domain.length() == 0 ? 1 : 0) != 0);
            BasicTEST.assertEquals((String)"value for key: key1 should be: val1", (String)VAL1, (String)name.getKeyProperty(KEY1));
            BasicTEST.assertEquals((String)"value for key: key2 should be: val2", (String)VAL2, (String)name.getKeyProperty(KEY2));
        }
        catch (MalformedObjectNameException e) {
            BasicTEST.fail((String)("spurious MalformedObjectNameException on ('" + nameArg + "')"));
        }
    }

    public void testStringWithDomain() {
        String nameArg = "domain:key1=val1,key2=val2";
        try {
            ObjectName name = new ObjectName(nameArg);
            BasicTEST.assertEquals((String)"domain should be equivalent", (String)STD_DOMAIN, (String)name.getDomain());
            BasicTEST.assertEquals((String)"value for key: key1 should be: val1", (String)VAL1, (String)name.getKeyProperty(KEY1));
            BasicTEST.assertEquals((String)"value for key: key2 should be: val2", (String)VAL2, (String)name.getKeyProperty(KEY2));
        }
        catch (MalformedObjectNameException e) {
            BasicTEST.fail((String)("spurious MalformedObjectNameException on ('" + nameArg + "')"));
        }
    }

    public void testSingleKVP() {
        try {
            ObjectName name = new ObjectName(STD_DOMAIN, KEY1, VAL1);
            BasicTEST.assertEquals((String)"domain should be equivalent", (String)STD_DOMAIN, (String)name.getDomain());
            BasicTEST.assertEquals((String)"value for key: key1 should be: val1", (String)VAL1, (String)name.getKeyProperty(KEY1));
            BasicTEST.assertNull((String)"should return NULL key property for: key2", (Object)name.getKeyProperty(KEY2));
            String kplistString = name.getKeyPropertyListString();
            if (null == kplistString) {
                BasicTEST.fail((String)"key property list string was null;");
            }
            BasicTEST.assertTrue((String)"KeyPropertyListString should match", (boolean)kplistString.equals("key1=val1"));
        }
        catch (MalformedObjectNameException e) {
            BasicTEST.fail((String)"spurious MalformedObjectNameException on ('domain','key1','val1')");
        }
    }

    public void testHashtable() {
        try {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put(KEY1, VAL1);
            properties.put(KEY2, VAL2);
            ObjectName name = new ObjectName(STD_DOMAIN, properties);
            BasicTEST.assertEquals((String)"domain should be equivalent", (String)STD_DOMAIN, (String)name.getDomain());
            BasicTEST.assertEquals((String)"value for key: key1 should be: val1", (String)VAL1, (String)name.getKeyProperty(KEY1));
            BasicTEST.assertEquals((String)"value for key: key2 should be: val2", (String)VAL2, (String)name.getKeyProperty(KEY2));
            String kplistString = name.getKeyPropertyListString();
            if (null == kplistString) {
                BasicTEST.fail((String)"key property list string was null;");
            }
            BasicTEST.assertTrue((String)"KeyPropertyListString should match", (kplistString.equals(STD_KEYPROP_STRING) || kplistString.equals(REV_KEYPROP_STRING) ? 1 : 0) != 0);
        }
        catch (MalformedObjectNameException e) {
            BasicTEST.fail((String)"spurious MalformedObjectNameException on ('domain','key1','val1')");
        }
    }

    public void testWhitespaceDomain() {
        this.domainTest(WHITESPACE, 0);
    }

    public void testCommaDomain() {
        this.domainTest(COMMA, 1);
    }

    public void testEqualsDomain() {
        this.domainTest(EQUALS, 1);
    }

    public void testQuestionValue() {
        this.valueTest(QUESTION, 101);
    }

    public void testAsteriskValue() {
        this.valueTest(ASTERISK, 101);
    }

    public void testQuoteValue() {
        this.valueTest(QUOTE, 101);
    }

    public void testEqualsValue() {
        this.valueTest(EQUALS, 100);
    }

    public void testCommaValue() {
        this.valueTest(COMMA, 100);
    }

    public void testColonValue() {
        this.valueTest(COLON, 100);
    }

    public void testEscapeValue() {
        this.valueTest(ESCAPE, 101);
        this.valueTest(ESCAPE, 0);
    }

    public void testEmptyQuotesValue() {
        this.valueTest("\"\"", 0);
    }

    public void testKeyPropertyList() {
        String nameArg = ":key1=val1,key2=val2";
        try {
            ObjectName name = new ObjectName(nameArg);
            String kplistString = name.getKeyPropertyListString();
            if (null == kplistString) {
                BasicTEST.fail((String)"key property list string was null;");
            }
            BasicTEST.assertTrue((String)"KeyPropertyListString should match", (kplistString.equals(STD_KEYPROP_STRING) || kplistString.equals(REV_KEYPROP_STRING) ? 1 : 0) != 0);
        }
        catch (MalformedObjectNameException e) {
            BasicTEST.fail((String)("spurious MalformedObjectNameException on ('" + nameArg + "')"));
        }
    }

    public void testToString() {
        String nameArg1 = ":key1=val1";
        String nameArg2 = "domain:key1=val1";
        try {
            ObjectName name1 = new ObjectName(nameArg1);
            BasicTEST.assertEquals((String)"toString should match", (String)nameArg1, (String)name1.toString());
        }
        catch (MalformedObjectNameException e) {
            BasicTEST.fail((String)("spurious MalformedObjectNameException on ('" + nameArg1 + "')"));
        }
        try {
            ObjectName name2 = new ObjectName(nameArg2);
            BasicTEST.assertEquals((String)"toString should match", (String)nameArg2, (String)name2.toString());
        }
        catch (MalformedObjectNameException e) {
            BasicTEST.fail((String)("spurious MalformedObjectNameException on ('" + nameArg2 + "')"));
        }
    }

    private void domainTest(String domain, int version) {
        ObjectName name;
        String nameArg = domain + COLON + STD_KEYPROP_STRING;
        try {
            name = new ObjectName(nameArg);
            BasicTEST.assertEquals((String)"domain should be equivalent", (String)domain, (String)name.getDomain());
        }
        catch (MalformedObjectNameException e) {
            if (version == 1) {
                BasicTEST.fail((String)("spurious MalformedObjectNameException on ('" + nameArg + "') as of JMX 1.2 " + domain + " is allowed in a domain"));
            }
            BasicTEST.fail((String)("spurious MalformedObjectNameException on ('" + nameArg + "')"));
        }
        try {
            name = new ObjectName(domain, KEY1, VAL1);
            BasicTEST.assertEquals((String)"domain should be equivalent", (String)domain, (String)name.getDomain());
        }
        catch (MalformedObjectNameException e) {
            if (version == 1) {
                BasicTEST.fail((String)("spurious MalformedObjectNameException on ('" + domain + "','" + KEY1 + "','" + VAL1 + "') as of JMX 1.2 " + domain + " is allowed in a domain"));
            }
            BasicTEST.fail((String)("spurious MalformedObjectNameException on ('" + domain + "','" + KEY1 + "','" + VAL1 + "')"));
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        try {
            table.put(KEY1, VAL1);
            ObjectName name2 = new ObjectName(domain, table);
            BasicTEST.assertEquals((String)"domain should be equivalent", (String)domain, (String)name2.getDomain());
        }
        catch (MalformedObjectNameException e) {
            if (version == 1) {
                BasicTEST.fail((String)("spurious MalformedObjectNameException on ('" + domain + WHITESPACE + table + "') as of JMX 1.2 " + domain + " is allowed in a domain"));
            }
            BasicTEST.fail((String)("spurious MalformedObjectNameException on ('" + domain + WHITESPACE + table + "')"));
        }
    }

    public void valueTest(String value, int type) {
        String name = null;
        name = type == 101 ? "domain:key1=\"\\" + value + QUOTE : (type == 100 ? "domain:key1=\"" + value + QUOTE : "domain:key1=" + value);
        try {
            ObjectName result = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            if (type == 101) {
                BasicTEST.fail((String)("spurious MalformedObjectNameException on ('" + name + "') as of JMX 1.2 " + value + " is allowed inside quotes escaped by a backslash"));
            }
            if (type == 100) {
                BasicTEST.fail((String)("spurious MalformedObjectNameException on ('" + name + "') as of JMX 1.2 " + value + " is allowed inside quotes"));
            }
            BasicTEST.fail((String)("FAILS IN RI: spurious MalformedObjectNameException on ('" + name + "')"));
        }
        String test = null;
        test = type == 101 ? "\"\\" + value + QUOTE : (type == 100 ? QUOTE + value + QUOTE : value);
        try {
            ObjectName result = new ObjectName(STD_DOMAIN, KEY1, test);
        }
        catch (MalformedObjectNameException e) {
            if (type == 101) {
                BasicTEST.fail((String)("spurious MalformedObjectNameException on ('domain','key1','" + value + "') as of JMX 1.2 " + STD_DOMAIN + " is allowed inside quotes escaped by a backslah"));
            }
            if (type == 100) {
                BasicTEST.fail((String)("spurious MalformedObjectNameException on ('domain','key1','" + value + "') as of JMX 1.2 " + STD_DOMAIN + " is allowed inside quotes"));
            }
            BasicTEST.fail((String)("spurious MalformedObjectNameException on ('domain','key1','" + value + "')"));
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (type == 101) {
            table.put(KEY1, "\"\\" + value + QUOTE);
        } else if (type == 100) {
            table.put(KEY1, QUOTE + value + QUOTE);
        } else {
            table.put(KEY1, value);
        }
        try {
            ObjectName result = new ObjectName(STD_DOMAIN, table);
        }
        catch (MalformedObjectNameException e) {
            if (type == 101) {
                BasicTEST.fail((String)("spurious MalformedObjectNameException on ('domain " + table + "') as of JMX 1.2 " + STD_DOMAIN + " is allowed inside quotes escaped by a backslah"));
            }
            if (type == 100) {
                BasicTEST.fail((String)("spurious MalformedObjectNameException on ('domain " + table + "') as of JMX 1.2 " + STD_DOMAIN + " is allowed inside quotes"));
            }
            BasicTEST.fail((String)("spurious MalformedObjectNameException on ('domain " + table + "')"));
        }
    }
}

