/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.notification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import junit.framework.TestCase;

public class NotificationFilterSupportTestCase
extends TestCase {
    Notification n1 = new Notification("type1", new Object(), 1L);
    Notification n2 = new Notification("type1", new Object(), 2L);
    Notification n3 = new Notification("type1plus", new Object(), 3L);
    Notification n4 = new Notification("type2", new Object(), 4L);
    Notification n5 = new Notification("type2", new Object(), 5L);

    public NotificationFilterSupportTestCase(String s) {
        super(s);
    }

    public void testDefault() {
        NotificationFilterSupport nfs = new NotificationFilterSupport();
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n1));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n2));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n3));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n4));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n5));
    }

    public void testEnableType() {
        NotificationFilterSupport nfs = new NotificationFilterSupport();
        nfs.enableType("type1plus");
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n1));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n2));
        NotificationFilterSupportTestCase.assertEquals((boolean)true, (boolean)nfs.isNotificationEnabled(this.n3));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n4));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n5));
    }

    public void testDisableAllTypes() {
        NotificationFilterSupport nfs = new NotificationFilterSupport();
        nfs.enableType("type1");
        nfs.enableType("type2");
        nfs.disableAllTypes();
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n1));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n2));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n3));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n4));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n5));
    }

    public void testDisableType() {
        NotificationFilterSupport nfs = new NotificationFilterSupport();
        nfs.enableType("type1");
        nfs.enableType("type2");
        nfs.disableType("type1");
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n1));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n2));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n3));
        NotificationFilterSupportTestCase.assertEquals((boolean)true, (boolean)nfs.isNotificationEnabled(this.n4));
        NotificationFilterSupportTestCase.assertEquals((boolean)true, (boolean)nfs.isNotificationEnabled(this.n5));
    }

    public void testPrefix() {
        NotificationFilterSupport nfs = new NotificationFilterSupport();
        nfs.enableType("type1");
        NotificationFilterSupportTestCase.assertEquals((boolean)true, (boolean)nfs.isNotificationEnabled(this.n1));
        NotificationFilterSupportTestCase.assertEquals((boolean)true, (boolean)nfs.isNotificationEnabled(this.n2));
        NotificationFilterSupportTestCase.assertEquals((boolean)true, (boolean)nfs.isNotificationEnabled(this.n3));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n4));
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)nfs.isNotificationEnabled(this.n5));
    }

    public void testGetEnabledTypes() {
        NotificationFilterSupport nfs = new NotificationFilterSupport();
        NotificationFilterSupportTestCase.assertEquals((int)0, (int)nfs.getEnabledTypes().size());
        nfs.enableType("type1");
        nfs.enableType("type2");
        Vector<String> v = nfs.getEnabledTypes();
        NotificationFilterSupportTestCase.assertEquals((int)2, (int)v.size());
        NotificationFilterSupportTestCase.assertEquals((boolean)true, (boolean)v.contains("type1"));
        NotificationFilterSupportTestCase.assertEquals((boolean)true, (boolean)v.contains("type2"));
        nfs.disableType("type1");
        v = nfs.getEnabledTypes();
        NotificationFilterSupportTestCase.assertEquals((int)1, (int)v.size());
        NotificationFilterSupportTestCase.assertEquals((boolean)false, (boolean)v.contains("type1"));
        NotificationFilterSupportTestCase.assertEquals((boolean)true, (boolean)v.contains("type2"));
        nfs.enableType("type2");
        nfs.disableAllTypes();
        v = nfs.getEnabledTypes();
        NotificationFilterSupportTestCase.assertEquals((int)0, (int)v.size());
        nfs.enableType("type1");
        nfs.enableType("type1");
        v = nfs.getEnabledTypes();
        NotificationFilterSupportTestCase.assertEquals((int)1, (int)v.size());
        nfs.disableType("type1");
        v = nfs.getEnabledTypes();
        NotificationFilterSupportTestCase.assertEquals((int)0, (int)v.size());
    }

    public void testSerialization() {
        NotificationFilterSupport nfs = new NotificationFilterSupport();
        NotificationFilterSupport nfs2 = null;
        nfs.enableType("type1");
        nfs.enableType("type2");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(nfs);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            nfs2 = (NotificationFilterSupport)ois.readObject();
        }
        catch (IOException ioe) {
            NotificationFilterSupportTestCase.fail((String)ioe.toString());
        }
        catch (ClassNotFoundException cnfe) {
            NotificationFilterSupportTestCase.fail((String)cnfe.toString());
        }
        Vector<String> v = nfs2.getEnabledTypes();
        NotificationFilterSupportTestCase.assertEquals((int)2, (int)v.size());
        NotificationFilterSupportTestCase.assertEquals((boolean)true, (boolean)v.contains("type1"));
        NotificationFilterSupportTestCase.assertEquals((boolean)true, (boolean)v.contains("type2"));
    }
}

