/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.MBeanParameterInfo;
import junit.framework.TestCase;

public class MBeanParameterInfoTEST
extends TestCase {
    public MBeanParameterInfoTEST(String s) {
        super(s);
    }

    public void testMBeanParameterInfo() throws Exception {
        MBeanParameterInfo info = new MBeanParameterInfo("name", "type", "description");
        MBeanParameterInfoTEST.assertEquals((String)"name", (String)info.getName());
        MBeanParameterInfoTEST.assertEquals((String)"type", (String)info.getType());
        MBeanParameterInfoTEST.assertEquals((String)"description", (String)info.getDescription());
    }

    public void testHashCode() throws Exception {
        MBeanParameterInfo info1 = new MBeanParameterInfo("name", "type", "description");
        MBeanParameterInfo info2 = new MBeanParameterInfo("name", "type", "description");
        MBeanParameterInfoTEST.assertTrue((String)"Different instances with the same hashcode are equal", (info1.hashCode() == info2.hashCode() ? 1 : 0) != 0);
    }

    public void testEquals() throws Exception {
        MBeanParameterInfo info = new MBeanParameterInfo("name", "type", "description");
        MBeanParameterInfoTEST.assertTrue((String)"Null should not be equal", (!info.equals(null) ? 1 : 0) != 0);
        MBeanParameterInfoTEST.assertTrue((String)"Only MBeanParameterInfo should be equal", (!info.equals(new Object()) ? 1 : 0) != 0);
        MBeanParameterInfo info2 = new MBeanParameterInfo("name", "type", "description");
        MBeanParameterInfoTEST.assertTrue((String)"Different instances of the same data are equal", (boolean)info.equals(info2));
        MBeanParameterInfoTEST.assertTrue((String)"Different instances of the same data are equal", (boolean)info2.equals(info));
        info2 = new MBeanParameterInfo("name", "type", "description2");
        MBeanParameterInfoTEST.assertTrue((String)"Different instances with different descriptions are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanParameterInfoTEST.assertTrue((String)"Different instances with different descritpions are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanParameterInfo("name2", "type", "description");
        MBeanParameterInfoTEST.assertTrue((String)"Instances with different names are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanParameterInfoTEST.assertTrue((String)"Instances with different names are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanParameterInfo("name", "type2", "description");
        MBeanParameterInfoTEST.assertTrue((String)"Instances with different types are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanParameterInfoTEST.assertTrue((String)"Instances with different types are not equal", (!info2.equals(info) ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        MBeanParameterInfo info = new MBeanParameterInfo("name", "type", "description");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(info);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object result = ois.readObject();
        MBeanParameterInfoTEST.assertEquals((Object)info, (Object)result);
    }

    public void testErrors() throws Exception {
        MBeanParameterInfo info;
        boolean caught = false;
        try {
            info = new MBeanParameterInfo(null, "type", "description");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            MBeanParameterInfoTEST.fail((String)"Expected IllegalArgumentException for null name");
        }
        caught = false;
        try {
            info = new MBeanParameterInfo("", "type", "description");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            MBeanParameterInfoTEST.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            info = new MBeanParameterInfo("invalid name", "type", "description");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            MBeanParameterInfoTEST.fail((String)"Expected IllegalArgumentException for an 'invalid name'");
        }
        caught = false;
        try {
            info = new MBeanParameterInfo("name", null, "description");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            MBeanParameterInfoTEST.fail((String)"Expected IllegalArgumentException for null type");
        }
        caught = false;
        try {
            info = new MBeanParameterInfo("name", "", "description");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            MBeanParameterInfoTEST.fail((String)"Expected IllegalArgumentException for an empty type");
        }
        caught = false;
        try {
            info = new MBeanParameterInfo("name", "invalid type", "description");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            MBeanParameterInfoTEST.fail((String)"Expected IllegalArgumentException for an 'invalid type'");
        }
    }
}

