/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.loading;

import java.net.URL;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ServiceNotFoundException;
import javax.management.loading.MLet;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class MLetTEST
extends TestCase {
    private MBeanServer server;
    static /* synthetic */ Class class$java$lang$String;

    public MLetTEST(String s) {
        super(s);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.server = MBeanServerFactory.createMBeanServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateAndRegister() throws Exception {
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            this.server.registerMBean(mlet, name);
        }
        finally {
            this.server.unregisterMBean(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMLetLoadClassFromURLInConstructor() throws Exception {
        String MBEANS_URL = "file:./output/etc/test/compliance/loading/MyMBeans.jar";
        try {
            this.server.getClassLoaderRepository().loadClass("test.compliance.loading.support.Trivial");
            MLetTEST.fail((String)"class test.compliance.loading.support.Trivial was already found in CL repository.");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName name = new ObjectName("test:name=mlet");
        MLet mlet = new MLet(new URL[]{new URL("file:./output/etc/test/compliance/loading/MyMBeans.jar")});
        try {
            server.getClassLoaderRepository().loadClass("test.compliance.loading.support.Trivial");
            MLetTEST.fail((String)"class test.compliance.loading.support.Trivial found in CL repository after MLet construction.");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            server.registerMBean(mlet, name);
            server.getClassLoaderRepository().loadClass("test.compliance.loading.support.Trivial");
        }
        finally {
            server.unregisterMBean(name);
        }
        try {
            server.getClassLoaderRepository().loadClass("test.compliance.loading.support.Trivial");
            MLetTEST.fail((String)"class test.compliance.loading.support.Trivial was still found in CL repository.");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
    }

    public void testBasicMLetFileLoad() throws Exception {
        String MLET_URL = "file:./output/etc/test/compliance/loading/BasicConfig.mlet";
        try {
            this.server.getClassLoaderRepository().loadClass("test.compliance.loading.support.Trivial");
            MLetTEST.fail((String)"class test.compliance.loading.support.Trivial was already found in CL repository.");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            this.server.getClassLoaderRepository().loadClass("test.compliance.loading.support.Trivial2");
            MLetTEST.fail((String)"class test.compliance.loading.support.Trivial2 was already found in CL repository.");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        server.registerMBean(mlet, name);
        Set mbeans = (Set)server.invoke(name, "getMBeansFromURL", new Object[]{"file:./output/etc/test/compliance/loading/BasicConfig.mlet"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MLetTEST.class$("java.lang.String")) : class$java$lang$String).getName()});
        try {
            MLetTEST.assertTrue((boolean)server.isRegistered(new ObjectName("test:name=Trivial")));
            MLetTEST.assertTrue((boolean)server.isRegistered(new ObjectName("test:name=Trivial2")));
        }
        catch (AssertionFailedError e) {
            URL[] urls = mlet.getURLs();
            URL url = null;
            if (urls != null && urls.length > 0) {
                url = urls[0];
            }
            MLetTEST.fail((String)("FAILS IN RI: SUN JMX RI builds a malformed URL from an MLet text file URL 'file:./output/etc/test/compliance/loading/BasicConfig.mlet' resulting into MLET codebase URL '" + url + "' and therefore fails " + "to load the required classes from the Java archive (MyMBeans.jar)"));
        }
        MLetTEST.assertTrue((server.getMBeanInfo(new ObjectName("test:name=Trivial")) != null ? 1 : 0) != 0);
        MLetTEST.assertTrue((server.getMBeanInfo(new ObjectName("test:name=Trivial2")) != null ? 1 : 0) != 0);
        MLetTEST.assertTrue((boolean)server.getAttribute(new ObjectName("test:name=Trivial2"), "Something").equals("foo"));
        server.invoke(new ObjectName("test:name=Trivial"), "doOperation", new Object[]{"Test"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MLetTEST.class$("java.lang.String")) : class$java$lang$String).getName()});
        server.invoke(new ObjectName("test:name=Trivial2"), "doOperation", new Object[]{"Test"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MLetTEST.class$("java.lang.String")) : class$java$lang$String).getName()});
    }

    public void testConflictingMLetFileLoad() throws Exception {
        String MLET_URL1 = "file:./output/etc/test/compliance/loading/BasicConfig2.mlet";
        String MLET_URL2 = "file:./output/etc/test/compliance/loading/BasicConfig2.mlet";
        try {
            this.server.getClassLoaderRepository().loadClass("test.compliance.loading.support.Trivial3");
            MLetTEST.fail((String)"class test.compliance.loading.support.Trivial was already found in CL repository.");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            this.server.getClassLoaderRepository().loadClass("test.compliance.loading.support.Trivial4");
            MLetTEST.fail((String)"class test.compliance.loading.support.Trivial2 was already found in CL repository.");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        server.registerMBean(mlet, name);
        Set mbeans = (Set)server.invoke(name, "getMBeansFromURL", new Object[]{"file:./output/etc/test/compliance/loading/BasicConfig2.mlet"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MLetTEST.class$("java.lang.String")) : class$java$lang$String).getName()});
        ObjectName oname = new ObjectName("test:name=Trivial2");
        server.setAttribute(oname, new Attribute("Something", "Something"));
        mlet = new MLet();
        name = new ObjectName("test:name=mlet2");
        server.registerMBean(mlet, name);
        mbeans = (Set)server.invoke(name, "getMBeansFromURL", new Object[]{"file:./output/etc/test/compliance/loading/BasicConfig2.mlet"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MLetTEST.class$("java.lang.String")) : class$java$lang$String).getName()});
        oname = new ObjectName("test:name=Trivial2");
        String value = (String)server.getAttribute(oname, "Something");
        MLetTEST.assertTrue((boolean)value.equals("Something"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMalformedURLLoad() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            server.registerMBean(mlet, name);
            server.invoke(name, "getMBeansFromURL", new Object[]{"output/etc/test/compliance/loading/BasicConfig.mlet"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MLetTEST.class$("java.lang.String")) : class$java$lang$String).getName()});
            MLetTEST.fail((String)"FAILS IN RI: Malformed URL in getMBeansURL() should result in ServiceNotFoundException thrown.");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (MBeanException e) {
            MLetTEST.assertTrue((boolean)(e.getTargetException() instanceof ServiceNotFoundException));
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingMLetTagInLoad() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            server.registerMBean(mlet, name);
            server.invoke(name, "getMBeansFromURL", new Object[]{"file:./output/etc/test/compliance/loading/MissingMLET.mlet"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MLetTEST.class$("java.lang.String")) : class$java$lang$String).getName()});
            MLetTEST.fail((String)"MLet text file missing the MLET tag should result in ServiceNotFoundException thrown.");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (MBeanException e) {
            MLetTEST.assertTrue((boolean)(e.getTargetException() instanceof ServiceNotFoundException));
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingMandatoryArchiveTagInLoad() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            server.registerMBean(mlet, name);
            server.invoke(name, "getMBeansFromURL", new Object[]{"file:./output/etc/test/compliance/loading/MissingMandatoryArchive.mlet"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MLetTEST.class$("java.lang.String")) : class$java$lang$String).getName()});
            MLetTEST.fail((String)"MLet text file missing mandatory ARCHIVE attribute should result in ServiceNotFoundException thrown.");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (MBeanException e) {
            MLetTEST.assertTrue((boolean)(e.getTargetException() instanceof ServiceNotFoundException));
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingMandatoryCodeTagInLoad() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            server.registerMBean(mlet, name);
            server.invoke(name, "getMBeansFromURL", new Object[]{"file:./output/etc/test/compliance/loading/MissingMandatoryCode.mlet"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MLetTEST.class$("java.lang.String")) : class$java$lang$String).getName()});
            MLetTEST.fail((String)"MLet text file missing mandatory CODE attribute should result in ServiceNotFoundException thrown.");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (MBeanException e) {
            MLetTEST.assertTrue((boolean)(e.getTargetException() instanceof ServiceNotFoundException));
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testArchiveListInMLet() throws Exception {
        String MLET_URL = "file:./output/etc/test/compliance/loading/ArchiveList.mlet";
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            server.registerMBean(mlet, name);
            server.invoke(name, "getMBeansFromURL", new Object[]{"file:./output/etc/test/compliance/loading/ArchiveList.mlet"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MLetTEST.class$("java.lang.String")) : class$java$lang$String).getName()});
            Class<?> c = null;
            try {
                c = mlet.loadClass("test.compliance.loading.support.AClass");
            }
            catch (ClassNotFoundException e) {
                URL[] urls = mlet.getURLs();
                MLetTEST.fail((String)("FAILS IN RI: SUN JMX RI builds a malformed URL from an MLet text file URL 'file:./output/etc/test/compliance/loading/ArchiveList.mlet' resulting into MLET codebase URL '" + urls[0] + "' and therefore fails " + "to load the required classes from the Java archive."));
            }
            Object o = c.newInstance();
            server.setAttribute(new ObjectName("test:name=AnotherTrivial"), new Attribute("Something", o));
            o = server.getAttribute(new ObjectName("test:name=AnotherTrivial"), "Something");
            MLetTEST.assertTrue((boolean)o.getClass().isAssignableFrom(c));
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnexpectedEndOfFile() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            server.registerMBean(mlet, name);
            server.invoke(name, "getMBeansFromURL", new Object[]{"file:./output/etc/test/compliance/loading/UnexpectedEnd.mlet"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MLetTEST.class$("java.lang.String")) : class$java$lang$String).getName()});
            MLetTEST.fail((String)"Unexpected end of file from mlet text file did not cause an exception.");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (MBeanException e) {
            MLetTEST.assertTrue((boolean)(e.getTargetException() instanceof ServiceNotFoundException));
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingEndMLetTag() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            server.registerMBean(mlet, name);
            server.invoke(name, "getMBeansFromURL", new Object[]{"file:./output/etc/test/compliance/loading/MissingEndTag.mlet"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MLetTEST.class$("java.lang.String")) : class$java$lang$String).getName()});
            MLetTEST.assertTrue((!server.isRegistered(new ObjectName("test:name=Trivial")) ? 1 : 0) != 0);
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (MBeanException e) {
            MLetTEST.assertTrue((boolean)(e.getTargetException() instanceof ServiceNotFoundException));
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

