/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base;

import org.jfree.base.BootableProjectInfo;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.base.modules.PackageManager;
import org.jfree.base.modules.SubSystem;
import org.jfree.util.Log;

public abstract class AbstractBoot
implements SubSystem {
    private PackageManager singleton;
    private HierarchicalConfiguration globalConfig;
    private boolean bootInProgress;
    private boolean bootDone;

    public PackageManager getPackageManager() {
        if (this.singleton == null) {
            this.singleton = PackageManager.createInstance(this);
        }
        return this.singleton;
    }

    public ModifiableConfiguration getGlobalConfig() {
        if (this.globalConfig == null) {
            this.globalConfig = this.loadConfiguration();
            this.start();
        }
        return this.globalConfig;
    }

    public boolean isBootInProgress() {
        return this.bootInProgress;
    }

    public boolean isBootDone() {
        return this.bootDone;
    }

    protected abstract HierarchicalConfiguration loadConfiguration();

    public final void start() {
        if (this.isBootInProgress() || this.isBootDone()) {
            return;
        }
        this.bootInProgress = true;
        BootableProjectInfo bootableProjectInfo = this.getProjectInfo();
        if (bootableProjectInfo != null) {
            Log.info(bootableProjectInfo.getName() + " " + bootableProjectInfo.getVersion());
            BootableProjectInfo[] bootableProjectInfoArray = bootableProjectInfo.getDependencies();
            for (int i = 0; i < bootableProjectInfoArray.length; ++i) {
                AbstractBoot abstractBoot = this.loadBooter(bootableProjectInfoArray[i].getBootClass());
                if (abstractBoot == null) continue;
                abstractBoot.start();
            }
        }
        this.performBoot();
        this.bootInProgress = false;
        this.bootDone = true;
    }

    protected abstract void performBoot();

    protected abstract BootableProjectInfo getProjectInfo();

    protected AbstractBoot loadBooter(String string) {
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
            return (AbstractBoot)clazz.newInstance();
        }
        catch (Exception exception) {
            Log.info("Unable to boot dependent class: " + string);
            return null;
        }
    }
}

