/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.soap;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Constants;
import org.jboss.axis.Message;
import org.jboss.axis.attachments.Attachments;
import org.jboss.axis.client.Call;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.utils.Messages;
import org.w3c.dom.Element;

public class SOAPConnectionImpl
extends SOAPConnection {
    boolean closed = false;

    public SOAPMessage call(SOAPMessage request, Object endpoint) throws SOAPException {
        if (this.closed) {
            throw new SOAPException(Messages.getMessage("connectionClosed00"));
        }
        try {
            Call call = this.createCall(endpoint);
            ((Message)request).setMessageContext(call.getMessageContext());
            SOAPEnvelopeAxisImpl env = ((Message)request).getSOAPEnvelope();
            Attachments attachments = ((Message)request).getAttachmentsImpl();
            if (attachments != null) {
                Iterator iterator = attachments.getAttachments().iterator();
                while (iterator.hasNext()) {
                    Object attachment = iterator.next();
                    call.addAttachmentPart(attachment);
                }
            }
            call.setReturnClass(SOAPMessage.class);
            call.invoke(env);
            return call.getResponseMessage();
        }
        catch (MalformedURLException mue) {
            throw new SOAPException((Throwable)mue);
        }
        catch (AxisFault af) {
            this.processAxisFault(af);
            Message msg = new Message(af);
            msg.setProperty("javax.xml.soap.write-xml-declaration", "true");
            msg.setMessageContext(((Message)request).getMessageContext());
            return msg;
        }
        catch (RemoteException re) {
            throw new SOAPException((Throwable)re);
        }
    }

    protected void processAxisFault(AxisFault fault) {
        Element runtimeException = fault.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_STACKTRACE);
        if (runtimeException != null) {
            fault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_STACKTRACE);
        }
    }

    protected Call createCall(Object endpoint) throws MalformedURLException {
        Call call = new Call(endpoint.toString());
        return call;
    }

    public void close() throws SOAPException {
        if (this.closed) {
            throw new SOAPException(Messages.getMessage("connectionClosed00"));
        }
        this.closed = true;
    }
}

