/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.DiscoveryURL;
import org.apache.juddi.datatype.DiscoveryURLs;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.TModelBag;
import org.apache.juddi.datatype.TModelKey;
import org.apache.juddi.datatype.request.FindBusiness;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class FindBusinessHandler
extends AbstractHandler {
    public static final String TAG_NAME = "find_business";
    private HandlerMaker maker = null;

    protected FindBusinessHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        String maxRows;
        FindBusiness obj = new FindBusiness();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String generic = element.getAttribute("generic");
        if (generic != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        if ((maxRows = element.getAttribute("maxRows")) != null && maxRows.length() > 0) {
            obj.setMaxRows(maxRows);
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "findQualifiers")).size() > 0) {
            handler = this.maker.lookup("findQualifiers");
            obj.setFindQualifiers((FindQualifiers)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "name");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("name");
            obj.addName((Name)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "identifierBag");
        if (nodeList.size() > 0) {
            handler = this.maker.lookup("identifierBag");
            obj.setIdentifierBag((IdentifierBag)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "categoryBag")).size() > 0) {
            handler = this.maker.lookup("categoryBag");
            obj.setCategoryBag((CategoryBag)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "tModelBag")).size() > 0) {
            handler = this.maker.lookup("tModelBag");
            obj.setTModelBag((TModelBag)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "discoveryURLs")).size() > 0) {
            handler = this.maker.lookup("discoveryURLs");
            obj.setDiscoveryURLs((DiscoveryURLs)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        DiscoveryURLs discURLs;
        TModelBag tModBag;
        CategoryBag catBag;
        IdentifierBag idBag;
        Vector nameVector;
        FindQualifiers qualifiers;
        int maxRows;
        FindBusiness request = (FindBusiness)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        String generic = request.getGeneric();
        if (generic != null) {
            element.setAttribute("generic", generic);
        }
        if ((maxRows = request.getMaxRows()) > 0) {
            element.setAttribute("maxRows", String.valueOf(maxRows));
        }
        if ((qualifiers = request.getFindQualifiers()) != null && qualifiers.size() > 0) {
            handler = this.maker.lookup("findQualifiers");
            handler.marshal(qualifiers, element);
        }
        if ((nameVector = request.getNameVector()) != null && nameVector.size() > 0) {
            handler = this.maker.lookup("name");
            for (int i = 0; i < nameVector.size(); ++i) {
                handler.marshal((Name)nameVector.elementAt(i), element);
            }
        }
        if ((idBag = request.getIdentifierBag()) != null) {
            handler = this.maker.lookup("identifierBag");
            handler.marshal(idBag, element);
        }
        if ((catBag = request.getCategoryBag()) != null) {
            handler = this.maker.lookup("categoryBag");
            handler.marshal(catBag, element);
        }
        if ((tModBag = request.getTModelBag()) != null) {
            handler = this.maker.lookup("tModelBag");
            handler.marshal(tModBag, element);
        }
        if ((discURLs = request.getDiscoveryURLs()) != null) {
            handler = this.maker.lookup("discoveryURLs");
            handler.marshal(discURLs, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        DiscoveryURLs discURLs = new DiscoveryURLs();
        discURLs.addDiscoveryURL(new DiscoveryURL("businessEntity", "http://www.sviens.com"));
        IdentifierBag idBag = new IdentifierBag();
        idBag.addKeyedReference(new KeyedReference("idBagKeyName", "idBagKeyValue"));
        idBag.addKeyedReference(new KeyedReference("uuid:3860b975-9e0c-4cec-bad6-87dfe00e3864", "idBagKeyName2", "idBagKeyValue2"));
        CategoryBag catBag = new CategoryBag();
        catBag.addKeyedReference(new KeyedReference("catBagKeyName", "catBagKeyValue"));
        catBag.addKeyedReference(new KeyedReference("uuid:8ff45356-acde-4a4c-86bf-f953611d20c6", "catBagKeyName2", "catBagKeyValue2"));
        TModelBag tModBag = new TModelBag();
        tModBag.addTModelKey("uuid:35d9793b-9911-4b85-9f0e-5d4c65b4f253");
        tModBag.addTModelKey(new TModelKey("uuid:c5ab113f-0d6b-4247-b3c4-8c012726acd8"));
        FindBusiness request = new FindBusiness();
        request.addName(new Name("serviceNm"));
        request.addName(new Name("serviceNm2", "en"));
        request.addFindQualifier(new FindQualifier("sortByDateAsc"));
        request.addFindQualifier(new FindQualifier("andAllKeys"));
        request.setMaxRows(43);
        request.setDiscoveryURLs(discURLs);
        request.setIdentifierBag(idBag);
        request.setTModelBag(tModBag);
        request.setCategoryBag(catBag);
        System.out.println();
        RegistryObject regObject = request;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

