/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class DescriptionHandler
extends AbstractHandler {
    public static final String TAG_NAME = "description";
    private HandlerMaker maker = null;

    protected DescriptionHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        Description obj = new Description();
        String langCode = element.getAttribute("xml:lang");
        if (langCode != null && langCode.trim().length() > 0) {
            obj.setLanguageCode(langCode);
        }
        obj.setValue(XMLUtils.getText(element));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        String descrValue;
        Description descr = (Description)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        String langCode = descr.getLanguageCode();
        if (langCode != null && langCode.trim().length() > 0) {
            element.setAttribute("xml:lang", langCode);
        }
        if ((descrValue = descr.getValue()) != null) {
            element.appendChild(parent.getOwnerDocument().createTextNode(descrValue));
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
    }
}

