/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Serializable;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.NameSpace;
import org.apache.xml.utils.PrefixResolver;
import org.w3c.dom.Element;

public class QName
implements Serializable {
    protected String _localName;
    protected String _namespaceURI;
    protected String _prefix;
    public static final String S_XMLNAMESPACEURI = "http://www.w3.org/XML/1998/namespace";
    private int m_hashCode;

    public QName() {
    }

    public QName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(XSLMessages.createXPATHMessage(70, null));
        }
        this._namespaceURI = null;
        this._localName = string;
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException(XSLMessages.createXPATHMessage(70, null));
        }
        this._namespaceURI = string;
        this._localName = string2;
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String string, String string2, String string3) {
        if (string3 == null) {
            throw new IllegalArgumentException(XSLMessages.createXPATHMessage(70, null));
        }
        this._namespaceURI = string;
        this._prefix = string2;
        this._localName = string3;
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String string, Stack stack) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(58);
        if (n > 0) {
            string3 = string.substring(0, n);
            if (string3.equals("xml")) {
                string2 = S_XMLNAMESPACEURI;
            } else {
                if (string3.equals("xmlns")) {
                    return;
                }
                int n2 = stack.size();
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    NameSpace nameSpace = (NameSpace)stack.elementAt(n3);
                    while (nameSpace != null) {
                        if (nameSpace.m_prefix != null && string3.equals(nameSpace.m_prefix)) {
                            string2 = nameSpace.m_uri;
                            n3 = -1;
                            break;
                        }
                        nameSpace = nameSpace.m_next;
                    }
                    --n3;
                }
            }
            if (string2 == null) {
                throw new RuntimeException(XSLMessages.createXPATHMessage(52, new Object[]{string3}));
            }
        }
        this._localName = n < 0 ? string : string.substring(n + 1);
        this._namespaceURI = string2;
        this._prefix = string3;
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String string, PrefixResolver prefixResolver) {
        this._namespaceURI = null;
        int n = string.indexOf(58);
        if (n > 0) {
            String string2 = string.substring(0, n);
            this._namespaceURI = string2.equals("xml") ? S_XMLNAMESPACEURI : prefixResolver.getNamespaceForPrefix(string2);
            if (this._namespaceURI == null) {
                throw new RuntimeException(XSLMessages.createXPATHMessage(52, new Object[]{string2}));
            }
        }
        this._localName = n < 0 ? string : string.substring(n + 1);
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String string, Element element, PrefixResolver prefixResolver) {
        this._namespaceURI = null;
        int n = string.indexOf(58);
        if (n > 0 && element != null) {
            String string2;
            this._prefix = string2 = string.substring(0, n);
            this._namespaceURI = string2.equals("xml") ? S_XMLNAMESPACEURI : prefixResolver.getNamespaceForPrefix(string2, element);
            if (this._namespaceURI == null) {
                throw new RuntimeException(XSLMessages.createXPATHMessage(52, new Object[]{string2}));
            }
        }
        this._localName = n < 0 ? string : string.substring(n + 1);
        this.m_hashCode = this.toString().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof QName)) return false;
        QName qName = (QName)object;
        String string = this.getNamespaceURI();
        String string2 = qName.getNamespaceURI();
        if (!this.getLocalName().equals(qName.getLocalName())) return false;
        if (string == null || string2 == null) {
            if (string != null) return false;
            if (string2 == null) return true;
            return false;
        }
        boolean bl = string.equals(string2);
        if (bl) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(String string, String string2) {
        String string3 = this.getNamespaceURI();
        if (!this.getLocalName().equals(string2)) return false;
        if (string3 == null || string == null) {
            if (string3 != null) return false;
            if (string == null) return true;
            return false;
        }
        boolean bl = string3.equals(string);
        if (bl) return true;
        return false;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getLocalPart() {
        return this.getLocalName();
    }

    public static String getLocalPart(String string) {
        int n = string.indexOf(58);
        return n < 0 ? string : string.substring(n + 1);
    }

    public String getNamespace() {
        return this.getNamespaceURI();
    }

    public String getNamespaceURI() {
        return this._namespaceURI;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public static String getPrefixFromXMLNSDecl(String string) {
        int n = string.indexOf(58);
        return n >= 0 ? string.substring(n + 1) : "";
    }

    public static String getPrefixPart(String string) {
        int n = string.indexOf(58);
        return n >= 0 ? string.substring(0, n) : "";
    }

    public static QName getQNameFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", false);
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
        QName qName = string3 == null ? new QName(null, string2) : new QName(string2, string3);
        return qName;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public static boolean isXMLNSDecl(String string) {
        return string.startsWith("xmlns") && (string.equals("xmlns") || string.startsWith("xmlns:"));
    }

    public String toNamespacedString() {
        return this._namespaceURI != null ? "{" + this._namespaceURI + "}" + this._localName : this._localName;
    }

    public String toString() {
        return this._prefix != null ? String.valueOf(this._prefix) + ":" + this._localName : (this._namespaceURI != null ? "{" + this._namespaceURI + "}" + this._localName : this._localName);
    }
}

