/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LoggableObject;

class CheckpointMonitor {
    private int bytesWritten = 0;
    private long periodInBytes;
    private EnvironmentImpl envImpl;

    CheckpointMonitor(EnvironmentImpl envImpl) throws DatabaseException {
        this.periodInBytes = envImpl.getConfigManager().getLong(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL);
        this.envImpl = envImpl;
    }

    boolean recordLogWrite(int entrySize, LoggableObject item) {
        this.bytesWritten += entrySize;
        return (long)this.bytesWritten >= this.periodInBytes;
    }

    void activate() {
        this.envImpl.getCheckpointer().wakeup();
        this.bytesWritten = 0;
    }
}

