/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.txn.AutoTxn;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class UtilizationProfile {
    private EnvironmentImpl env;
    private UtilizationTracker tracker;
    private DatabaseImpl fileSummaryDb;
    private SortedMap fileSummaryMap;
    private boolean cachePopulated;
    private long totalLogSize;
    private int minUtilization;
    private int minAge;
    private int obsoleteAge;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UtilizationProfile(EnvironmentImpl env, UtilizationTracker tracker) throws DatabaseException {
        this.env = env;
        this.tracker = tracker;
        this.fileSummaryMap = new TreeMap();
        this.minAge = env.getConfigManager().getInt(EnvironmentParams.CLEANER_MIN_AGE);
        this.minUtilization = env.getConfigManager().getInt(EnvironmentParams.CLEANER_MIN_UTILIZATION);
        this.obsoleteAge = env.getConfigManager().getInt(EnvironmentParams.CLEANER_OBSOLETE_AGE);
    }

    final int getObsoleteAge() {
        return this.obsoleteAge;
    }

    synchronized int getNumberOfFiles() throws DatabaseException {
        this.populateCache();
        return this.fileSummaryMap.size();
    }

    synchronized Long getBestFileForCleaning(Set excludeFiles, boolean aggressive) throws DatabaseException {
        this.populateCache();
        if (this.fileSummaryMap.size() == 0) {
            return null;
        }
        DbLsn firstActiveLsn = this.env.getCheckpointer().getFirstActiveLsn();
        if (firstActiveLsn == null) {
            return null;
        }
        Iterator iter = this.fileSummaryMap.keySet().iterator();
        int fileIndex = 0;
        Long bestFile = null;
        int bestUtilization = 101;
        long totalSize = 0L;
        long totalObsoleteSize = 0L;
        while (iter.hasNext()) {
            Long file = (Long)iter.next();
            long fileNum = file;
            if (firstActiveLsn.getFileNumber() - fileNum < (long)this.minAge || excludeFiles.contains(file)) continue;
            FileSummary summary = (FileSummary)this.fileSummaryMap.get(file);
            summary = this.addTrackedSummary(summary, fileNum);
            int obsoleteSize = summary.getObsoleteSize(fileIndex, this);
            totalObsoleteSize += (long)obsoleteSize;
            totalSize += (long)summary.totalSize;
            int thisUtilization = UtilizationProfile.utilization(obsoleteSize, summary.totalSize);
            if (bestFile == null || thisUtilization < bestUtilization) {
                bestFile = file;
                bestUtilization = thisUtilization;
            }
            ++fileIndex;
        }
        int totalUtilization = UtilizationProfile.utilization(totalObsoleteSize, totalSize);
        if (aggressive || totalUtilization < this.minUtilization) {
            return bestFile;
        }
        return null;
    }

    public static int utilization(long obsoleteSize, long totalSize) {
        if (totalSize != 0L) {
            return (int)((totalSize - obsoleteSize) * 100L / totalSize);
        }
        return 0;
    }

    private FileSummary addTrackedSummary(FileSummary summary, long fileNum) {
        TrackedFileSummary trackedSummary = this.tracker.getTrackedFile(fileNum);
        if (trackedSummary != null) {
            FileSummary totals = new FileSummary();
            totals.add(summary);
            totals.add(trackedSummary);
            summary = totals;
        }
        return summary;
    }

    long getTotalLogSize(boolean calcIfNecessary) throws DatabaseException {
        if (calcIfNecessary) {
            this.populateCache();
        }
        if (this.cachePopulated) {
            return this.totalLogSize + this.tracker.getLogSizeDelta();
        }
        return -1L;
    }

    public synchronized SortedMap getFileSummaryMap(boolean includeTrackedFiles) throws DatabaseException {
        this.populateCache();
        if (includeTrackedFiles) {
            TreeMap<Long, FileSummary> map = new TreeMap<Long, FileSummary>();
            Iterator iter = this.fileSummaryMap.keySet().iterator();
            while (iter.hasNext()) {
                Long file = (Long)iter.next();
                long fileNum = file;
                FileSummary summary = (FileSummary)this.fileSummaryMap.get(file);
                summary = this.addTrackedSummary(summary, fileNum);
                map.put(file, summary);
            }
            TrackedFileSummary[] trackedFiles = this.tracker.getTrackedFiles();
            for (int i = 0; i < trackedFiles.length; ++i) {
                TrackedFileSummary summary = trackedFiles[i];
                long fileNum = summary.getFileNumber();
                Long file = new Long(fileNum);
                if (map.containsKey(file)) continue;
                map.put(file, summary);
            }
            return map;
        }
        return new TreeMap(this.fileSummaryMap);
    }

    public synchronized void clearCache() {
        this.fileSummaryMap = new TreeMap();
        this.cachePopulated = false;
        this.totalLogSize = 0L;
    }

    private synchronized void populateCache() throws DatabaseException {
        if (!this.cachePopulated) {
            FileManager fileManager = this.env.getFileManager();
            Long[] nums = fileManager.getAllFileNumbers();
            for (int i = 0; i < nums.length; ++i) {
                this.getFileSummary(nums[i]);
            }
            this.cachePopulated = true;
        }
    }

    private synchronized void cacheFileSummary(long fileNum, FileSummary summary) {
        FileSummary oldSummary = this.fileSummaryMap.put(new Long(fileNum), summary);
        if (oldSummary != null) {
            this.totalLogSize -= (long)oldSummary.totalSize;
        }
        this.totalLogSize += (long)summary.totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeFile(Long fileNum) throws DatabaseException {
        BasicLocker locker;
        block8: {
            FileSummary oldSummary = (FileSummary)this.fileSummaryMap.remove(fileNum);
            if (oldSummary != null) {
                this.totalLogSize -= (long)oldSummary.totalSize;
            }
            boolean opened = this.openFileSummaryDatabase();
            if (!$assertionsDisabled && !opened) {
                throw new AssertionError();
            }
            locker = null;
            CursorImpl cursor = null;
            try {
                locker = new BasicLocker(this.env);
                cursor = new CursorImpl(this.fileSummaryDb, locker);
                byte[] keyBytes = FileSummaryLN.fileNumberToBytes(fileNum);
                DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
                int result = cursor.searchAndPosition(keyEntry, new DatabaseEntry(), CursorImpl.SearchMode.SET, null);
                if ((result & 1) != 0) {
                    cursor.delete();
                }
                Object var10_9 = null;
                if (cursor == null) break block8;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (cursor != null) {
                    cursor.releaseBINs();
                    cursor.close();
                }
                if (locker != null) {
                    ((Locker)locker).operationEnd();
                }
                throw throwable;
            }
            cursor.releaseBINs();
            cursor.close();
        }
        if (locker != null) {
            ((Locker)locker).operationEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized FileSummary getFileSummary(Long fileNum) throws DatabaseException {
        FileSummary fileSummary;
        BasicLocker locker;
        block10: {
            CursorImpl cursor;
            block8: {
                FileSummary fileSummary2;
                block9: {
                    FileSummary summary = (FileSummary)this.fileSummaryMap.get(fileNum);
                    if (summary != null) {
                        return summary;
                    }
                    if (!this.openFileSummaryDatabase()) {
                        return null;
                    }
                    locker = null;
                    cursor = null;
                    try {
                        locker = new BasicLocker(this.env);
                        cursor = new CursorImpl(this.fileSummaryDb, locker);
                        byte[] keyBytes = FileSummaryLN.fileNumberToBytes(fileNum);
                        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
                        int result = cursor.searchAndPosition(keyEntry, new DatabaseEntry(), CursorImpl.SearchMode.SET, null);
                        if ((result & 1) == 0) break block8;
                        FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLNAlreadyLatched(LockMode.DEFAULT);
                        summary = ln.getBaseSummary();
                        this.cacheFileSummary(fileNum, summary);
                        fileSummary2 = summary;
                        Object var11_11 = null;
                        if (cursor == null) break block9;
                    }
                    catch (Throwable throwable) {
                        block11: {
                            Object var11_13 = null;
                            if (cursor != null) {
                                cursor.releaseBINs();
                                cursor.close();
                            }
                            if (locker == null) break block11;
                            ((Locker)locker).operationEnd();
                        }
                        throw throwable;
                    }
                    cursor.releaseBINs();
                    cursor.close();
                }
                if (locker != null) {
                    ((Locker)locker).operationEnd();
                }
                return fileSummary2;
            }
            fileSummary = null;
            Object var11_12 = null;
            if (cursor == null) break block10;
            cursor.releaseBINs();
            cursor.close();
        }
        if (locker != null) {
            ((Locker)locker).operationEnd();
        }
        return fileSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized FileSummary putFileSummary(TrackedFileSummary trackedSummary) throws DatabaseException {
        if (this.env.isReadOnly()) {
            throw new DatabaseException("Cannot write file summary in a read-only environment");
        }
        if (trackedSummary.isEmpty()) {
            return null;
        }
        boolean opened = this.openFileSummaryDatabase();
        if (!$assertionsDisabled && !opened) {
            throw new AssertionError();
        }
        long fileNum = trackedSummary.getFileNumber();
        Long fileNumLong = new Long(fileNum);
        byte[] keyBytes = FileSummaryLN.fileNumberToBytes(fileNum);
        int oldTotalSize = 0;
        FileSummary oldSummary = (FileSummary)this.fileSummaryMap.get(fileNumLong);
        if (oldSummary != null) {
            oldTotalSize = oldSummary.totalSize;
        }
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            FileSummaryLN ln;
            block15: {
                block14: {
                    locker = new BasicLocker(this.env);
                    ln = null;
                    try {
                        cursor = new CursorImpl(this.fileSummaryDb, locker);
                        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
                        int result = cursor.searchAndPosition(keyEntry, new DatabaseEntry(), CursorImpl.SearchMode.SET, null);
                        if ((result & 1) != 0) {
                            ln = (FileSummaryLN)cursor.getCurrentLNAlreadyLatched(LockMode.DEFAULT);
                            ln.setTrackedSummary(trackedSummary);
                            DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
                            cursor.putCurrent(dataDbt, null, null);
                        }
                        Object var16_15 = null;
                        if (cursor == null) break block14;
                    }
                    catch (Throwable throwable) {
                        Object var16_16 = null;
                        if (cursor == null) throw throwable;
                        cursor.releaseBINs();
                        cursor.close();
                        cursor = null;
                        throw throwable;
                    }
                    cursor.releaseBINs();
                    cursor.close();
                    cursor = null;
                }
                if (ln == null) {
                    try {
                        cursor = new CursorImpl(this.fileSummaryDb, locker);
                        ln = new FileSummaryLN(new FileSummary());
                        ln.setTrackedSummary(trackedSummary);
                        cursor.releaseBINs();
                        cursor.putLN(new Key(keyBytes), ln, false);
                        Object var18_18 = null;
                        if (cursor == null) break block15;
                    }
                    catch (Throwable throwable) {
                        Object var18_19 = null;
                        if (cursor == null) throw throwable;
                        cursor.close();
                        cursor = null;
                        throw throwable;
                    }
                    cursor.close();
                    cursor = null;
                }
            }
            FileSummary summary = ln.getBaseSummary();
            this.fileSummaryMap.put(fileNumLong, summary);
            this.totalLogSize -= (long)oldTotalSize;
            this.totalLogSize += (long)summary.totalSize;
            FileSummary fileSummary = summary;
            return fileSummary;
        }
        finally {
            if (locker != null) {
                ((Locker)locker).operationEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean openFileSummaryDatabase() throws DatabaseException {
        if (this.fileSummaryDb != null) {
            return true;
        }
        DbTree dbTree = this.env.getDbMapTree();
        Locker autoTxn = null;
        boolean operationOk = false;
        try {
            autoTxn = new AutoTxn(this.env, new TransactionConfig());
            DatabaseImpl db = dbTree.getDb(autoTxn, "_jeUtilization", null);
            if (db == null) {
                if (this.env.isReadOnly()) {
                    boolean bl = false;
                    return bl;
                }
                db = dbTree.createDb(autoTxn, "_jeUtilization", new DatabaseConfig(), null);
            }
            this.fileSummaryDb = db;
            operationOk = true;
            boolean bl = true;
            return bl;
        }
        finally {
            if (autoTxn != null) {
                autoTxn.operationEnd(operationOk);
            }
        }
    }

    static {
        $assertionsDisabled = !UtilizationProfile.class.desiredAssertionStatus();
    }
}

